<?php
require __DIR__ . '/db.php';
header('Content-Type: application/json; charset=utf-8');

if (!$conn) {
  echo json_encode(['success' => false, 'error' => 'Database tidak terhubung']);
  exit;
}

$range = isset($_GET['range']) ? (int)$_GET['range'] : 7;
if (!in_array($range, [7, 30, 60, 90], true)) {
  $range = 7;
}

$sql = "
  SELECT tanggal, COUNT(*) AS total
  FROM attendance_daily
  WHERE tanggal >= DATE_SUB(CURDATE(), INTERVAL ? DAY)
  GROUP BY tanggal
  ORDER BY tanggal ASC
";

$stmt = $conn->prepare($sql);
if (!$stmt) {
  echo json_encode(['success' => false, 'error' => 'Prepare gagal: ' . $conn->error]);
  exit;
}

$stmt->bind_param('i', $range);
$stmt->execute();
$res = $stmt->get_result();

$labels = [];
$values = [];

while ($row = $res->fetch_assoc()) {
  $labels[] = $row['tanggal'];
  $values[] = (int)$row['total'];
}

$stmt->close();

echo json_encode([
  'success' => true,
  'range'   => $range,
  'labels'  => $labels,
  'values'  => $values
]);
