<?php
require __DIR__ . '/db.php';

// Fungsi respon JSON cepat
function jsonResponse($data) {
  header('Content-Type: application/json; charset=utf-8');
  echo json_encode($data, JSON_PRETTY_PRINT);
  exit;
}

// Validasi koneksi
if (!$conn) {
  jsonResponse(['success' => false, 'error' => 'Database tidak terhubung']);
}

$start = $_GET['start'] ?? date('Y-m-01');
$end   = $_GET['end'] ?? date('Y-m-t');

$sql = "
  SELECT 
    c.id AS class_id,
    c.name AS kelas,
    MONTH(a.tanggal) AS bulan,
    COUNT(CASE WHEN a.status = 'Hadir' THEN 1 END) AS total_hadir,
    COUNT(DISTINCT DATE(a.tanggal)) AS total_kegiatan,
    (SELECT COUNT(*) FROM students s WHERE s.class_id = c.id) AS total_siswa,
    ROUND(
      (
        COUNT(CASE WHEN a.status = 'Hadir' THEN 1 END) /
        ( (SELECT COUNT(*) FROM students s WHERE s.class_id = c.id) * 
          NULLIF(COUNT(DISTINCT DATE(a.tanggal)), 0) )
      ) * 100, 1
    ) AS persen
  FROM attendance_daily a
  LEFT JOIN classes c ON a.class_id = c.id
  WHERE a.tanggal BETWEEN ? AND ?
  GROUP BY c.id, c.name, MONTH(a.tanggal)
  ORDER BY c.name, MONTH(a.tanggal)
";

$stmt = $conn->prepare($sql);
if (!$stmt) {
  jsonResponse(['success' => false, 'error' => 'Prepare gagal: ' . $conn->error]);
}

$stmt->bind_param('ss', $start, $end);
$stmt->execute();
$res = $stmt->get_result();

$data = [];
while ($row = $res->fetch_assoc()) {
  $kelas = $row['kelas'];
  if (!isset($data[$kelas])) {
    $data[$kelas] = [];
  }
  $data[$kelas][] = [
    'bulan'  => (int)$row['bulan'],
    'hadir'  => (int)$row['total_hadir'],
    'persen' => (float)($row['persen'] ?? 0)
  ];
}

$stmt->close();

// === Hitung tambahan insight (Top, Bottom, dan rata-rata total) ===
$insight = [];
if (!empty($data)) {
  $avgMap = [];
  foreach ($data as $kelas => $bulanData) {
    $avg = array_sum(array_column($bulanData, 'persen')) / count($bulanData);
    $avgMap[$kelas] = round($avg, 1);
  }

  arsort($avgMap);
  $insight['top3'] = array_slice($avgMap, 0, 3, true);
  asort($avgMap);
  $insight['bottom1'] = array_slice($avgMap, 0, 1, true);
  $insight['avg_total'] = round(array_sum($avgMap) / count($avgMap), 1);
}

jsonResponse([
  'success' => true,
  'data' => $data,
  'insight' => $insight
]);
