<?php
// ===============================================
// AUTH & SESSION PROTECTION (Aman untuk XAMPP & Hosting)
// ===============================================

// Start session hanya sekali
if (session_status() === PHP_SESSION_NONE) {
    session_start();
}

// Pastikan koneksi database tersedia
require_once __DIR__ . '/db.php';

/**
 * ===========================
 * PROTEKSI LOGIN GLOBAL
 * ===========================
 * - Jika belum login: redirect ke /system-absent/login.php (aman untuk XAMPP)
 * - Jika di hosting (pakai .htaccess): otomatis diarahkan ke /login
 */
$loginPath = file_exists(__DIR__ . '/../login.php') ? '/system-absent/login.php' : '/login';
if (!isset($_SESSION['user_id'])) {
    header("Location: $loginPath");
    exit;
}

/**
 * ===========================
 * FUNGSI AKSES MENU (izin)
 * ===========================
 */
function canAccess($menu_name, $action = 'view') {
    global $conn;

    $user_id = $_SESSION['user_id'] ?? 0;
    $tag = $_SESSION['tag'] ?? '';

    // Admin = akses penuh
    if (strtolower($tag) === 'admin') return true;
    if ($user_id == 0) return false;

    $allowed_actions = ['view', 'add', 'edit', 'delete'];
    if (!in_array($action, $allowed_actions)) return false;

    $menu_name = $conn->real_escape_string($menu_name);
    $menu = $conn->query("SELECT id FROM menu_list WHERE menu_name = '$menu_name' LIMIT 1");
    if (!$menu || $menu->num_rows == 0) return false;

    $menu_id = (int)$menu->fetch_assoc()['id'];

    $izin = $conn->query("
        SELECT can_{$action} AS izin
        FROM user_access
        WHERE user_id = $user_id AND menu_id = $menu_id
        LIMIT 1
    ");
    $row = $izin ? $izin->fetch_assoc() : null;
    return ($row && (int)$row['izin'] === 1);
}

/**
 * ===========================
 * CEK ROLE ADMIN
 * ===========================
 */
function isAdmin() {
    return isset($_SESSION['tag']) && strtolower($_SESSION['tag']) === 'admin';
}

/**
 * ===========================
 * USER AKTIF SAAT INI
 * ===========================
 */
function currentUser() {
    return $_SESSION['username'] ?? 'Unknown User';
}

/**
 * ===========================
 * LOG AKTIVITAS USER
 * ===========================
 */
function logActivity($menu = null, $action = 'view') {
    global $conn;
    if (!isset($_SESSION['user_id'])) return;

    $user_id  = (int)$_SESSION['user_id'];
    $username = $conn->real_escape_string($_SESSION['username'] ?? 'Guest');
    $ip       = $conn->real_escape_string($_SERVER['REMOTE_ADDR'] ?? '0.0.0.0');

    $menu   = $conn->real_escape_string($menu ?: basename($_SERVER['PHP_SELF']));
    $action = $conn->real_escape_string($action);

    $check = $conn->query("SHOW COLUMNS FROM user_activity_log LIKE 'created_at'");
    if ($check && $check->num_rows > 0) {
        $conn->query("
            INSERT INTO user_activity_log (user_id, username, menu, action, ip_address, created_at)
            VALUES ($user_id, '$username', '$menu', '$action', '$ip', NOW())
        ");
    } else {
        $conn->query("
            INSERT INTO user_activity_log (user_id, username, menu, action, ip_address)
            VALUES ($user_id, '$username', '$menu', '$action', '$ip')
        ");
    }
}
?>
