<?php
// ===============================
// CONFIG.PHP — Global Path Helper
// ===============================

// 1️⃣ Deteksi protokol (http / https)
$protocol = (!empty($_SERVER['HTTPS']) && $_SERVER['HTTPS'] !== 'off' 
             || $_SERVER['SERVER_PORT'] == 443) ? "https://" : "http://";

// 2️⃣ Ambil host dan base folder
$host = $_SERVER['HTTP_HOST'] ?? 'localhost';
$baseFolder = '/system-absent'; // <-- ubah sesuai nama folder project kamu di htdocs

// 3️⃣ Buat base URL otomatis
define('BASE_URL', $protocol . $host . $baseFolder);

// 4️⃣ Buat shortcut untuk asset
define('ASSET_URL', BASE_URL . '/assets');
define('CSS_URL', ASSET_URL . '/css');
define('JS_URL', ASSET_URL . '/js');
define('IMG_URL', ASSET_URL . '/img');
define('MODULE_URL', BASE_URL . '/modules');

// 5️⃣ Path file di server (untuk require/include PHP)
define('BASE_PATH', __DIR__ . '/..');
define('MODULE_PATH', BASE_PATH . '/modules');
define('VENDOR_PATH', BASE_PATH . '/vendor');
define('ASSET_PATH', BASE_PATH . '/assets');
function load_assets() {
  echo '<link rel="stylesheet" href="' . CSS_URL . '/style.css">';
  echo '<script src="' . JS_URL . '/main.js"></script>';
}
?>