<?php
header('Content-Type: application/json; charset=utf-8');
require __DIR__ . '/db.php';

if (!isset($conn) || !$conn) {
    echo json_encode(['error' => 'Database connection failed']);
    exit;
}

try {
    $sql = "
        SELECT id, title, event_date 
        FROM announcements
        WHERE status = 'Aktif'
        ORDER BY event_date ASC
        LIMIT 5
    ";
    $result = $conn->query($sql);
    $notifications = [];

    if ($result && $result->num_rows > 0) {
        while ($r = $result->fetch_assoc()) {
            $notifications[] = [
                'id' => (int)$r['id'],
                'title' => $r['title'],
                'event_date' => $r['event_date']
            ];
        }
    }

    echo json_encode($notifications, JSON_UNESCAPED_UNICODE);

} catch (Throwable $e) {
    // log error agar bisa dilihat di hosting
    file_put_contents(__DIR__ . '/fetch_error_log.txt', date('Y-m-d H:i:s') . ' - ' . $e->getMessage() . "\n", FILE_APPEND);
    echo json_encode(['error' => $e->getMessage()]);
}
