<?php
error_reporting(E_ALL);
ini_set('display_errors', 1);

if (session_status() === PHP_SESSION_NONE) {
    session_start();
}
if (!isset($_SESSION['user_id'])) header("Location: /system-absent/index.php");

require __DIR__ . '/db.php';
if (!isset($conn) || !$conn) {
  die("<pre style='color:red'>[ERROR] Database connection gagal di layout.php</pre>");
}

// --- Ambil pengumuman aktif untuk dropdown ---
$notifStmt = $conn->prepare("SELECT id, title, event_date FROM announcements WHERE status = 'Aktif' ORDER BY event_date DESC LIMIT 3");
if (!$notifStmt) {
  die("<pre style='color:orange'>[ERROR] Query prepare gagal: " . $conn->error . "</pre>");
}
$notifStmt->execute();
$notifs = $notifStmt->get_result();
// Ambil nama user yang login untuk ditampilkan di navbar
if (isset($_SESSION['username']) || isset($_SESSION['user_id'])) {
    $namaLengkap = null;

    // 1️⃣ Prioritas pertama: berdasarkan ID
    if (isset($_SESSION['user_id'])) {
        $stmt = $conn->prepare("SELECT nama FROM users WHERE id = ?");
        $stmt->bind_param("i", $_SESSION['user_id']);
        $stmt->execute();
        $stmt->bind_result($namaLengkap);
        $stmt->fetch();
        $stmt->close();
    }

    // 2️⃣ Jika nama belum ketemu, coba berdasarkan username / email
    if (!$namaLengkap && isset($_SESSION['username'])) {
        $stmt = $conn->prepare("SELECT nama FROM users WHERE username = ? OR email = ?");
        $stmt->bind_param("ss", $_SESSION['username'], $_SESSION['username']);
        $stmt->execute();
        $stmt->bind_result($namaLengkap);
        $stmt->fetch();
        $stmt->close();
    }

    // Simpan ke session biar tidak query terus
    $_SESSION['nama_lengkap'] = $namaLengkap ?? $_SESSION['username'] ?? 'Admin';
}
?>
<!DOCTYPE html>
<html lang="id">
<head>
  <meta charset="UTF-8">
  <meta name="viewport" content="width=device-width, initial-scale=1.0">
  <script src="https://cdn.tailwindcss.com"></script>

<script>
document.addEventListener("DOMContentLoaded", () => {
  // Tampilkan halaman
  document.body.classList.add("ready");
  document.querySelector("main")?.classList.add("loaded");

  // Sembunyikan loader
  const loader = document.getElementById("loaderWrapper");
  if (loader) {
    loader.classList.add("fade-out");
    setTimeout(() => loader.remove(), 400);
  }

  // Fail-safe: kalau DOM belum siap total dalam 3 detik, tetap tampilkan
  setTimeout(() => {
    if (!document.body.classList.contains("ready")) {
      document.body.classList.add("ready");
      document.querySelector("main")?.classList.add("loaded");
      loader?.classList.add("fade-out");
      setTimeout(() => loader?.remove(), 400);
      console.warn("⚠️ Timeout: Loader dipaksa hilang otomatis.");
    }
  }, 3000);
});
</script>


  <link rel="icon" type="image/png" href="/system-absent/assets/icons/logo.png">
  <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.5.0/css/all.min.css">
  <title><?= $title ?? 'Dashboard' ?> - System Absent</title>

  <style>
    /* ========== PRELOAD BODY ========== */
    body {
      visibility: hidden;
      opacity: 0;
      transition: opacity 0.4s ease-in-out;
      background-color: #0E1525;
    }
    body.ready {
      visibility: visible;
      opacity: 1;
    }

    /* ========== FADE-IN KONTEN ========== */
    main {
      opacity: 0;
      transition: opacity 0.4s ease-in-out;
    }
    main.loaded {
      opacity: 1;
    }

    /* ========== LOADING OVERLAY ========== */
    #loaderWrapper {
      position: fixed;
      top: 0; left: 0;
      width: 100%; height: 100vh;
      background: #0E1525;
      display: flex;
      align-items: center;
      justify-content: center;
      flex-direction: column;
      z-index: 9999;
      transition: opacity 0.4s ease-in-out;
    }

    .spinner {
      border: 4px solid rgba(255,255,255,0.1);
      border-top: 4px solid #8CE0FF;
      border-radius: 50%;
      width: 50px;
      height: 50px;
      animation: spin 1s linear infinite;
    }

    @keyframes spin {
      0% { transform: rotate(0deg); }
      100% { transform: rotate(360deg); }
    }

    .loader-text {
      margin-top: 16px;
      color: #8CE0FF;
      font-weight: 500;
      letter-spacing: 1px;
      font-family: 'Inter', sans-serif;
      font-size: 14px;
      opacity: 0.8;
    }
    
    /* === Geser judul "System Absent" di mobile biar gak ketutupan toggle === */
@media (max-width: 768px) {
  header .flex.items-center.gap-2.md\:gap-3 {
    margin-left: 48px; /* geser ke kanan, sesuaikan kalau masih terlalu dekat */
  }
}

  </style>
</head>

<body class="bg-[#0E1525] text-[#E6EEF9] font-[Inter]">
    <!-- ========== LOADER OVERLAY ========== -->
  <div id="loaderWrapper">
    <div class="spinner"></div>
    <div class="loader-text">Memuat Dashboard...</div>
  </div>
  <!-- ========== /LOADER ========== -->

  <?php include __DIR__.'/sidebar.php'; ?>

    <!-- ========================= NAVBAR ========================= -->
  <header
    class="fixed top-0 left-0 right-0 h-14 md:h-16 bg-[#101827]/80 backdrop-blur-xl border-b border-white/10 shadow-lg flex items-center justify-between px-3 md:px-6 z-50 pl-3 md:pl-[90px] transition-all duration-300">

    <!-- LEFT: Brand -->
    <div class="flex items-center gap-2 md:gap-3">
      <div
        class="bg-[#8CE0FF]/10 p-2 rounded-xl border border-[#8CE0FF]/30 shadow-inner md:animate-pulse-slow flex items-center justify-center">
        <i class="fa-solid fa-fingerprint text-[#8CE0FF] text-lg md:text-xl"></i>
      </div>
      <div class="leading-tight">
        <a href="/system-absent/dashboard" 
   class="block text-[#8CE0FF] font-semibold text-sm md:text-lg tracking-wide truncate max-w-[140px] sm:max-w-none hover:text-[#B8E8FF] transition">
  System Absent
</a>

        <span class="text-gray-400 text-[10px] md:text-xs tracking-wider hidden xs:block">
          Smart Attendance Dashboard
        </span>
      </div>
    </div>

    <!-- CENTER: Date + Time (desktop only) -->
    <div class="hidden md:flex flex-col items-center text-gray-300 text-sm">
      <div class="flex items-center gap-2">
        <i class="fa-regular fa-calendar text-[#8CE0FF]"></i>
        <span id="tanggalSekarang"><?= date('l, d F Y') ?></span>
      </div>
      <div class="flex items-center gap-2 text-gray-500 text-xs mt-0.5">
        <i class="fa-regular fa-clock text-[#8CE0FF]/80"></i>
        <span id="jamSekarang"><?= date('H:i:s') ?></span>
      </div>
    </div>

    <!-- RIGHT: Actions -->
    <div class="flex items-center gap-3 md:gap-6">

      <!-- 🔔 Notifikasi -->
      <div class="relative dropdown">
        <button id="notifButton" class="relative hover:text-[#8CE0FF] transition dropdown-toggle">
          <i class="fa-solid fa-bell text-gray-300 text-lg"></i>
          <?php if ($notifs->num_rows > 0): ?>
            <span id="notifBadge"
                  class="absolute -top-1 -right-1 bg-red-500 text-white text-[10px] px-1.5 rounded-full animate-pulse">
              <?= $notifs->num_rows ?>
            </span>
          <?php endif; ?>
        </button>

        <div id="notifDropdown"
             class="absolute right-0 mt-2 w-72 bg-[#141D2F]/95 border border-[#2A3550] rounded-xl shadow-xl hidden dropdown-menu z-50 overflow-hidden animate-fadeIn">
          <div class="px-4 py-2 border-b border-[#2A3550] text-[#8CE0FF] text-sm font-semibold flex items-center gap-2">
            <i class="fa-solid fa-bullhorn"></i> Pengumuman Terbaru
          </div>

          <div id="notifList" class="max-h-56 overflow-y-auto text-sm">
            <?php if ($notifs->num_rows > 0): ?>
              <?php while($n = $notifs->fetch_assoc()): ?>
                <a href="/system-absent/modules/pengumuman/index.php#pengumuman-<?= $n['id'] ?>"
                   class="block px-4 py-2 hover:bg-[#1E2942] text-gray-300 transition">
                  📅 <?= htmlspecialchars($n['title']) ?>
                  <div class="text-xs text-gray-400">
                    <?= date('d/m/Y H:i', strtotime($n['event_date'])) ?>
                  </div>
                </a>
              <?php endwhile; ?>
            <?php else: ?>
              <div class="px-4 py-3 text-gray-400 text-center text-xs">Belum ada pengumuman aktif.</div>
            <?php endif; ?>
          </div>

          <div class="text-center border-t border-[#2A3550]">
            <a href="/system-absent/modules/pengumuman/index.php"
               class="block py-2 text-xs text-gray-400 hover:text-[#8CE0FF] transition">
              Lihat semua pengumuman
            </a>
          </div>
        </div>
      </div>

      <!-- ⚡ Quick Menu (disembunyikan di layar kecil biar rapi) -->
      <div class="relative dropdown hidden sm:block">
        <button class="flex items-center gap-1 text-gray-300 hover:text-[#8CE0FF] transition dropdown-toggle text-xs md:text-sm">
          <span class="hidden md:inline">Quick</span>
          <i class="fa-solid fa-chevron-down text-[10px] md:text-xs"></i>
        </button>
        <div
          class="absolute right-0 mt-2 w-52 bg-[#141D2F]/95 border border-[#2A3550] rounded-xl shadow-xl hidden dropdown-menu z-50 overflow-hidden animate-fadeIn">
          <a href="/system-absent/modules/absensi_kelas/rekap_harian.php"
             class="flex items-center gap-2 px-4 py-2 hover:bg-[#1E2942] text-sm text-gray-300 transition-all">
            <i class="fa-regular fa-file-lines text-[#8CE0FF]"></i> Rekap Harian
          </a>
          <a href="/system-absent/modules/qr_absen/daftar_token.php"
             class="flex items-center gap-2 px-4 py-2 hover:bg-[#1E2942] text-sm text-gray-300 transition-all">
            <i class="fa-solid fa-chart-column text-[#8CE0FF]"></i> Link Kegiatan rutin
          </a>
          <a href="/system-absent/modules/rekap/list.php"
             class="flex items-center gap-2 px-4 py-2 hover:bg-[#1E2942] text-sm text-gray-300 transition-all">
            <i class="fa-solid fa-bullhorn text-[#8CE0FF]"></i> Link Rekap
          </a>
        </div>
      </div>

      <!-- 👤 Profil -->
      <div class="relative dropdown">
        <a href="/system-absent/modules/profile.php"
           class="flex items-center gap-2 cursor-pointer dropdown-toggle hover:bg-[#1E2B44]/60 px-2 py-1 rounded-lg transition">
          <img src="/system-absent/assets/user.jpg" alt="User"
               class="w-8 h-8 md:w-9 md:h-9 rounded-full border border-[#8CE0FF]/60 shadow-md">
          <div class="hidden md:flex flex-col leading-tight">
            <span class="text-sm font-medium text-gray-200">
              <?= $_SESSION['nama_lengkap'] ?? $_SESSION['username'] ?? 'Admin' ?>
            </span>
            <span class="text-[11px] text-gray-500">Online</span>
          </div>
          <i class="fa-solid fa-chevron-down text-[10px] md:text-xs text-gray-400"></i>
        </a>
        <div
          class="absolute right-0 mt-2 bg-[#141D2F]/95 border border-[#2A3550] rounded-xl shadow-xl w-40 md:w-48 hidden dropdown-menu z-50 overflow-hidden animate-fadeIn">
          <a href="/system-absent/modules/profile.php"
             class="block px-4 py-2 text-sm hover:bg-[#1E2942] text-gray-300 transition">👤 Profil</a>
          <a href="/system-absent/logout.php"
             class="block px-4 py-2 text-sm hover:bg-[#1E2942] text-red-400 transition">🚪 Logout</a>
        </div>
      </div>
    </div>
  </header>

  <div class="h-16"></div>

  <!-- ========================= CONTENT ========================= -->
  <div class="content-wrapper">
    <main class="p-2"><?= $content ?? '' ?></main>
  </div>


  <!-- ========================= FOOTER ========================= -->
  <footer
    class="border-t border-[#1E2B44] bg-[#101827]/95 backdrop-blur-md text-center text-gray-500 text-xs py-4 fixed bottom-0 left-0 w-full z-40">
    © <?= date('Y') ?> <span class="text-[#8CE0FF] font-medium">System Absent</span>. All rights reserved.
  </footer>
  
  <!-- ========================= TOAST NOTIFICATION ========================= -->
  <div id="toastBox" class="fixed top-20 left-1/2 -translate-x-1/2 z-[99999] flex flex-col gap-3 items-center pointer-events-none"></div>

  <!-- ========================= SCRIPT ========================= -->
  <script>
  // Jam realtime
  function updateTime() {
    const now = new Date();
    document.getElementById('jamSekarang').textContent = now.toLocaleTimeString('id-ID', { hour12: false });
  }
  setInterval(updateTime, 1000);

  // Dropdown: hover di desktop, klik di mobile + auto-close kalau klik di luar
  document.querySelectorAll('.dropdown').forEach(drop => {
    const menu   = drop.querySelector('.dropdown-menu');
    const toggle = drop.querySelector('.dropdown-toggle');
    if (!menu || !toggle) return;

    let timer;

    // 🖱️ Hover untuk desktop (≥ 768px)
    drop.addEventListener('mouseenter', () => {
      if (window.innerWidth >= 768) {
        clearTimeout(timer);
        menu.classList.remove('hidden');
        menu.classList.add('block');
      }
    });

    drop.addEventListener('mouseleave', () => {
      if (window.innerWidth >= 768) {
        timer = setTimeout(() => {
          menu.classList.remove('block');
          menu.classList.add('hidden');
        }, 200);
      }
    });

    // 📱 Klik untuk mobile (< 768px)
    toggle.addEventListener('click', (e) => {
      if (window.innerWidth < 768) {
        e.preventDefault(); // cegah <a href="..."> langsung pindah halaman di mobile

        // Tutup semua dropdown lain dulu
        document.querySelectorAll('.dropdown .dropdown-menu').forEach(m => {
          if (m !== menu) {
            m.classList.remove('block');
            m.classList.add('hidden');
          }
        });

        // Toggle menu ini
        const isHidden = menu.classList.contains('hidden');
        if (isHidden) {
          menu.classList.remove('hidden');
          menu.classList.add('block');
        } else {
          menu.classList.remove('block');
          menu.classList.add('hidden');
        }
      }
    });
  });

  // 👆 Klik di luar dropdown → tutup semua dropdown
  document.addEventListener('click', (e) => {
    const clickedInsideDropdown = e.target.closest('.dropdown');
    if (!clickedInsideDropdown) {
      document.querySelectorAll('.dropdown .dropdown-menu').forEach(menu => {
        menu.classList.remove('block');
        menu.classList.add('hidden');
      });
    }
  });


  // Toast
  function showToast(message, type = 'info') {
    const toastBox = document.getElementById('toastBox');
    const toast = document.createElement('div');
    const styles = {
      success: { color: 'bg-emerald-600/90 border-emerald-300 text-emerald-50', icon: '✅' },
      error: { color: 'bg-red-600/90 border-red-300 text-red-50', icon: '❌' },
      warning: { color: 'bg-yellow-600/90 border-yellow-200 text-yellow-50', icon: '⚠️' },
      info: { color: 'bg-sky-600/90 border-sky-300 text-sky-50', icon: 'ℹ️' }
    };
    const style = styles[type] || styles.info;
    toast.className = `flex items-center gap-3 px-5 py-3 rounded-xl border shadow-lg font-medium text-sm min-w-[260px] text-center backdrop-blur-md opacity-0 -translate-y-4 transition-all duration-500 ease-out ${style.color}`;
    toast.innerHTML = `<span class="text-lg">${style.icon}</span><span>${message}</span>`;
    toastBox.appendChild(toast);
    setTimeout(() => { toast.classList.add('opacity-100', 'translate-y-0'); }, 20);
    setTimeout(() => { toast.classList.remove('opacity-100'); setTimeout(() => toast.remove(), 300); }, 3000);
  }

  // Realtime notifikasi
  async function fetchNotifications() {
    try {
      const res = await fetch('/system-absent/inc/fetch_notifications.php');
      const data = await res.json();
      const notifList = document.getElementById('notifList');
      notifList.innerHTML = '';

      if (data.length > 0) {
        data.forEach(n => {
          showToast(`📢 ${n.title} - ${new Date(n.event_date).toLocaleString('id-ID')}`, 'info');
          const item = document.createElement('a');
          item.href = `/system-absent/modules/pengumuman/index.php#pengumuman-${n.id}`;
          item.className = "block px-4 py-2 hover:bg-[#1E2942] text-gray-300 transition animate-fadeIn";
          item.innerHTML = `📅 ${n.title}<div class='text-xs text-gray-400'>${new Date(n.event_date).toLocaleString('id-ID')}</div>`;
          notifList.appendChild(item);
        });

        let badge = document.getElementById('notifBadge');
        if (!badge) {
          badge = document.createElement('span');
          badge.id = 'notifBadge';
          badge.className = 'absolute -top-1 -right-1 bg-red-500 text-white text-xs px-1.5 rounded-full animate-pulse';
          document.getElementById('notifButton').appendChild(badge);
        }
        badge.textContent = data.length;
      } else {
        notifList.innerHTML = "<div class='px-4 py-3 text-gray-400 text-center text-xs'>Belum ada pengumuman aktif.</div>";
      }
    } catch (err) {
      console.error('Gagal ambil notifikasi:', err);
    }
  }

  // Hapus angka badge saat klik lonceng
  document.getElementById('notifButton').addEventListener('click', () => {
    const badge = document.getElementById('notifBadge');
    if (badge) {
      badge.style.transition = 'opacity 0.3s ease';
      badge.style.opacity = '0';
      setTimeout(() => badge.remove(), 300);
    }
  });

  fetchNotifications();
  setInterval(fetchNotifications, 30000);
  
  document.addEventListener('DOMContentLoaded', () => {
  document.querySelector('main')?.classList.add('loaded');
});
  </script>

  <style>
  @keyframes fadeIn { from { opacity: 0; transform: translateY(-5px);} to {opacity: 1; transform: translateY(0);} }
  .animate-fadeIn { animation: fadeIn 0.3s ease-out; }
  @keyframes pulse-slow { 0%,100% {opacity:.8; transform:scale(1);} 50% {opacity:1; transform:scale(1.05);} }
  .animate-pulse-slow { animation: pulse-slow 3s infinite; }
  </style>

</body>
<style>
html, body {
  min-height: 100vh;
  overflow-x: hidden;
}
.content-wrapper {
  min-height: calc(100vh - 8rem); /* biar konten fix posisi */
  display: flex;
  flex-direction: column;
  justify-content: flex-start;
}
main {
  flex: 1;
  transition: opacity 0.3s ease-in-out;
}
main.loaded {
  opacity: 1;
}
main {
  opacity: 0;
}
#loaderWrapper.fade-out {
  opacity: 0;
  pointer-events: none;
  transition: opacity 0.4s ease-in-out;
}
</style>
<script>
document.addEventListener("DOMContentLoaded", function() {
  document.body.classList.add("ready");
  document.getElementById("loaderWrapper")?.classList.add("hidden");
  document.querySelector("main")?.classList.add("loaded");
});

</script>

</html>
