<?php
require_once __DIR__ . '/auth.php';
require_once __DIR__ . '/db.php';
$currentPath = $_SERVER['REQUEST_URI'];
?>

<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.5.0/css/all.min.css">

<style>
  /* === SIDEBAR STABIL === */
  aside.main-menu {
    position: fixed;
    top: 0;
    left: 0;
    height: 100vh;
    width: 72px;
    background: #141D2F;
    border-right: 1px solid #1E263B;
    z-index: 2000;
    display: flex;
    flex-direction: column;
    overflow: hidden;
    transition: width 0.25s ease;
  }

  aside.main-menu:hover {
    width: 240px;
    box-shadow: 6px 0 25px rgba(0, 0, 0, 0.4);
  }

  /* === TITLE === */
  .system-title {
    font-size: 18px;
    font-weight: 600;
    color: #5B8CFF;
    text-align: center;
    margin: 20px 0;
    white-space: nowrap;
    opacity: 0;
    transition: opacity 0.3s ease;
  }

  aside.main-menu:hover .system-title {
    opacity: 1;
  }

  /* === MENU LIST === */
  aside.main-menu ul {
    list-style: none;
    margin: 0;
    padding: 0;
    flex-grow: 1;
  }

  /* === MENU ITEM === */
  a.nav-item,
  .dropdown-btn {
    position: relative;
    display: flex;
    align-items: center;
    gap: 16px;
    padding: 12px 18px;
    color: #A0AEC0;
    font-size: 15px;
    text-decoration: none;
    font-family: 'Inter', sans-serif;
    transition: background 0.25s ease, color 0.25s ease, box-shadow 0.25s ease;
    white-space: nowrap;
  }

  a.nav-item:hover,
  .dropdown-btn:hover {
    background: #1E2A4A;
    color: #fff;
    box-shadow: inset 3px 0 0 #5B8CFF;
  }

  /* === GLOW EFFECT AKTIF === */
  a.active,
  .dropdown-btn.active {
    background: #1E2A4A;
    color: #fff !important;
    box-shadow: inset 3px 0 0 #5B8CFF, 0 0 8px rgba(91, 140, 255, 0.4);
  }

  /* === ICONS === */
  .nav-icon {
    width: 32px;
    min-width: 32px;
    text-align: center;
    font-size: 18px;
    color: #5B8CFF;
    transition: transform 0.2s ease;
  }

  /* === TEXT === */
  .nav-text {
    opacity: 0;
    transition: opacity 0.3s ease;
  }

  aside.main-menu:hover .nav-text {
    opacity: 1;
  }

  /* === DROPDOWN === */
  .dropdown-icon {
    margin-left: auto;
    transition: transform 0.3s ease, opacity 0.2s ease;
    font-size: 11px;
    opacity: 0;
  }

  aside.main-menu:hover .dropdown-icon {
    opacity: 1;
  }

  .open .dropdown-icon {
    transform: rotate(90deg);
  }

  /* === DROPDOWN CONTENT === */
  .dropdown-content {
    max-height: 0;
    opacity: 0;
    overflow: hidden;
    transform: translateY(-5px);
    transition: all 0.3s ease;
  }

  .open+.dropdown-content {
    max-height: 400px;
    opacity: 1;
    transform: translateY(0);
  }

  .dropdown-content a {
    display: block;
    padding: 10px 50px;
    font-size: 14px;
    color: #AAB4D4;
    text-decoration: none;
    transition: background 0.2s ease, color 0.2s ease;
  }

  .dropdown-content a:hover {
    background: #1E2A4A;
    color: #fff;
    box-shadow: inset 3px 0 0 #5B8CFF;
  }

  /* === LOGOUT === */
  .logout {
    margin-top: auto;
    border-top: 1px solid #1E263B;
    background: #121A2A;
  }

  .logout a {
    color: #FF6B6B;
  }

  /* === RESPONSIVE === */
  #menuToggle {
    display: none;
    position: fixed;
    top: 12px;
    left: 14px;
    z-index: 3000;
    background: #1E2A4A;
    padding: 10px 12px;
    border-radius: 8px;
    color: #fff;
    font-size: 20px;
    transition: background 0.3s ease;
  }

  #menuToggle:hover {
    background: #2A3B65;
  }

    @media (max-width: 1024px) {
    #menuToggle {
      display: block;
    }

    aside.main-menu {
      width: 0;
      background: rgba(20, 29, 47, 0.98);
      overflow: hidden;
      transition: width 0.3s ease;
    }

    aside.main-menu.open {
      width: 100%;
    }

    /* 🔤 Ukuran font lebih wajar & mewah di HP */
    .nav-text {
      opacity: 1 !important;
      font-size: 15px !important;
    }

    .nav-item,
    .dropdown-btn {
      font-size: 15px;
      padding: 14px 20px;
    }

    .system-title {
      opacity: 1 !important;
      font-size: 17px !important;
    }

    .nav-icon {
      font-size: 18px;
    }

    .dropdown-content a {
      font-size: 14px;
      padding: 10px 52px;
    }
  }

  /* === KONTEN UTAMA AGAR PAS DENGAN ICON SIDEBAR === */
.content-wrapper {
  margin-left: 90px; /* posisi sejajar dengan ikon sidebar */
  padding: 20px;
  transition: margin-left 0.3s ease;
}

/* Saat sidebar hover (melebar), konten tetap tidak terdorong */
aside.main-menu:hover ~ .content-wrapper {
  margin-left: 90px;
}

/* Mode mobile: konten tetap full tanpa margin */
@media (max-width: 1024px) {
  .content-wrapper {
    margin-left: 0;
  }
}

</style>

<aside class="main-menu">
  <div class="system-title">System Absent</div>
  <ul>
    <?php if (canAccess('admin')): ?>
      <li><a href="/system-absent/modules/admin/index.php"
          class="nav-item <?= strpos($currentPath, '/admin/') ? 'active' : '' ?>"><i
            class="fa-solid fa-user-shield nav-icon"></i><span class="nav-text">Admin</span></a></li>
    <?php endif; ?>

    <?php if (canAccess('kelas')): ?>
      <li><a href="/system-absent/modules/kelas/index.php"
          class="nav-item <?= strpos($currentPath, '/kelas/') ? 'active' : '' ?>"><i
            class="fa-solid fa-layer-group nav-icon"></i><span class="nav-text">Data Kelas</span></a></li>
    <?php endif; ?>

    <?php if (canAccess('siswa')): ?>
      <li><a href="/system-absent/modules/siswa/index.php"
          class="nav-item <?= strpos($currentPath, '/siswa/') ? 'active' : '' ?>"><i
            class="fa-solid fa-users nav-icon"></i><span class="nav-text">Data Siswa</span></a></li>
    <?php endif; ?>
    
    <?php if (canAccess('mapel') || canAccess('jadwal_pelajaran')): ?>
  <li>
    <button
      class="dropdown-btn <?= strpos($currentPath, '/mapel/') || strpos($currentPath, '/jadwal_pelajaran/') ? 'active' : '' ?>">
      <i class="fa-solid fa-book nav-icon"></i>
      <span class="nav-text">Data Mapel</span>
      <i class="fa-solid fa-chevron-right dropdown-icon"></i>
    </button>

    <ul class="dropdown-content">
      <?php if (canAccess('mapel')): ?>
        <li><a href="/system-absent/modules/mapel/index.php"
            class="<?= strpos($currentPath, '/mapel/') ? 'active' : '' ?>">📘 Buat Mapel</a></li>
      <?php endif; ?>
      <?php if (canAccess('jadwal_pelajaran')): ?>
        <li><a href="/system-absent/modules/jadwal_pelajaran/index.php"
            class="<?= strpos($currentPath, '/jadwal_pelajaran/') ? 'active' : '' ?>">🗓️ Jadwal Pelajaran</a></li>
      <?php endif; ?>
    </ul>
  </li>
<?php endif; ?>


<?php if (canAccess('absensi_kelas')): ?>
  <li>
    <button
      class="dropdown-btn <?= (strpos($currentPath, '/absensi_kelas/') !== false || strpos($currentPath, '/qr_absen/') !== false) ? 'active' : '' ?>">
      <i class="fa-solid fa-calendar-days nav-icon"></i>
      <span class="nav-text">Absensi Kelas</span>
      <i class="fa-solid fa-chevron-right dropdown-icon"></i>
    </button>

    <ul class="dropdown-content">
      <!-- QR Absen -->
      <li>
        <a href="/system-absent/modules/qr_absen/index.php"
           class="<?= strpos($currentPath, '/qr_absen/index.php') !== false ? 'active' : '' ?>">
          📱 QR Absen
        </a>
      </li>

      <!-- Generate Token Rutin (BARU) -->
      <li>
        <a href="/system-absent/modules/qr_absen/generate_token_rutin.php"
           class="<?= strpos($currentPath, '/qr_absen/generate_token_rutin.php') !== false ? 'active' : '' ?>">
          🔁 Generate Token Rutin
        </a>
      </li>

      <!-- Absen Harian -->
      <li>
        <a href="/system-absent/modules/absensi_kelas/index.php"
           class="<?= strpos($currentPath, 'absensi_kelas/index.php') !== false ? 'active' : '' ?>">
          🗓️ Absen Harian
        </a>
      </li>

      <!-- Rekap Harian -->
      <li>
        <a href="/system-absent/modules/absensi_kelas/rekap_harian.php"
           class="<?= strpos($currentPath, 'rekap_harian.php') !== false ? 'active' : '' ?>">
          📊 Rekap Harian
        </a>
      </li>

      <!-- Rekap Persiswa -->
      <li>
        <a href="/system-absent/modules/absensi_kelas/rekap_periode.php"
           class="<?= strpos($currentPath, 'rekap_periode.php') !== false ? 'active' : '' ?>">
          👨‍🎓 Rekap Persiswa
        </a>
      </li>
    </ul>
  </li>
<?php endif; ?>



    <?php if (canAccess('user')): ?>
      <li><a href="/system-absent/modules/user/index.php"
          class="nav-item <?= strpos($currentPath, '/user/') ? 'active' : '' ?>"><i
            class="fa-solid fa-user-group nav-icon"></i><span class="nav-text">Sub Akun</span></a></li>
    <?php endif; ?>

<?php if (canAccess('pengumuman')): ?>
  <li>
    <a href="/system-absent/modules/pengumuman/index.php"
      class="nav-item <?= strpos($currentPath, '/pengumuman/') ? 'active' : '' ?>">
      <i class="fa-solid fa-bullhorn nav-icon"></i>
      <span class="nav-text">Pengumuman</span>
    </a>
  </li>
<?php endif; ?>

<?php if (canAccess('report/index.php')): ?>
  <li>
    <a href="/system-absent/modules/report/index.php"
      class="nav-item <?= strpos($currentPath, '/report/') ? 'active' : '' ?>">
      <i class="fa-solid fa-triangle-exclamation nav-icon"></i>
      <span class="nav-text">Laporan Kendala</span>
    </a>
  </li>
<?php endif; ?>

<?php if (canAccess('qr_absen/generate_token_rutin.php')): ?>
  <li>
    <a href="/system-absent/modules/qr_absen/generate_token_rutin.php"
       class="nav-item <?= strpos($currentPath, '/qr_absen/generate_token_rutin.php') !== false ? 'active' : '' ?>">
      <i class="fa-solid fa-key nav-icon"></i>
      <span class="nav-text">Token Absen Rutin Kelas</span>
    </a>
  </li>
<?php endif; ?>

  </ul>

</aside>

<button id="menuToggle" aria-label="Menu Toggle">
  <i class="fa-solid fa-bars"></i>
</button>

<script>

// === 7️⃣ Tutup dropdown otomatis saat sidebar tidak dihover ===
  const mainMenu = document.querySelector("aside.main-menu");

  mainMenu.addEventListener("mouseleave", () => {
    // Tutup semua dropdown yang terbuka
    document.querySelectorAll(".dropdown-btn.open").forEach(btn => {
      btn.classList.remove("open");
      const dropdown = btn.nextElementSibling;
      if (dropdown) {
        dropdown.style.maxHeight = "0";
        dropdown.style.opacity = "0";
      }
    });
  });

document.addEventListener("DOMContentLoaded", () => {
  const sidebar = document.querySelector("aside.main-menu");
  const toggleBtn = document.getElementById("menuToggle");

  // === 1️⃣ Dropdown logic ===
  document.querySelectorAll(".dropdown-btn").forEach(btn => {
    const dropdown = btn.nextElementSibling;

    btn.addEventListener("click", e => {
      e.preventDefault();

      // Tutup semua dropdown lain
      document.querySelectorAll(".dropdown-btn.open").forEach(b => {
        if (b !== btn) b.classList.remove("open");
        const otherDrop = b.nextElementSibling;
        if (otherDrop) {
          otherDrop.style.maxHeight = "0";
          otherDrop.style.opacity = "0";
        }
      });

      // Toggle dropdown ini
      btn.classList.toggle("open");
      if (dropdown) {
        if (btn.classList.contains("open")) {
          dropdown.style.maxHeight = dropdown.scrollHeight + "px";
          dropdown.style.opacity = "1";
        } else {
          dropdown.style.maxHeight = "0";
          dropdown.style.opacity = "0";
        }
      }
    });
  });

  // === 2️⃣ Tutup dropdown setelah klik submenu ===
  document.querySelectorAll(".dropdown-content a").forEach(link => {
    link.addEventListener("click", e => {
      e.preventDefault();
      const target = link.getAttribute("href");

      // Tutup semua dropdown
      document.querySelectorAll(".dropdown-btn.open").forEach(b => b.classList.remove("open"));
      document.querySelectorAll(".dropdown-content").forEach(c => {
        c.style.maxHeight = "0";
        c.style.opacity = "0";
      });

      // Tutup sidebar kalau di mobile
      if (window.innerWidth <= 1024 && sidebar.classList.contains("open")) {
        sidebar.classList.remove("open");
        toggleBtn.innerHTML = '<i class="fa-solid fa-bars"></i>';
      }

      // Redirect dengan sedikit delay biar animasi sempat jalan
      setTimeout(() => window.location.href = target, 150);
    });
  });

  // === 3️⃣ Tutup semua dropdown otomatis saat load halaman ===
  document.querySelectorAll(".dropdown-btn").forEach(btn => {
    btn.classList.remove("open");
    const dropdown = btn.nextElementSibling;
    if (dropdown) {
      dropdown.style.maxHeight = "0";
      dropdown.style.opacity = "0";
    }
  });

  // === 4️⃣ Toggle sidebar (mobile) ===
  toggleBtn.addEventListener("click", e => {
    e.stopPropagation();
    sidebar.classList.toggle("open");
    toggleBtn.innerHTML = sidebar.classList.contains("open")
      ? '<i class="fa-solid fa-xmark"></i>'
      : '<i class="fa-solid fa-bars"></i>';
  });

  // Tutup sidebar jika klik di luar
  document.addEventListener("click", e => {
    if (window.innerWidth <= 1024 && sidebar.classList.contains("open")) {
      const inside = sidebar.contains(e.target) || toggleBtn.contains(e.target);
      if (!inside) {
        sidebar.classList.remove("open");
        toggleBtn.innerHTML = '<i class="fa-solid fa-bars"></i>';
      }
    }
  });

  // === 5️⃣ Glow aktif saat scroll ===
  const observer = new IntersectionObserver(entries => {
    entries.forEach(entry => {
      if (entry.isIntersecting) entry.target.classList.add("glow");
      else entry.target.classList.remove("glow");
    });
  }, { threshold: 0.5 });

  document.querySelectorAll(".nav-item, .dropdown-btn").forEach(el => observer.observe(el));

  // === 6️⃣ Pastikan icon dropdown muncul ===
  document.querySelectorAll(".dropdown-icon").forEach(icon => icon.style.opacity = "1");
});
</script>
