<?php
session_start();

/* === 1️⃣ Hapus semua data session === */
$_SESSION = [];
if (ini_get("session.use_cookies")) {
    $params = session_get_cookie_params();
    setcookie(session_name(), '', time() - 42000,
        $params["path"], $params["domain"],
        $params["secure"], $params["httponly"]
    );
}
session_destroy();

/* === 2️⃣ Hapus cache supaya tidak bisa kembali ke halaman sebelumnya === */
header("Cache-Control: no-cache, no-store, must-revalidate"); // HTTP 1.1
header("Pragma: no-cache"); // HTTP 1.0
header("Expires: 0"); // Proxies

/* === 3️⃣ Redirect ke clean URL (tanpa /system-absent/) === */
header("Location: /system-absent/login");
exit;
?>
