<?php
require __DIR__.'/../../inc/auth.php';
require __DIR__.'/../../inc/db.php';
require __DIR__.'/../../vendor/autoload.php';

use PhpOffice\PhpSpreadsheet\Spreadsheet;
use PhpOffice\PhpSpreadsheet\Writer\Xlsx;

$class_id = (int)($_GET['class_id'] ?? 0);
$start = $_GET['start'] ?? date('Y-m-01');
$end = $_GET['end'] ?? date('Y-m-t');
$hari_seharusnya = (int)($_GET['hari_seharusnya'] ?? 0);

$q = $conn->query("
  SELECT s.nim, s.name,
  SUM(a.status='Hadir') AS hadir,
  SUM(a.status='Izin') AS izin,
  SUM(a.status='Sakit') AS sakit,
  SUM(a.status='Alfa') AS alfa,
  COUNT(a.id) AS total
  FROM students s
  LEFT JOIN attendance_daily a ON s.id=a.student_id AND a.tanggal BETWEEN '$start' AND '$end'
  WHERE s.class_id=$class_id GROUP BY s.id ORDER BY s.name
");

// === Load Setting Kolom NIM ===
$settingFile = __DIR__.'/rekap_settings.json';
$show_nim = true;
if (file_exists($settingFile)) {
  $json = json_decode(file_get_contents($settingFile), true);
  $show_nim = $json['show_nim'] ?? true;
}

$spreadsheet = new Spreadsheet();
$sheet = $spreadsheet->getActiveSheet();

// === HEADER ===
$sheet->mergeCells('A1:I1');
$sheet->setCellValue('A1', 'LAPORAN REKAP ABSENSI SISWA');
$sheet->mergeCells('A2:I2');
$sheet->setCellValue('A2', "Periode $start s.d $end");

// === Tabel ===
$headers = ['No'];
if ($show_nim) $headers[] = 'NIM';
array_push($headers, 'Nama', 'Hadir', 'Izin', 'Sakit', 'Alfa', 'Total Hari', '% Kehadiran');
$sheet->fromArray($headers, NULL, 'A4');

$i = 5; $no = 1; $totalPersen = 0; $count = 0;
while ($r = $q->fetch_assoc()) {
  $hadir = (int)$r['hadir'];
  $persen = ($hari_seharusnya > 0) ? round(($hadir / $hari_seharusnya) * 100, 2) : 0;
  $totalPersen += $persen; $count++;

  $row = [$no++];
  if ($show_nim) $row[] = $r['nim'];
  array_push($row, $r['name'], $r['hadir'], $r['izin'], $r['sakit'], $r['alfa'], $r['total'], "$persen%");
  $sheet->fromArray($row, NULL, "A$i");
  $i++;
}

$rata = $count > 0 ? round($totalPersen / $count, 2) : 0;
$sheet->fromArray(['', '', 'Rata-rata Kelas', '', '', '', '', '', "$rata%"], NULL, "A$i");

// === STYLE ===
$sheet->getStyle('A4:I4')->getFont()->setBold(true);
$sheet->getStyle("A4:I".($i))->getBorders()->getAllBorders()->setBorderStyle(\PhpOffice\PhpSpreadsheet\Style\Border::BORDER_THIN);

header('Content-Type: application/vnd.openxmlformats-officedocument.spreadsheetml.sheet');
header("Content-Disposition: attachment; filename=Rekap_Absensi_$start-$end.xlsx");
$writer = new Xlsx($spreadsheet);
$writer->save("php://output");
exit;
?>
