<?php
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);
header('Content-Type: application/json; charset=utf-8');

require __DIR__ . '/../../inc/auth.php';
require __DIR__ . '/../../inc/db.php';

// ==== AMBIL DATA REQUEST ====
$input = json_decode(file_get_contents('php://input'), true);
$start = $input['start'] ?? '';
$end = $input['end'] ?? '';
$days = (int)($input['days'] ?? 0);

// ✅ Tambahan baru: ambil opsi periode dari input
$use_period = isset($input['use_period']) ? (int)$input['use_period'] : 1;

// ==== VALIDASI ====
if ($use_period && (!$start || !$end || !$days)) {
  echo json_encode(['success' => false, 'error' => '❌ Data tidak lengkap.']);
  exit;
}
if (!$days) {
  echo json_encode(['success' => false, 'error' => '❌ Masa aktif wajib diisi.']);
  exit;
}

// ==== BUAT TOKEN & EXPIRED ====
$expired_at = date('Y-m-d H:i:s', strtotime("+$days days"));
$token = bin2hex(random_bytes(16));

// ==== Dapatkan ID user login sebagai pembuat (opsional)
$user_id = $_SESSION['user_id'] ?? null;

// ==== SIMPAN KE DATABASE ====
// Jika kamu ingin menyimpan class_id, tambahkan dari POST juga
$class_id = $_POST['class_id'] ?? null;

if ($use_period) {
  // versi pakai periode
  $stmt = $conn->prepare("
    INSERT INTO rekap_public_links (token, start, end, expired_at, use_period)
    VALUES (?, ?, ?, ?, ?)
  ");
  $stmt->bind_param('ssssi', $token, $start, $end, $expired_at, $use_period);
}  else {
  // versi tanpa periode
  $stmt = $conn->prepare("
    INSERT INTO rekap_public_links (token, start, end, expired_at, use_period)
    VALUES (?, NULL, NULL, ?, ?)
  ");
  $stmt->bind_param('ssi', $token, $expired_at, $use_period);
}

if (!$stmt->execute()) {
  echo json_encode(['success' => false, 'error' => '❌ Gagal menyimpan token: ' . $stmt->error]);
  exit;
}
$stmt->close();

// ==== BENTUK LINK PENDEK ====
$base_url = $_SERVER['REQUEST_SCHEME'] . '://' . $_SERVER['HTTP_HOST'];
$link = $base_url . '/rekap/' . urlencode($token);

// ==== RESPONSE JSON ====
echo json_encode([
  'success' => true,
  'link' => $link,
  'expired_at' => $expired_at,
  'use_period' => $use_period
]);

$conn->close();
?>
