<?php
require __DIR__ . '/../../inc/auth.php';
require __DIR__ . '/../../inc/db.php';
require_once __DIR__ . '/../../vendor/phpqrcode/qrlib.php';

// Validasi kelas
$class_id = (int)($_GET['class_id'] ?? 0);
if (!$class_id) {
  die("<h3 style='color:red;text-align:center;margin-top:50px;'>⚠️ Kelas belum dipilih.</h3>");
}

// Ambil data kelas dan siswa
$class = $conn->query("SELECT c.name AS class_name, g.name AS group_name, t.name AS tier_name
                       FROM classes c
                       JOIN class_groups g ON g.id = c.group_id
                       JOIN class_tiers t ON t.id = g.tier_id
                       WHERE c.id = $class_id")->fetch_assoc();

if (!$class) die("<h3 style='color:red;text-align:center;margin-top:50px;'>❌ Data kelas tidak ditemukan.</h3>");

$class_name = "{$class['tier_name']} - {$class['group_name']} - {$class['class_name']}";

// Ambil daftar siswa
$q = $conn->query("SELECT id, nim, name FROM students WHERE class_id = $class_id ORDER BY name");

if ($q->num_rows == 0) {
  die("<h3 style='text-align:center;margin-top:50px;'>Belum ada siswa di kelas ini.</h3>");
}

// Folder simpan QR
$dir = __DIR__ . '/qrcodes/';
if (!file_exists($dir)) mkdir($dir, 0777, true);

// Tampilkan hasil
echo "<h2 style='text-align:center;color:#5B8CFF;'>📘 QR Code Absensi — $class_name</h2>";
echo "<p style='text-align:center;'>Setiap QR mewakili 1 siswa. Bisa dicetak untuk absen harian atau acara khusus.</p><br>";
echo "<table border='1' cellspacing='0' cellpadding='8' style='margin:auto;border-collapse:collapse;text-align:center;'>
        <tr style='background:#0E1525;color:white;'>
          <th>No</th><th>NIM</th><th>Nama</th><th>QR Code</th>
        </tr>";

$no = 1;
while ($r = $q->fetch_assoc()) {
  $nim = $r['nim'];
  $name = htmlspecialchars($r['name']);
  $url = "http://localhost/system-absent/modules/absensi_kelas/scan_qr.php?nim=" . urlencode($nim);
  $file = $dir . "{$nim}.png";

  // Generate QR jika belum ada
  if (!file_exists($file)) {
    QRcode::png($url, $file, QR_ECLEVEL_L, 4, 2);
  }

  echo "<tr>
          <td>$no</td>
          <td>{$nim}</td>
          <td>{$name}</td>
          <td><img src='qrcodes/{$nim}.png' width='100'></td>
        </tr>";
  $no++;
}

echo "</table>";
?>
