<?php
require __DIR__ . '/../../inc/db.php';
header('Content-Type: application/json; charset=utf-8');

$class_id = (int)($_GET['class_id'] ?? 0);
$date = $_GET['date'] ?? date('Y-m-d');

if (!$class_id) {
  echo json_encode(['success' => false, 'error' => 'Kelas tidak valid']);
  exit;
}

$q = $conn->query("
  SELECT 
    s.id AS student_id,
    s.nim,
    s.name,
    IF(a.id IS NOT NULL, 'Hadir', 'Belum Absen') AS status,
    IF(a.id IS NOT NULL, 'Sudah absen by QR', 'Belum absen') AS keterangan
  FROM students s
  LEFT JOIN attendance_daily a 
    ON a.student_id = s.id 
    AND a.tanggal = '$date'
  WHERE s.class_id = $class_id
  ORDER BY s.name
");

$data = $q->fetch_all(MYSQLI_ASSOC);

echo json_encode([
  'success' => true,
  'data' => $data,
  'class_id' => $class_id,
  'date' => $date
], JSON_UNESCAPED_UNICODE);
?>
