<?php
require __DIR__.'/../../inc/auth.php';
require __DIR__.'/../../inc/db.php';
$title = "Absensi Harian Siswa";
ob_start();
?>

<style>
  /* Hilangkan icon & dropdown bawaan input tanggal */
  input[type="date"] {
    -webkit-appearance: none;
    -moz-appearance: textfield;
    appearance: none;
    position: relative;
  }
  input[type="date"]::-webkit-calendar-picker-indicator,
  input[type="date"]::-webkit-inner-spin-button,
  input[type="date"]::-webkit-clear-button {
    display: none;
    -webkit-appearance: none;
  }
</style>

<div class="p-6 bg-[#141D2F] rounded-2xl border border-white/10">
  <!-- Header -->
  <div class="flex justify-between items-center mb-4">
    <h1 class="text-xl font-semibold text-[#8CE0FF]">📅 Absensi Harian Siswa</h1>
  </div>

  <!-- Filter (DESKTOP MIRIP REKAP HARIAN) -->
  <div class="flex flex-wrap items-end gap-3 mb-4">
    <!-- Pilih Kelas -->
    <div class="w-full md:w-1/3">
      <select id="classSelect"
              class="w-full p-2 rounded bg-[#0E1525] border border-white/10 text-[#B7C9E5]">
        <option value="">-- Pilih Kelas --</option>
        <?php
        $kelas = $conn->query("
          SELECT c.id, CONCAT(t.name, ' - ', g.name, ' - ', c.name) AS class_name
          FROM classes c
          LEFT JOIN class_tiers t ON c.tier_id = t.id
          LEFT JOIN class_groups g ON c.group_id = g.id
          ORDER BY t.name, g.name, c.name
        ");
        while($c = $kelas->fetch_assoc()):
        ?>
          <option value="<?=$c['id']?>"><?=$c['class_name']?></option>
        <?php endwhile; ?>
      </select>
    </div>

    <!-- Tanggal + Button Tampilkan -->
    <div class="w-full md:w-auto flex flex-col md:flex-row md:items-center gap-3">
      <div class="relative w-full md:w-44">
        <input type="date" id="tanggal"
               class="w-full p-2 pr-10 rounded bg-[#0E1525] border border-white/10 text-[#B7C9E5]"
               value="<?=date('Y-m-d')?>">
        <!-- Icon kalender custom -->
        <span
          class="absolute inset-y-0 right-3 flex items-center text-gray-400 cursor-pointer"
          onclick="(document.getElementById('tanggal').showPicker && document.getElementById('tanggal').showPicker()) || document.getElementById('tanggal').focus();"
        >
          <i class="fa-regular fa-calendar"></i>
        </span>
      </div>

      <button onclick="loadSiswa()"
              class="w-full md:w-auto bg-[#5B8CFF] px-4 py-2 rounded font-semibold text-[#0E1525] hover:bg-[#8CE0FF] transition">
        Tampilkan
      </button>
    </div>
  </div>

  <!-- Container tabel -->
  <div id="absenContainer" class="hidden">
    <!-- wrapper biar bisa scroll horizontal di mobile -->
    <div class="overflow-x-auto -mx-2 sm:mx-0">
      <table class="min-w-full text-sm text-[#B7C9E5]" id="absenTable">
        <thead class="text-[#8CE0FF] border-b border-white/10">
          <tr>
            <th class="p-2 text-left">No</th>
            <!-- Kolom NIM dihapus sesuai permintaan -->
            <th class="p-2 text-left">Nama</th>
            <th class="p-2 text-center">Status</th>
            <th class="p-2 text-left">Keterangan</th>
          </tr>
        </thead>
        <tbody id="absenBody"></tbody>
      </table>
    </div>

    <div class="mt-4 flex justify-end">
      <button onclick="simpanSemua()"
              class="bg-[#37F297] text-[#0E1525] font-semibold px-4 py-2 rounded hover:bg-[#5BFFD9] transition">
        💾 Simpan Semua
      </button>
    </div>
  </div>
</div>

<script>
// === Toast Notifikasi (gaya sama seperti menu lain) ===
function showToast(msg, type = 'info') {
  const color = type === 'success' ? '#37F297' :
                type === 'error' ? '#FF5B5B' :
                type === 'warning' ? '#FFD15B' : '#5B8CFF';
  const toast = document.createElement('div');
  toast.textContent = msg;
  toast.style.position = 'fixed';
  toast.style.bottom = '25px';
  toast.style.right = '25px';
  toast.style.background = color;
  toast.style.color = '#0E1525';
  toast.style.padding = '10px 15px';
  toast.style.borderRadius = '8px';
  toast.style.fontWeight = 'bold';
  toast.style.boxShadow = '0 2px 8px rgba(0,0,0,0.3)';
  toast.style.zIndex = '9999';
  toast.style.opacity = '0';
  toast.style.transition = 'opacity 0.3s';
  document.body.appendChild(toast);
  setTimeout(() => toast.style.opacity = '1', 10);
  setTimeout(() => toast.style.opacity = '0', 2300);
  setTimeout(() => toast.remove(), 2600);
}

// === Load daftar siswa berdasarkan kelas ===
function loadSiswa() {
  const classId = document.getElementById('classSelect').value;
  const tanggal = document.getElementById('tanggal').value;
  if (!classId) return showToast('⚠️ Pilih kelas terlebih dahulu.', 'warning');

  fetch(`index.php?load_absen=1&class_id=${classId}&tanggal=${tanggal}`)
    .then(r => r.json())
    .then(d => {
      const tbody = document.getElementById('absenBody');
      tbody.innerHTML = '';

      if (!d.success || !d.data.length) {
        tbody.innerHTML = `<tr><td colspan="4" class="text-center p-3 text-gray-400">Semua siswa sudah absen hari ini ✅</td></tr>`;
        document.getElementById('absenContainer').classList.remove('hidden');
        return;
      }

      let counter = 1;
      d.data.forEach((s) => {
        if (s.status === 'Hadir' || s.keterangan === 'Sudah absen by QR') return; // sembunyikan yg sudah absen

        tbody.innerHTML += `
          <tr class="border-b border-white/5 hover:bg-[#0E1525]/60">
            <td class="p-2">${counter++}</td>
            <td class="p-2">${s.name}</td>
            <td class="p-2 text-center">
              <select class="p-1 rounded bg-[#0E1525] border border-white/10 text-[#B7C9E5]" data-id="${s.id}" onchange="isiManual(this)">
                <option value="">-- Pilih --</option>
                <option value="Hadir">Hadir</option>
                <option value="Izin">Izin</option>
                <option value="Sakit">Sakit</option>
                <option value="Alfa">Alfa</option>
              </select>
            </td>
            <td class="p-2">
              <input type="text" class="w-full p-1 rounded bg-[#0E1525] border border-white/10 text-[#B7C9E5]" data-ket="${s.id}" placeholder="Keterangan...">
            </td>
          </tr>
        `;
      });

      document.getElementById('absenContainer').classList.remove('hidden');
    })
    .catch(() => showToast('❌ Gagal memuat data absensi.', 'error'));
}

// === Otomatis isi keterangan "Manual" jika pilih Hadir ===
function isiManual(select) {
  const id = select.dataset.id;
  const ketInput = document.querySelector(`[data-ket="${id}"]`);
  if (select.value === 'Hadir') ketInput.value = 'Manual';
}

// === Simpan semua absensi (manual) ===
function simpanSemua() {
  const classId = document.getElementById('classSelect').value;
  const tanggal = document.getElementById('tanggal').value;
  if (!classId || !tanggal) return showToast('⚠️ Pilih kelas dan tanggal terlebih dahulu.', 'warning');

  const data = [];
  document.querySelectorAll('#absenBody tr').forEach(row => {
    const select = row.querySelector('select');
    const ket = row.querySelector('input[type=text]');
    if (!select.value) return; // skip baris kosong
    data.push({
      student_id: select.dataset.id,
      status: select.value,
      keterangan: ket.value
    });
  });

  if (!data.length) return showToast('⚠️ Tidak ada data untuk disimpan.', 'warning');

  fetch('save_absensi.php', {
    method: 'POST',
    headers: {'Content-Type': 'application/json'},
    body: JSON.stringify({class_id: classId, tanggal, data})
  })
  .then(r => r.json())
  .then(d => {
    if (d.success) {
      showToast(`✅ Absensi ${d.saved} siswa berhasil disimpan.`, 'success');
      loadSiswa();
    } else {
      showToast('❌ Gagal menyimpan absensi.', 'error');
    }
  })
  .catch(() => showToast('⚠️ Terjadi kesalahan sistem.', 'warning'));
}
</script>

<?php
$content = ob_get_clean();

// === Handle AJAX JSON request (load data absensi) ===
if (isset($_GET['load_absen'])) {
  header('Content-Type: application/json; charset=utf-8');
  $class_id = (int)($_GET['class_id'] ?? 0);
  $tanggal = $_GET['tanggal'] ?? date('Y-m-d');

  $q = $conn->query("
    SELECT 
      s.id,
      s.nim,
      s.name,
      IF(a.id IS NOT NULL, a.status, 'Belum Absen') AS status,
      IF(a.id IS NOT NULL, 'Sudah absen by QR', 'Belum absen') AS keterangan
    FROM students s
    LEFT JOIN attendance_daily a 
      ON a.student_id = s.id 
      AND a.tanggal = '$tanggal'
    WHERE s.class_id = $class_id
    ORDER BY s.name
  ");
  
  $data = [];
  while ($row = $q->fetch_assoc()) {
    $data[] = $row;
  }
  echo json_encode(['success' => true, 'data' => $data]);
  exit;
}

require __DIR__.'/../../inc/layout.php';
?>
