<?php
require __DIR__.'/../../inc/auth.php';
require __DIR__.'/../../inc/db.php';
require __DIR__.'/../../vendor/autoload.php';

use Dompdf\Dompdf;

date_default_timezone_set('Asia/Jakarta');

$class_id = (int)($_GET['class_id'] ?? 0);
$tanggal  = $_GET['tanggal'] ?? date('Y-m-d');

if (!$class_id) {
  die('<script>alert("Parameter class_id tidak valid!");window.close();</script>');
}

// === Ambil nama kelas ===
$qClass = $conn->query("SELECT name FROM classes WHERE id = $class_id");
$rowClass = $qClass->fetch_assoc();
$nama_kelas = $rowClass['name'] ?? 'Kelas Tidak Diketahui';

// === Ambil data absensi (urut Hadir → Izin → Sakit → Alfa) ===
$q = $conn->query("
  SELECT s.name AS nama, c.name AS kelas, a.status, a.keterangan
  FROM attendance_daily a
  JOIN students s ON a.student_id = s.id
  JOIN classes c ON a.class_id = c.id
  WHERE a.class_id = $class_id AND a.tanggal = '$tanggal'
  ORDER BY 
    CASE 
      WHEN a.status = 'Hadir' THEN 1
      WHEN a.status = 'Izin' THEN 2
      WHEN a.status = 'Sakit' THEN 3
      WHEN a.status = 'Alfa' THEN 4
      ELSE 5
    END,
    s.name ASC
");
$data = $q ? $q->fetch_all(MYSQLI_ASSOC) : [];

// === Hitung total per status ===
$total = [
  'Hadir' => 0,
  'Izin'  => 0,
  'Sakit' => 0,
  'Alfa'  => 0
];
foreach ($data as $d) {
  if (isset($total[$d['status']])) $total[$d['status']]++;
}

// === Format nama file ===
$nama_kelas_clean = preg_replace('/[^A-Za-z0-9]+/', '_', $nama_kelas);
$tanggal_format = date('d-m-Y', strtotime($tanggal));
$nama_file_pdf = "{$nama_kelas_clean}_{$tanggal_format}.pdf";

// === HTML Template ===
$html = '
<style>
body { font-family: Arial, sans-serif; font-size: 12px; margin: 40px; color:#222; }
h2, h4 { text-align: center; margin: 0; }
table { width: 100%; border-collapse: collapse; margin-top: 15px; font-size: 12px; }
th, td { border: 1px solid #555; padding: 6px; }
th { background: #e3f2fd; text-align: center; }
td { vertical-align: middle; }
.summary {
  margin-top: 20px;
  border: 1px solid #555;
  width: 40%;
  float: right;
  border-radius: 4px;
}
.summary table {
  width: 100%;
  border-collapse: collapse;
  font-size: 12px;
}
.summary th {
  background: #e3f2fd;
  border: 1px solid #555;
  text-align: left;
  padding: 5px 8px;
}
.summary td {
  border: 1px solid #555;
  padding: 5px 8px;
  text-align: right;
}
.footer {
  clear: both;
  margin-top: 60px;
  text-align: right;
  font-size: 12px;
  color: #444;
}
</style>

<h2>LAPORAN REKAP ABSENSI</h2>
<h4>Kelompok : '.htmlspecialchars($nama_kelas).'</h4>
<h4>Tanggal Absensi: '.date('d/m/Y', strtotime($tanggal)).'</h4>

<table>
<thead>
<tr>
  <th>No</th>
  <th>Nama</th>
  <th>Kelompok</th>
  <th>Status</th>
  <th>Keterangan</th>
</tr>
</thead>
<tbody>';

// === Isi tabel ===
if (!empty($data)) {
  $no = 1;
  foreach ($data as $d) {
    $keterangan = ($d['status'] === 'Hadir') ? '' : htmlspecialchars($d['keterangan']);
    $html .= '<tr>
      <td style="text-align:center">'.$no++.'</td>
      <td>'.htmlspecialchars($d['nama']).'</td>
      <td style="text-align:center">'.htmlspecialchars($d['kelas']).'</td>
      <td style="text-align:center">'.htmlspecialchars($d['status']).'</td>
      <td>'.$keterangan.'</td>
    </tr>';
  }
} else {
  $html .= '<tr><td colspan="5" style="text-align:center;color:#777;">Tidak ada data absensi.</td></tr>';
}

$html .= '</tbody></table>';

// === Bagian total, rapi ke kanan ===
$html .= '
<div class="summary">
  <table>
    <tr><th>Total Hadir</th><td>'.$total['Hadir'].'</td></tr>
    <tr><th>Total Izin</th><td>'.$total['Izin'].'</td></tr>
    <tr><th>Total Sakit</th><td>'.$total['Sakit'].'</td></tr>
    <tr><th>Total Alfa</th><td>'.$total['Alfa'].'</td></tr>
  </table>
</div>

<div class="footer">
  Dicetak pada: '.date('d/m/Y H:i:s').' WIB
</div>
';

// === Generate PDF ===
$dompdf = new Dompdf();
$dompdf->loadHtml($html);
$dompdf->setPaper('A4', 'portrait');
$dompdf->render();
$dompdf->stream($nama_file_pdf, ['Attachment' => false]);
exit;
?>
