<?php
require __DIR__.'/../../inc/auth.php';
require __DIR__.'/../../inc/db.php';
require __DIR__.'/../../vendor/autoload.php';

use Dompdf\Dompdf;

$class_id = (int)($_GET['class_id'] ?? 0);
$start = $_GET['start'] ?? date('Y-m-01');
$end = $_GET['end'] ?? date('Y-m-t');
$hari_seharusnya = (int)($_GET['hari_seharusnya'] ?? 0);

// === Load Template Tanda Tangan ===
$templateFile = __DIR__.'/template_footer.json';
$template = file_exists($templateFile)
  ? json_decode(file_get_contents($templateFile), true)
  : ['label' => 'Kepala Sekolah', 'name' => '', 'active' => true];

$showFooter = $template['active'] ?? false;
$label = htmlspecialchars($template['label'] ?? '');
$name  = htmlspecialchars($template['name'] ?? '');

// === Load Setting Kolom NIM ===
$settingFile = __DIR__.'/rekap_settings.json';
$show_nim = true;
if (file_exists($settingFile)) {
  $json = json_decode(file_get_contents($settingFile), true);
  $show_nim = $json['show_nim'] ?? true;
}

// === Query Data Absensi ===
$q = $conn->query("
  SELECT s.nim, s.name,
  SUM(a.status='Hadir') AS hadir,
  SUM(a.status='Izin') AS izin,
  SUM(a.status='Sakit') AS sakit,
  SUM(a.status='Alfa') AS alfa,
  COUNT(a.id) AS total
  FROM students s
  LEFT JOIN attendance_daily a ON s.id=a.student_id AND a.tanggal BETWEEN '$start' AND '$end'
  WHERE s.class_id=$class_id GROUP BY s.id ORDER BY s.name
");

// === Generate HTML ===
$html = '
<style>
body { font-family: Arial, sans-serif; font-size: 12px; margin: 40px; }
h2, h4 { text-align: center; margin: 0; }
table { width: 100%; border-collapse: collapse; margin-top: 15px; }
th, td { border: 1px solid #555; padding: 6px; text-align: center; }
th { background: #e3f2fd; }
.footer { text-align: right; margin-top: 40px; }
</style>

<div class="header">
  <h2>LAPORAN REKAP ABSENSI SISWA</h2>
  <h4>Periode '.htmlspecialchars($start).' s.d '.htmlspecialchars($end).'</h4>
</div>

<table>
<thead>
<tr>
<th>No</th>';
if ($show_nim) $html .= '<th>NIM</th>';
$html .= '<th>Nama</th>
<th>Hadir</th><th>Izin</th><th>Sakit</th><th>Alfa</th><th>Total</th><th>% Kehadiran</th>
</tr>
</thead>
<tbody>';

$no = 1; $totalPersen = 0; $count = 0;
while ($r = $q->fetch_assoc()) {
  $hadir = (int)$r['hadir'];
  $persen = ($hari_seharusnya > 0) ? round(($hadir / $hari_seharusnya) * 100, 2) : 0;
  $totalPersen += $persen; $count++;

  $html .= "<tr><td>$no</td>";
  if ($show_nim) $html .= "<td>{$r['nim']}</td>";
  $html .= "<td>{$r['name']}</td>
  <td>{$r['hadir']}</td>
  <td>{$r['izin']}</td>
  <td>{$r['sakit']}</td>
  <td>{$r['alfa']}</td>
  <td>{$r['total']}</td>
  <td>{$persen}%</td></tr>";
  $no++;
}

$rata = $count > 0 ? round($totalPersen / $count, 2) : 0;
$html .= "<tr><td colspan='".($show_nim ? 8 : 7)."' style='text-align:right;font-weight:bold'>Rata-rata Kelas</td><td><b>{$rata}%</b></td></tr>";

$html .= '</tbody></table>';

if ($showFooter) {
  $html .= "<div class='footer'>
  Ditetapkan pada tanggal ".date('d-m-Y')."<br><br>
  <b>$label</b><br><br><br>
  <u>$name</u>
  </div>";
}

// === Generate PDF ===
$dompdf = new Dompdf();
$dompdf->loadHtml($html);
$dompdf->setPaper('A4', 'portrait');
$dompdf->render();
$dompdf->stream("Rekap_Absensi_$start-$end.pdf", ["Attachment" => false]);
exit;
?>
