<?php
require __DIR__ . '/../../inc/auth.php';
require __DIR__ . '/../../inc/db.php';
require_once __DIR__ . '/../../vendor/autoload.php';
$title = "Rekap Absensi Harian";
ob_start();

// Ambil daftar kelas
$kelas = $conn->query("
  SELECT c.id, CONCAT(t.name, ' - ', g.name, ' - ', c.name) AS class_name
  FROM classes c
  LEFT JOIN class_tiers t ON c.tier_id = t.id
  LEFT JOIN class_groups g ON c.group_id = g.id
  ORDER BY t.name, g.name, c.name
");
?>

<style>
/* === KHUSUS MOBILE: RAPIHIN REKAP HARIAN === */
@media (max-width: 768px) {
  .rekap-card-root {
    padding: 1.25rem;
    border-radius: 1rem;
  }

  .rekap-header {
    font-size: 1rem;
  }

  .rekap-filter-row {
    flex-direction: column;
    align-items: stretch;
    gap: 0.5rem;
  }

  .rekap-filter-row select,
  .rekap-filter-row input,
  .rekap-filter-row button {
    width: 100%;
    font-size: 0.9rem;
  }

  .rekap-action-row {
    flex-wrap: wrap;
    gap: 0.5rem;
  }

  .rekap-action-row button {
    font-size: 0.8rem;
    padding-inline: 0.65rem;
    padding-block: 0.4rem;
  }

  .rekap-table-wrapper {
    margin-top: 1rem;
    overflow-x: auto;
    -webkit-overflow-scrolling: touch;
    border-radius: 0.75rem;
    border: 1px solid rgba(255,255,255,0.08);
  }

  #rekapContainer table {
    min-width: 720px; /* biar kolom nggak mentok & bisa discroll */
    font-size: 0.8rem;
  }

  #rekapContainer th,
  #rekapContainer td {
    padding: 0.4rem 0.5rem;
  }

  #editModal > div {
    width: 90%;
    max-width: 22rem;
  }
}
</style>

<div class="p-6 bg-[#141D2F] rounded-2xl border border-white/10 rekap-card-root">
  <div class="flex flex-col gap-4">
    <!-- Header Judul -->
    <h1 class="text-lg font-semibold text-[#8CE0FF] flex items-center gap-2 rekap-header">
      📊 Rekap Absensi Harian
    </h1>

    <!-- Filter -->
    <div class="flex flex-wrap items-center gap-3 rekap-filter-row">
      <select id="classSelect"
        class="p-2 rounded bg-[#0E1525] border border-white/10 text-[#B7C9E5] w-1/3 focus:outline-none focus:border-[#5B8CFF] transition">
        <option value="">-- Pilih Kelas --</option>
        <?php while ($c = $kelas->fetch_assoc()): ?>
          <option value="<?= $c['id'] ?>"><?= $c['class_name'] ?></option>
        <?php endwhile; ?>
      </select>

      <input type="date" id="tanggal"
        class="p-2 rounded bg-[#0E1525] border border-white/10 text-[#B7C9E5] focus:outline-none focus:border-[#5B8CFF] transition"
        value="<?= date('Y-m-d') ?>">

      <button onclick="loadRekap()"
        class="bg-[#3B82F6] hover:bg-[#60A5FA] text-white px-4 py-2 rounded-lg text-sm font-medium transition">
        Tampilkan
      </button>
    </div>

    <!-- Tombol Export -->
    <div class="flex gap-3 mt-2 rekap-action-row">
      <button onclick="goRekapPeriode()"
        class="bg-[#10B981] hover:bg-[#34D399] text-white px-4 py-2 rounded-lg text-sm font-medium transition">
        📆 Rekap Periode
      </button>

      <button onclick="exportExcel()"
        class="bg-[#FBBF24] hover:bg-[#FCD34D] text-[#0E1525] px-4 py-2 rounded-lg text-sm font-medium transition">
        📗 Export Excel
      </button>

      <button onclick="exportPDF()"
        class="bg-[#EF4444] hover:bg-[#F87171] text-white px-4 py-2 rounded-lg text-sm font-medium transition">
        📕 Export PDF
      </button>
    </div>

    <!-- Container hasil rekap -->
    <div id="rekapContainer" class="hidden mt-6">
      <div class="rekap-table-wrapper">
        <table class="min-w-full text-sm text-[#B7C9E5]">
          <thead class="text-[#8CE0FF] border-b border-white/10">
            <tr>
              <th class="p-2 text-left">No</th>
              <th class="p-2 text-left">NIM</th>
              <th class="p-2 text-left">Nama</th>
              <th class="p-2 text-center">Status</th>
              <th class="p-2 text-left">Keterangan</th>
              <th class="p-2 text-center">Waktu</th>
              <th class="p-2 text-center">Aksi</th>
            </tr>
          </thead>
          <tbody id="rekapBody"></tbody>
        </table>
      </div>
    </div>

    <div id="editModal" class="hidden fixed inset-0 bg-black/70 flex items-center justify-center z-[999]">
      <div class="bg-[#1F2A44] p-5 rounded-xl w-80 border border-white/20">
        <h3 class="text-[#8CE0FF] mb-3 font-semibold">Edit Absensi</h3>

        <input type="hidden" id="editId">

        <label class="text-[#B7C9E5] text-sm">Status:</label>
        <select id="editStatus" class="w-full mt-1 p-2 bg-[#0E1525] border border-white/10 rounded text-white">
          <option value="Hadir">Hadir</option>
          <option value="Alfa">Alfa</option>
          <option value="Izin">Izin</option>
          <option value="Sakit">Sakit</option>
        </select>

        <label class="text-[#B7C9E5] text-sm mt-3 block">Keterangan:</label>
        <input id="editKet" type="text" class="w-full mt-1 p-2 bg-[#0E1525] border border-white/10 rounded text-white"
          placeholder="Opsional...">

        <div class="flex justify-end mt-4 gap-2">
          <button onclick="closeEditModal()" class="px-3 py-1 bg-gray-500 rounded">Batal</button>
          <button onclick="saveEdit()" class="px-3 py-1 bg-[#3B82F6] text-white rounded">Simpan</button>
        </div>
      </div>
    </div>

  </div>
</div>

<script>
  function showToast(msg, type = 'info') {
    const color = type === 'success' ? '#37F297'
      : type === 'error' ? '#FF5B5B'
      : type === 'warning' ? '#FFD15B' : '#5B8CFF';
    const toast = document.createElement('div');
    toast.textContent = msg;
    Object.assign(toast.style, {
      position: 'fixed', bottom: '25px', right: '25px', background: color,
      color: '#0E1525', padding: '10px 15px', borderRadius: '8px',
      fontWeight: 'bold', boxShadow: '0 2px 8px rgba(0,0,0,0.3)',
      zIndex: '9999', opacity: '0', transition: 'opacity 0.3s'
    });
    document.body.appendChild(toast);
    setTimeout(() => toast.style.opacity = '1', 10);
    setTimeout(() => toast.style.opacity = '0', 2300);
    setTimeout(() => toast.remove(), 2600);
  }

  function loadRekap(showToastMsg = true) {
    const classId = document.getElementById('classSelect').value;
    const tanggal = document.getElementById('tanggal').value;
    if (!classId) return showToast('⚠️ Pilih kelas terlebih dahulu.', 'warning');
    fetch(`rekap_harian.php?load_rekap=1&class_id=${classId}&tanggal=${tanggal}`)
      .then(r => r.json())
      .then(d => {
        const tbody = document.getElementById('rekapBody');
        tbody.innerHTML = '';
        if (!d.success || d.data.length === 0) {
          tbody.innerHTML = `<tr><td colspan="7" class="text-center text-gray-400 p-3">Belum ada data absensi untuk tanggal ini.</td></tr>`;
          document.getElementById('rekapContainer').classList.remove('hidden');
          return;
        }
        d.data.forEach((s, i) => {
  const statusClass =
    s.status === 'Hadir'
      ? 'bg-emerald-500/15 text-emerald-300 border border-emerald-500/40'
      : s.status === 'Sakit'
      ? 'bg-amber-500/15 text-amber-300 border border-amber-500/40'
      : s.status === 'Izin'
      ? 'bg-sky-500/15 text-sky-300 border border-sky-500/40'
      : 'bg-rose-500/15 text-rose-300 border border-rose-500/40';

  tbody.innerHTML += `
    <tr class="border-b border-white/5 hover:bg-[#0E1525]/60">
      <td class="p-2">${i + 1}</td>
      <td class="p-2">${s.nim}</td>
      <td class="p-2">${s.name}</td>
      <td class="p-2 text-center">
        <span class="inline-flex items-center justify-center px-2.5 py-0.5 rounded-full text-xs font-semibold ${statusClass}">
          ${s.status}
        </span>
      </td>
      <td class="p-2">${s.keterangan || '-'}</td>
      <td class="p-2 text-center">${s.jam_masuk || '-'}</td>
      <td class="p-2 text-center">
        <button onclick="openEditModal(${s.id}, '${s.status}', '${s.keterangan || ''}')"
          class="text-[#37F297] hover:text-white transition">Edit</button>
      </td>
    </tr>`;
});

        document.getElementById('rekapContainer').classList.remove('hidden');
        if (showToastMsg) showToast('Rekap absensi berhasil dimuat.', 'success');
      })
      .catch(() => showToast('❌ Gagal memuat data rekap.', 'error'));
  }

  function exportExcel() {
    const classId = document.getElementById('classSelect').value;
    const tanggal = document.getElementById('tanggal').value;
    if (!classId) return showToast('Pilih kelas terlebih dahulu.', 'warning');
    window.location.href = `rekap_harian.php?export=excel&class_id=${classId}&tanggal=${tanggal}`;
  }

  function exportPDF() {
    const classId = document.getElementById('classSelect').value;
    const tanggal = document.getElementById('tanggal').value;
    if (!classId) return showToast(' Pilih kelas terlebih dahulu.', 'warning');
    window.open(`print_rekap_harian.php?class_id=${classId}&tanggal=${tanggal}`, '_blank');
  }

  function goRekapPeriode() {
    window.location.href = "rekap_periode.php";
  }
  
  // === MODAL EDIT ===
  function openEditModal(id, status, ket) {
    document.getElementById("editId").value = id;
    document.getElementById("editStatus").value = status;
    document.getElementById("editKet").value = ket;
    document.getElementById("editModal").classList.remove("hidden");
  }

  function closeEditModal() {
    document.getElementById("editModal").classList.add("hidden");
  }

  function saveEdit() {
    const id = document.getElementById("editId").value;
    const status = document.getElementById("editStatus").value;
    const ket = document.getElementById("editKet").value;

    fetch("rekap_harian.php?update_absen=1", {
      method: "POST",
      headers: { "Content-Type": "application/x-www-form-urlencoded" },
      body: `id=${id}&status=${status}&keterangan=${ket}`
    })
    .then(r => r.json())
    .then(d => {
      if (d.success) {
        showToast("Absensi berhasil diperbarui", "success");
        closeEditModal();
        loadRekap(false);
      } else {
        showToast("❌ Gagal update data", "error");
      }
    })
    .catch(() => showToast("⚠️ Terjadi kesalahan server", "error"));
  }
</script>

<?php
$content = ob_get_clean();

// === LOAD DATA (AJAX) ===
if (isset($_GET['load_rekap'])) {
  header('Content-Type: application/json; charset=utf-8');
  $class_id = (int) ($_GET['class_id'] ?? 0);
  $tanggal = $_GET['tanggal'] ?? date('Y-m-d');

  $q = $conn->query("
  SELECT a.id, s.nim, s.name, a.status, a.keterangan, a.jam_masuk
  FROM attendance_daily a
  JOIN students s ON a.student_id = s.id
  WHERE a.class_id = $class_id AND a.tanggal = '$tanggal'
  ORDER BY s.name
");

  echo json_encode(['success' => true, 'data' => $q->fetch_all(MYSQLI_ASSOC)]);
  exit;
}

// === EXPORT EXCEL & PDF ===
if (isset($_GET['export'])) {
  $class_id = (int)($_GET['class_id'] ?? 0);
  $tanggal = $_GET['tanggal'] ?? date('Y-m-d');

  $q = $conn->query("
    SELECT s.name AS nama, CONCAT(t.name, ' - ', g.name, ' - ', c.name) AS kelas,
           a.status, a.keterangan
    FROM attendance_daily a
    JOIN students s ON a.student_id = s.id
    JOIN classes c ON a.class_id = c.id
    LEFT JOIN class_tiers t ON c.tier_id = t.id
    LEFT JOIN class_groups g ON c.group_id = g.id
    WHERE a.class_id = $class_id AND a.tanggal = '$tanggal'
    ORDER BY s.name
  ");
  $data = $q->fetch_all(MYSQLI_ASSOC);

  $judul = "LAPORAN REKAP ABSENSI SISWA";
  $periode = "Tanggal " . date('d/m/Y', strtotime($tanggal));
  // Ambil nama kelas langsung dari tabel classes
  $getClass = $conn->query("
    SELECT CONCAT(t.name, ' - ', g.name, ' - ', c.name) AS nama_kelas
    FROM classes c
    LEFT JOIN class_tiers t ON c.tier_id = t.id
    LEFT JOIN class_groups g ON c.group_id = g.id
    WHERE c.id = $class_id
  ");
  $rowClass = $getClass->fetch_assoc();
  $nama_kelas = $rowClass['nama_kelas'] ?? '-';

  // === EXPORT EXCEL ===
  if ($_GET['export'] === 'excel') {
    header("Content-Type: application/vnd.ms-excel");
    header("Content-Disposition: attachment; filename=rekap_absensi_$tanggal.xls");

    echo "<table border='1' cellspacing='0' cellpadding='5'>";
    echo "<tr><th colspan='5' style='text-align:center; font-weight:bold;'>$judul</th></tr>";
    echo "<tr><th colspan='5' style='text-align:center;'>Kelas: $nama_kelas</th></tr>";
    echo "<tr><th colspan='5' style='text-align:center;'>$periode</th></tr>";
    echo "<tr><th>No</th><th>Nama</th><th>Kelas</th><th>Status</th><th>Keterangan</th></tr>";

    $no = 1;
    foreach ($data as $row) {
      echo "<tr>
              <td>{$no}</td>
              <td>{$row['nama']}</td>
              <td>{$row['kelas']}</td>
              <td>{$row['status']}</td>
              <td>{$row['keterangan']}</td>
            </tr>";
      $no++;
    }
    echo "</table>";
    exit;
  }

  // === EXPORT PDF ===
  if ($_GET['export'] === 'pdf') {
    $html = "
    <div style='text-align:center; margin-bottom:10px;'>
        <h3 style='margin:0; font-family:Arial, sans-serif;'>$judul</h3>
        <p style='margin:4px 0; font-size:13px; font-family:Arial, sans-serif;'>Kelas: <b>$nama_kelas</b></p>
        <p style='margin:0; font-size:13px; font-family:Arial, sans-serif;'>$periode</p>
    </div>
    <table border='1' cellspacing='0' cellpadding='6' width='100%' 
           style='border-collapse:collapse; font-size:12px; font-family:Arial, sans-serif;'>
      <thead style='background-color:#f0f0f0; font-weight:bold; text-align:center;'>
        <tr>
          <th>No</th><th>Nama</th><th>Kelas</th><th>Status</th><th>Keterangan</th>
        </tr>
      </thead>
      <tbody>";

    $no = 1;
    foreach ($data as $row) {
        $html .= "<tr>
            <td style='text-align:center;'>$no</td>
            <td>{$row['nama']}</td>
            <td>{$row['kelas']}</td>
            <td style='text-align:center;'>{$row['status']}</td>
            <td>{$row['keterangan']}</td>
        </tr>";
        $no++;
    }

    if (empty($data)) {
        $html .= "<tr><td colspan='5' style='text-align:center; color:#999;'>Tidak ada data absensi.</td></tr>";
    }

    $html .= "</tbody></table>";

    $mpdf = new \Mpdf\Mpdf(['format' => 'A4']);
    $mpdf->WriteHTML($html);
    $mpdf->Output("rekap_absensi_$tanggal.pdf", "D");
    exit;
  }
}

if (isset($_GET['update_absen'])) {
    header('Content-Type: application/json; charset=utf-8');

    $id = (int)($_POST['id'] ?? 0);
    $status = $conn->real_escape_string($_POST['status'] ?? '');
    $keterangan = $conn->real_escape_string($_POST['keterangan'] ?? '');

    $q = $conn->query("
      UPDATE attendance_daily
      SET status='$status', keterangan='$keterangan'
      WHERE id=$id
    ");

    echo json_encode(['success' => $q ? true : false]);
    exit;
}

require __DIR__ . '/../../inc/layout.php';
?>
