<?php
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);

require __DIR__ . '/../../inc/auth.php';
require __DIR__ . '/../../inc/db.php';
if (isset($_GET['load_rekap'])) {
  header('Content-Type: application/json; charset=utf-8');
  require __DIR__ . '/../../inc/db.php';

  $class_id = (int) ($_GET['class_id'] ?? 0);
  $start = $_GET['start'] ?? date('Y-m-01');
  $end = $_GET['end'] ?? date('Y-m-t');

  if (!$class_id || !$start || !$end) {
    echo json_encode(['success' => false, 'error' => 'Parameter tidak valid.']);
    exit;
  }

  $sql = "
    SELECT s.nim, s.name,
      SUM(CASE WHEN a.status = 'Hadir' THEN 1 ELSE 0 END) AS hadir,
      SUM(CASE WHEN a.status = 'Izin' THEN 1 ELSE 0 END) AS izin,
      SUM(CASE WHEN a.status = 'Sakit' THEN 1 ELSE 0 END) AS sakit,
      SUM(CASE WHEN a.status = 'Alfa' THEN 1 ELSE 0 END) AS alfa,
      COUNT(a.id) AS total
    FROM students s
    LEFT JOIN attendance_daily a
      ON a.student_id = s.id
      AND a.tanggal BETWEEN ? AND ?
    WHERE s.class_id = ?
    GROUP BY s.id
    ORDER BY s.name
  ";

  try {
    $stmt = $conn->prepare($sql);
    $stmt->bind_param("ssi", $start, $end, $class_id);
    $stmt->execute();

    $result = [];
    $stmt->bind_result($nim, $name, $hadir, $izin, $sakit, $alfa, $total);

    while ($stmt->fetch()) {
      $result[] = [
        'nim'   => $nim,
        'name'  => $name,
        'hadir' => $hadir,
        'izin'  => $izin,
        'sakit' => $sakit,
        'alfa'  => $alfa,
        'total' => $total
      ];
    }

    echo json_encode(['success' => true, 'data' => $result]);
    $stmt->close();
    exit;
  } catch (Exception $e) {
    echo json_encode(['success' => false, 'error' => $e->getMessage()]);
    exit;
  }
}

$title = "Rekap Absensi Periode";
ob_start();

$kelas = $conn->query("
  SELECT c.id, CONCAT(t.name, ' - ', g.name, ' - ', c.name) AS class_name
  FROM classes c
  LEFT JOIN class_tiers t ON c.tier_id = t.id
  LEFT JOIN class_groups g ON c.group_id = g.id
  ORDER BY t.name, g.name, c.name
");

$settingFile = __DIR__ . '/rekap_settings.json';
$show_nim = true;
if (file_exists($settingFile)) {
  $json = json_decode(file_get_contents($settingFile), true);
  $show_nim = $json['show_nim'] ?? true;
}
?>

<style>
  .table-container {
    max-height: 520px;
    overflow-y: auto;
    border-radius: 8px;
  }

  thead th {
    position: sticky;
    top: 0;
    background: #0E1525;
    z-index: 2;
  }

  .sticky-top {
    position: sticky;
    top: 0;
    z-index: 10;
    background-color: #141D2F;
  }

  .notif {
    position: fixed;
    top: 30px;
    left: 50%;
    transform: translateX(-50%);
    padding: 12px 20px;
    border-radius: 8px;
    font-weight: 600;
    color: #fff;
    box-shadow: 0 4px 15px rgba(0, 0, 0, 0.3);
    z-index: 9999;
    transition: all 0.5s ease;
    opacity: 1;
  }

  .notif.success {
    background: linear-gradient(135deg, #37F297, #14C38E);
  }

  .notif.error {
    background: linear-gradient(135deg, #FF6B6B, #C93B3B);
  }

  .notif.warning {
    background: linear-gradient(135deg, #FACC15, #EAB308);
    color: #0E1525;
  }

  .action-btn {
    padding: 5px 6px !important;
    font-size: 12px !important;
    font-weight: 600;
    border-radius: 6px;
    transition: all 0.2s ease-in-out;
  }
  .action-btn:hover {
    filter: brightness(1.15);
    transform: translateY(-1px);
  }
  .btn-yellow { background: #FFD15B; color: #0E1525; }
  .btn-green  { background: #37F297; color: #0E1525; }
  .btn-blue   { background: #5B8CFF; color: #0E1525; }
  .btn-yellow:hover, .btn-green:hover, .btn-blue:hover {
    filter: brightness(1.25);
  }

  .flex.gap-2 { gap: 6px; }

  .table-container::-webkit-scrollbar {
    width: 6px;
    height: 6px;
  }
  .table-container::-webkit-scrollbar-thumb {
    background: linear-gradient(180deg, #8CE0FF, #5B8CFF);
    border-radius: 10px;
  }
  .table-container::-webkit-scrollbar-thumb:hover {
    background: linear-gradient(180deg, #5B8CFF, #8CE0FF);
  }
  .table-container::-webkit-scrollbar-track {
    background: rgba(255, 255, 255, 0.05);
    border-radius: 10px;
  }

  /* ===== FILTER DATE + ICON KALENDER ===== */
  .filter-date-wrapper {
    position: relative;
    width: 100%;
  }
  /* default (desktop & umum) – biarkan seperti input biasa */
  .filter-date-wrapper input[type="date"] {
    width: 100%;
    padding-right: 0.8rem;
  }
  /* icon custom disembunyikan di desktop, supaya tidak dobel */
  .filter-date-icon {
    position: absolute;
    right: 0.75rem;
    top: 50%;
    transform: translateY(-50%);
    font-size: 0.9rem;
    color: #F9FAFB;
    cursor: pointer;
    z-index: 2;
    display: none; /* <– penting: desktop pakai icon native saja */
  }

  /* ===== TOMBOL AKSI MOBILE ===== */
  .desktop-actions {
    display: flex;
    gap: 6px;
  }
  .mobile-action-wrapper {
    display: none;
    position: relative;
  }
  .mobile-action-btn {
    padding: 5px 10px;
    font-size: 12px;
    font-weight: 600;
    border-radius: 6px;
    background: #5B8CFF;
    color: #0E1525;
    border: none;
    cursor: pointer;
  }
  .mobile-action-menu {
    position: absolute;
    right: 0;
    top: 115%;
    min-width: 190px;
    background: #0E1525;
    border-radius: 0.75rem;
    border: 1px solid rgba(255,255,255,0.1);
    box-shadow: 0 10px 30px rgba(0,0,0,0.6);
    padding: 4px 0;
    z-index: 50;
    display: none;
  }
  .mobile-action-menu.show { display: block; }
  .mobile-action-menu button {
    width: 100%;
    text-align: left;
    padding: 8px 12px;
    font-size: 13px;
    background: transparent;
    border: none;
    color: #E5E7EB;
    cursor: pointer;
  }
  .mobile-action-menu button:hover {
    background: #141D2F;
  }


@media (min-width: 769px) {
  .filter-date-wrapper input[type="date"]::-webkit-calendar-picker-indicator {
    filter: invert(1); /* bikin icon gelap jadi putih */
  }
  #startDate,
  #endDate {
    width: 190px;
     margin-right: 1rem; 
  }
}
/* === Desktop: Biar semua input sejajar ke samping === */
@media (min-width: 1024px) {
  .filter-row {
    display: flex;
    align-items: center;
    gap: 0.75rem; /* jarak antar elemen */
    flex-wrap: nowrap;
  }

  .filter-row select,
  .filter-row input,
  .filter-row button {
    flex: none; /* biar ukuran tetap stabil */
    height: 40px; /* seragam tinggi */
  }

  /* Sesuaikan lebar masing-masing biar proporsional */
  #classSelect { width: 220px; }
  #startDate, #endDate { width: 160px; }
  #hariSeharusnya { width: 130px; }
  #filterSiswa { width: 220px; }
  .filter-row button { width: 120px; }
}

/* === Mobile tetap seperti sebelumnya === */
@media (max-width: 1023px) {
  .filter-row {
    display: flex;
    flex-direction: column;
    gap: 0.75rem;
  }

  .filter-row select,
  .filter-row input,
  .filter-row button {
    width: 100%;
  }
}

  /* ===== MOBILE ONLY ===== */
  @media (max-width: 768px) {
    .desktop-actions { display: none; }
    .mobile-action-wrapper { display: block; }

    /* di mobile, sembunyikan native icon & tampilkan icon custom */
    .filter-date-wrapper input[type="date"] {
      -webkit-appearance: none;
      appearance: none;
      background-color: #0E1525;
      position: relative;
      z-index: 1;
      padding-right: 2.5rem; /* ruang untuk icon custom */
    }
    .filter-date-wrapper input[type="date"]::-webkit-calendar-picker-indicator,
    .filter-date-wrapper input[type="date"]::-webkit-clear-button,
    .filter-date-wrapper input[type="date"]::-webkit-inner-spin-button {
      display: none !important;
      -webkit-appearance: none;
    }
    .filter-date-icon {
      display: block;          /* hanya muncul di mobile */
      color: #E5E7EB;
    }
  }
</style>

<div class="p-6 bg-[#141D2F] rounded-2xl border border-white/10">
  <div class="flex justify-between items-center sticky-top p-2">
    <div class="flex items-center gap-3">
      <h1 class="text-xl font-semibold text-[#8CE0FF]">🏫 Rekap Absensi Siswa per Periode</h1>
    </div>

    <div class="flex items-center gap-2">
      <!-- Desktop buttons (tetap) -->
      <div class="desktop-actions flex gap-2">
        <button
          onclick="showNotif('Menyiapkan tampilan PDF...'); window.open('print_rekap_periode.php?' + getQueryString(), '_blank')"
          class="action-btn btn-yellow">
          🖨️ Print PDF
        </button>
        <button
          onclick="showNotif('Sedang menyiapkan file Excel...'); window.open('export_rekap_periode.php?' + getQueryString(), '_blank')"
          class="action-btn btn-green">
          ⬇️ Download Excel
        </button>
        <button onclick="openTemplateModal()" class="action-btn btn-yellow">
          🖋️ Ubah Template Tanda Tangan
        </button>
        <button onclick="openSettingModal()" class="action-btn btn-blue">
          ⚙️ Pengaturan Kolom
        </button>
        <button onclick="openLinkModal()" class="action-btn btn-blue">
          🔗 Buat Link Publik
        </button>
      </div>

      <!-- Mobile action menu -->
      <div class="mobile-action-wrapper">
        <button id="mobileActionBtn" class="mobile-action-btn">⋮ Aksi</button>
        <div id="mobileActionMenu" class="mobile-action-menu">
          <button onclick="mobilePrintPDF()">🖨️ Print PDF</button>
          <button onclick="mobileDownloadExcel()">⬇️ Download Excel</button>
          <button onclick="openTemplateModal()">🖋️ Ubah Template Tanda Tangan</button>
          <button onclick="openSettingModal()">⚙️ Pengaturan Kolom</button>
          <button onclick="openLinkModal()">🔗 Buat Link Publik</button>
        </div>
      </div>
    </div>
  </div>

<div class="filter-row mb-4 mt-3">
  <select id="classSelect" class="p-2 rounded bg-[#0E1525] border border-white/10 text-[#B7C9E5]">
    <option value="">-- Pilih Kelas --</option>
    <?php while ($c = $kelas->fetch_assoc()): ?>
      <option value="<?= $c['id'] ?>"><?= $c['class_name'] ?></option>
    <?php endwhile; ?>
  </select>

  <div class="filter-date-wrapper">
    <input type="date" id="startDate" class="p-2 rounded bg-[#0E1525] border border-white/10 text-[#B7C9E5]">
    <span class="filter-date-icon"><i class="fa-regular fa-calendar"></i></span>
  </div>

  <div class="filter-date-wrapper">
    <input type="date" id="endDate" class="p-2 rounded bg-[#0E1525] border border-white/10 text-[#B7C9E5]">
    <span class="filter-date-icon"><i class="fa-regular fa-calendar"></i></span>
  </div>

  <input type="number" id="hariSeharusnya" placeholder="Hari seharusnya"
    class="p-2 rounded bg-[#0E1525] border border-white/10 text-[#B7C9E5]">

  <input type="text" id="filterSiswa" placeholder="Cari NIM / Nama..."
    class="p-2 rounded bg-[#0E1525] border border-white/10 text-[#B7C9E5]">

  <button onclick="loadRekapPeriode()"
    class="bg-[#5B8CFF] px-4 py-2 rounded font-semibold text-[#0E1525] hover:bg-[#8CE0FF] transition">
    Tampilkan
  </button>
</div>


  <!-- Tabel -->
  <div id="rekapContainer" class="hidden">
    <div class="table-container border border-white/10">
      <table class="min-w-full text-sm text-[#B7C9E5]" id="rekapTable">
        <thead class="text-[#8CE0FF] border-b border-white/10">
          <tr>
            <th class="p-2 text-left">No</th>
            <?php if ($show_nim): ?>
              <th class="p-2 text-left">NIM</th>
            <?php endif; ?>
            <th class="p-2 text-left">Nama</th>
            <th class="p-2 text-center">Hadir</th>
            <th class="p-2 text-center">Izin</th>
            <th class="p-2 text-center">Sakit</th>
            <th class="p-2 text-center">Alfa</th>
            <th class="p-2 text-center">Total Hari</th>
            <th class="p-2 text-center">% Kehadiran</th>
          </tr>
        </thead>
        <tbody id="rekapBody"></tbody>
      </table>
    </div>
  </div>

  <!-- Modal Template -->
  <div id="templateModal" class="fixed inset-0 bg-black/60 hidden items-center justify-center z-50">
    <div class="bg-[#141D2F] border border-white/10 rounded-xl p-6 w-[90%] sm:w-[400px] text-[#B7C9E5] relative">
      <h2 class="text-lg font-semibold text-[#8CE0FF] mb-3">🖋️ Ubah Template Tanda Tangan</h2>
      <label>Jabatan</label>
      <input id="labelInput" type="text" class="w-full p-2 mb-2 bg-[#0E1525] border border-white/10 rounded">
      <label>Nama Penandatangan</label>
      <input id="nameInput" type="text" class="w-full p-2 mb-2 bg-[#0E1525] border border-white/10 rounded">
      <label class="flex items-center gap-2 mb-4">
        <input id="activeInput" type="checkbox"> Tampilkan di laporan
      </label>
      <div class="flex justify-end gap-2">
        <button onclick="saveTemplate()"
          class="bg-[#5B8CFF] hover:bg-[#8CE0FF] px-3 py-2 rounded text-[#0E1525] font-semibold">Simpan</button>
        <button onclick="closeTemplateModal()"
          class="bg-gray-500 hover:bg-gray-400 px-3 py-2 rounded text-white">Batal</button>
      </div>
    </div>
  </div>

  <!-- Modal Link Publik -->
  <div id="linkModal" class="fixed inset-0 bg-black/60 hidden items-center justify-center z-50">
    <div class="bg-[#141D2F] border border-white/10 rounded-xl p-6 w-[90%] sm:w-[400px] text-[#B7C9E5] relative">
      <h2 class="text-lg font-semibold text-[#8CE0FF] mb-3">🔗 Buat Link Publik Rekap</h2>

      <label class="block mb-1">Gunakan Periode?</label>
      <select id="usePeriodInput" class="w-full p-2 mb-3 bg-[#0E1525] border border-white/10 rounded">
        <option value="1">✅ Ya, gunakan tanggal mulai & akhir</option>
        <option value="0">❌ Tidak, tampilkan semua data (fitur filter bulan aktif)</option>
      </select>

      <div id="periodeFields">
        <label class="block mb-1">Tanggal mulai:</label>
        <input id="startInput" type="date" class="w-full p-2 mb-2 bg-[#0E1525] border border-white/10 rounded">

        <label class="block mb-1">Tanggal akhir:</label>
        <input id="endInput" type="date" class="w-full p-2 mb-2 bg-[#0E1525] border border-white/10 rounded">
      </div>

      <label class="block mb-1">Masa aktif (hari):</label>
      <input id="daysInput" type="number" min="1" value="30" class="w-full p-2 mb-3 bg-[#0E1525] border border-white/10 rounded">

      <div class="flex justify-end gap-2">
        <button onclick="createPublicLink()" class="bg-[#5B8CFF] hover:bg-[#8CE0FF] px-3 py-2 rounded text-[#0E1525] font-semibold">Buat Link</button>
        <button onclick="closeLinkModal()" class="bg-gray-500 hover:bg-gray-400 px-3 py-2 rounded text-white">Batal</button>
      </div>

      <div id="linkResult" class="mt-3 text-[#8CE0FF] break-all hidden"></div>
    </div>
  </div>

  <!-- Modal Setting Kolom -->
  <div id="settingModal" class="fixed inset-0 bg-black/60 hidden items-center justify-center z-50">
    <div class="bg-[#141D2F] border border-white/10 rounded-xl p-6 w-[90%] sm:w-[400px] text-[#B7C9E5] relative">
      <h2 class="text-lg font-semibold text-[#8CE0FF] mb-3">⚙️ Pengaturan Kolom</h2>
      <label class="flex items-center gap-2 mb-4">
        <input id="showNimInput" type="checkbox"> Tampilkan kolom NIM
      </label>
      <div class="flex justify-end gap-2">
        <button onclick="saveSetting()"
          class="bg-[#5B8CFF] hover:bg-[#8CE0FF] px-3 py-2 rounded text-[#0E1525] font-semibold">Simpan</button>
        <button onclick="closeSettingModal()"
          class="bg-gray-500 hover:bg-gray-400 px-3 py-2 rounded text-white">Batal</button>
      </div>
    </div>
  </div>
</div>

<script>
  function showNotif(text, type = 'success') {
    const div = document.createElement('div');
    div.className = 'notif ' + type;
    div.textContent = text;
    document.body.appendChild(div);
    setTimeout(() => { div.style.opacity = '0'; }, 2000);
    setTimeout(() => { div.remove(); }, 2800);
  }

  // MOBILE ACTION MENU
  const mobileActionBtn  = document.getElementById('mobileActionBtn');
  const mobileActionMenu = document.getElementById('mobileActionMenu');

  if (mobileActionBtn && mobileActionMenu) {
    mobileActionBtn.addEventListener('click', (e) => {
      e.stopPropagation();
      mobileActionMenu.classList.toggle('show');
    });
    document.addEventListener('click', (e) => {
      if (!mobileActionMenu.contains(e.target)) {
        mobileActionMenu.classList.remove('show');
      }
    });
  }

  function mobilePrintPDF() {
    showNotif('Menyiapkan tampilan PDF...');
    window.open('print_rekap_periode.php?' + getQueryString(), '_blank');
  }
  function mobileDownloadExcel() {
    showNotif('Sedang menyiapkan file Excel...');
    window.open('export_rekap_periode.php?' + getQueryString(), '_blank');
  }

  // ICON KALENDER KLIKABLE (utama untuk mobile, tapi aman di desktop)
  document.querySelectorAll('.filter-date-wrapper').forEach(wrapper => {
    const input = wrapper.querySelector('input[type="date"]');
    const icon  = wrapper.querySelector('.filter-date-icon');
    if (input && icon) {
      icon.addEventListener('click', () => {
        if (typeof input.showPicker === 'function') {
          input.showPicker();
        } else {
          input.focus();
        }
      });
    }
  });

  function openTemplateModal() {
    fetch('template_footer.json?' + Date.now())
      .then(r => r.json())
      .then(d => {
        document.getElementById('labelInput').value = d.label || '';
        document.getElementById('nameInput').value = d.name || '';
        document.getElementById('activeInput').checked = d.active === true;
        document.getElementById('templateModal').classList.remove('hidden');
        document.getElementById('templateModal').classList.add('flex');
      });
  }
  function closeTemplateModal() {
    document.getElementById('templateModal').classList.add('hidden');
    document.getElementById('templateModal').classList.remove('flex');
  }
  function saveTemplate() {
    const data = {
      label: document.getElementById('labelInput').value.trim(),
      name: document.getElementById('nameInput').value.trim(),
      active: document.getElementById('activeInput').checked
    };
    fetch('save_template_footer.php', {
      method: 'POST',
      headers: { 'Content-Type': 'application/json' },
      body: JSON.stringify(data)
    }).then(r => r.json()).then(res => {
      if (res.success) {
        closeTemplateModal(); showNotif('✅ Template disimpan!', 'success');
      } else showNotif('⚠️ Gagal menyimpan template', 'error');
    }).catch(() => showNotif('❌ Kesalahan koneksi', 'error'));
  }

  function openSettingModal() {
    fetch('rekap_settings.json?' + Date.now())
      .then(r => r.json())
      .then(d => {
        document.getElementById('showNimInput').checked = d.show_nim ?? true;
        document.getElementById('settingModal').classList.remove('hidden');
        document.getElementById('settingModal').classList.add('flex');
      });
  }
  function closeSettingModal() {
    document.getElementById('settingModal').classList.add('hidden');
    document.getElementById('settingModal').classList.remove('flex');
  }
  function saveSetting() {
    const showNim = document.getElementById('showNimInput').checked;
    const formData = new FormData();
    formData.append('show_nim', showNim ? '1' : '0');

    fetch('save_rekap_settings.php', { method: 'POST', body: formData })
      .then(r => r.json())
      .then(res => {
        if (res.success) {
          showNotif('✅ Pengaturan kolom disimpan');
          closeSettingModal();

          const ths = document.querySelectorAll('#rekapTable thead th');
          const rows = document.querySelectorAll('#rekapTable tbody tr');

          if (showNim) {
            ths.forEach((th) => {
              if (th.textContent.trim() === 'Nama') {
                const newTh = document.createElement('th');
                newTh.className = 'p-2 text-left';
                newTh.textContent = 'NIM';
                th.parentNode.insertBefore(newTh, th);
              }
            });
            rows.forEach((tr) => {
              const tds = tr.querySelectorAll('td');
              if (tds.length >= 2 && !tr.querySelector('.nim-cell')) {
                const nameCell = tds[1];
                const nimCell = document.createElement('td');
                nimCell.className = 'p-2 nim-cell';
                nimCell.textContent = '-';
                tr.insertBefore(nimCell, nameCell);
              }
            });
          } else {
            ths.forEach((th) => {
              if (th.textContent.trim() === 'NIM') th.remove();
            });
            rows.forEach((tr) => {
              const nimCell = tr.querySelector('.nim-cell');
              if (nimCell) nimCell.remove();
            });
          }
        } else {
          showNotif('⚠️ Gagal menyimpan pengaturan', 'error');
        }
      })
      .catch(() => showNotif('❌ Kesalahan koneksi', 'error'));
  }

  function getQueryString() {
    const classId = document.getElementById('classSelect').value;
    const start   = document.getElementById('startDate').value;
    const end     = document.getElementById('endDate').value;
    const hari    = document.getElementById('hariSeharusnya').value || 0;
    return `class_id=${classId}&start=${start}&end=${end}&hari_seharusnya=${hari}`;
  }

  function loadRekapPeriode() {
    const classId = document.getElementById('classSelect').value;
    const start   = document.getElementById('startDate').value;
    const end     = document.getElementById('endDate').value;
    const filter  = document.getElementById('filterSiswa').value.trim().toLowerCase();
    const hari    = parseInt(document.getElementById('hariSeharusnya').value || 0);
    if (!classId || !start || !end) return showNotif('⚠️ Pilih kelas dan periode terlebih dahulu.', 'warning');

    fetch(`rekap_periode.php?load_rekap=1&class_id=${classId}&start=${start}&end=${end}`)
      .then(r => r.json())
      .then(d => {
        const tbody = document.getElementById('rekapBody');
        tbody.innerHTML = '';
        if (!d.success || d.data.length === 0) {
          tbody.innerHTML = `<tr><td colspan="9" class="text-center p-3 text-gray-400">Tidak ada data absensi dalam periode ini.</td></tr>`;
          document.getElementById('rekapContainer').classList.remove('hidden');
          return;
        }
        let totalPersen = 0;
        d.data.forEach((s, i) => {
          if (!(s.nim.toLowerCase().includes(filter) || s.name.toLowerCase().includes(filter))) return;
          const persen = hari > 0 ? ((s.hadir / hari) * 100).toFixed(2) : 0;
          totalPersen += parseFloat(persen);
          tbody.innerHTML += `
          <tr class="border-b border-white/5 hover:bg-[#0E1525]/60 transition">
            <td class="p-2">${i + 1}</td>
            <?php if ($show_nim): ?> <td class="p-2">${s.nim}</td> <?php endif; ?>
            <td class="p-2">${s.name}</td>
            <td class="p-2 text-center text-green-400 font-semibold">${s.hadir}</td>
            <td class="p-2 text-center text-blue-400">${s.izin}</td>
            <td class="p-2 text-center text-yellow-400">${s.sakit}</td>
            <td class="p-2 text-center text-red-400">${s.alfa}</td>
            <td class="p-2 text-center text-white">${s.total}</td>
            <td class="p-2 text-center text-[#8CE0FF] font-semibold">${persen}%</td>
          </tr>`;
        });
        const avg = d.data.length ? (totalPersen / d.data.length).toFixed(2) : 0;
        tbody.innerHTML += `
        <tr class="bg-[#0E1525]/70 font-semibold border-t border-white/10">
          <td colspan="<?php echo $show_nim ? 8 : 7; ?>" class="p-2 text-right text-[#8CE0FF]">Rata-rata Kehadiran Kelas:</td>
          <td class="p-2 text-center text-[#FFD15B]">${avg}%</td>
        </tr>`;
        document.getElementById('rekapContainer').classList.remove('hidden');
        showNotif('✅ Rekap periode berhasil dimuat.', 'success');
      })
      .catch(() => showNotif('⚠️ Gagal memuat data.', 'error'));
  }

  function openLinkModal() {
    document.getElementById('linkModal').classList.remove('hidden');
    document.getElementById('linkModal').classList.add('flex');
  }
  function closeLinkModal() {
    document.getElementById('linkModal').classList.add('hidden');
    document.getElementById('linkModal').classList.remove('flex');
  }

  function createPublicLink() {
    const usePeriod = parseInt(document.getElementById('usePeriodInput').value);
    const start = document.getElementById('startInput').value;
    const end   = document.getElementById('endInput').value;
    const days  = parseInt(document.getElementById('daysInput').value || 7);

    if (usePeriod && (!start || !end)) {
      showNotif('⚠️ Isi tanggal mulai dan akhir terlebih dahulu.', 'warning');
      return;
    }

    fetch('generate_public_link.php', {
      method: 'POST',
      headers: { 'Content-Type': 'application/json' },
      body: JSON.stringify({ start, end, days, use_period: usePeriod })
    })
    .then(r => r.json())
    .then(res => {
      if (res.success) {
        document.getElementById('linkResult').innerHTML = `
          ✅ Link Publik:<br>
          <a href="${res.link}" target="_blank" class="underline text-blue-400">${res.link}</a><br>
          <small>Berlaku sampai: ${res.expired_at}</small>
        `;
        document.getElementById('linkResult').classList.remove('hidden');
        showNotif('✅ Link publik berhasil dibuat!');
      } else {
        showNotif('⚠️ ' + res.error, 'error');
      }
    })
    .catch(() => showNotif('❌ Gagal membuat link', 'error'));
  }

  document.getElementById('usePeriodInput').addEventListener('change', function() {
    const fields = document.getElementById('periodeFields');
    fields.style.display = this.value == "1" ? "block" : "none";
  });
</script>

<?php
$content = ob_get_clean();
require __DIR__ . '/../../inc/layout.php';
?>
