<?php
ini_set('display_errors', 1);
error_reporting(E_ALL);
require __DIR__ . '/../../inc/db.php';

// === Validasi token ===
$token = $_GET['token'] ?? '';
if (!$token) die('<h2 style="color:red;text-align:center;margin-top:50px;">Token tidak ditemukan.</h2>');

$stmt = $conn->prepare("SELECT start, end, expired_at FROM rekap_public_links WHERE token = ?");
$stmt->bind_param("s", $token);
$stmt->execute();
$stmt->store_result();

if ($stmt->num_rows === 0) die('<h2 style="color:red;text-align:center;margin-top:50px;">Token tidak valid.</h2>');
$stmt->bind_result($start, $end, $expired_at);
$stmt->fetch();
$stmt->close();

if (strtotime($expired_at) < time()) {
  die('<h2 style="color:orange;text-align:center;margin-top:50px;">⚠️ Link ini sudah kedaluwarsa.</h2>');
}

// === Ambil daftar kelas ===
$kelas = $conn->query("
  SELECT c.id, CONCAT(t.name, ' - ', g.name, ' - ', c.name) AS class_name
  FROM classes c
  LEFT JOIN class_tiers t ON c.tier_id = t.id
  LEFT JOIN class_groups g ON c.group_id = g.id
  ORDER BY t.name, g.name, c.name
");
?>

<!DOCTYPE html>
<html lang="id">
<head>
<meta charset="UTF-8">
<meta name="viewport" content="width=device-width, initial-scale=1.0">
<title>Rekap Absensi Publik</title>
<link href="https://fonts.googleapis.com/css2?family=Poppins:wght@400;600&display=swap" rel="stylesheet">
<style>
  body {
    background: #0E1525;
    color: #B7C9E5;
    font-family: 'Poppins', sans-serif;
    margin: 0;
    padding: 0;
  }
  .container {
    max-width: 1100px;
    margin: 40px auto;
    padding: 20px;
    background: #141D2F;
    border-radius: 16px;
    border: 1px solid #1E263B;
    box-shadow: 0 4px 20px rgba(0,0,0,0.4);
  }
  h1 {
    color: #8CE0FF;
    text-align: center;
    font-size: 1.5rem;
    margin-bottom: 6px;
  }
  p.info {
    text-align: center;
    font-size: 0.9rem;
    margin-bottom: 20px;
    color: #C7D2E0;
  }
  .filter-box {
    display: flex;
    flex-wrap: wrap;
    gap: 8px;
    justify-content: center;
    margin-bottom: 14px;
  }
  select, button {
    background: #0E1525;
    border: 1px solid #1E263B;
    color: #B7C9E5;
    border-radius: 6px;
    padding: 8px 12px;
    font-weight: 500;
  }
  button {
    background: #5B8CFF;
    color: #0E1525;
    cursor: pointer;
    font-weight: 600;
  }
  button:hover { background: #8CE0FF; }
  .table-container {
    overflow-x: auto;
    border-radius: 10px;
    border: 1px solid rgba(255,255,255,0.05);
  }
  table {
    width: 100%;
    border-collapse: collapse;
    font-size: 0.9rem;
    min-width: 600px;
  }
  th, td {
    padding: 8px;
    border-bottom: 1px solid rgba(255,255,255,0.05);
    text-align: left;
  }
  th {
    color: #8CE0FF;
    background: #0E1525;
    position: sticky;
    top: 0;
  }
  tr:hover { background: rgba(255,255,255,0.05); }

  /* === RESPONSIVE MOBILE === */
  @media (max-width: 768px) {
    .container {
      width: 95%;
      margin: 20px auto;
      padding: 14px;
    }
    h1 { font-size: 1.2rem; }
    p.info { font-size: 0.8rem; }
    select, button { font-size: 0.8rem; padding: 6px 8px; }
    table { font-size: 0.8rem; min-width: 500px; }
    th, td { padding: 6px; }
    .filter-box { flex-direction: column; align-items: stretch; }
    button { width: 100%; }
  }
</style>
</head>

<body>
  <div class="container">
    <h1>📊 Rekap Absensi Siswa</h1>
    <p class="info">
      Periode: <?= date('d/m/Y', strtotime($start)) ?> – <?= date('d/m/Y', strtotime($end)) ?><br>
      Berlaku hingga: <?= date('d/m/Y', strtotime($expired_at)) ?>
    </p>

    <div class="filter-box">
      <select id="classSelect">
        <option value="">-- Pilih Kelas --</option>
        <?php while ($c = $kelas->fetch_assoc()): ?>
          <option value="<?= $c['id'] ?>"><?= $c['class_name'] ?></option>
        <?php endwhile; ?>
      </select>
      <button onclick="loadRekap()">Tampilkan</button>
    </div>

    <div class="table-container" id="rekapContainer" style="display:none;">
      <table id="rekapTable">
        <thead>
          <tr>
            <th>No</th>
            <th>NIM</th>
            <th>Nama</th>
            <th>Hadir</th>
            <th>Izin</th>
            <th>Sakit</th>
            <th>Alfa</th>
            <th>Total</th>
            <th>%</th>
          </tr>
        </thead>
        <tbody id="rekapBody"></tbody>
      </table>
    </div>
  </div>

<script>
const start = "<?= $start ?>";
const end = "<?= $end ?>";

// gunakan absolute path biar aman di mobile
const basePath = window.location.origin + "/system-absent/modules/absensi_kelas/";

function loadRekap() {
  const classId = document.getElementById('classSelect').value;
  if (!classId) {
    alert("Pilih kelas terlebih dahulu!");
    return;
  }

const basePath = window.location.origin + "/system-absent/public_api/";
fetch(`${basePath}api_public_rekap.php?token=<?= $token ?>&class_id=${classId}`)

    .then(r => r.json())
    .then(d => {
      const tbody = document.getElementById('rekapBody');
      tbody.innerHTML = '';
      if (!d.success || d.data.length === 0) {
        tbody.innerHTML = `<tr><td colspan="9" style="text-align:center;">Tidak ada data absensi.</td></tr>`;
        document.getElementById('rekapContainer').style.display = 'block';
        return;
      }
      d.data.forEach((s, i) => {
        const persen = s.total > 0 ? ((s.hadir / s.total) * 100).toFixed(1) : 0;
        tbody.innerHTML += `
          <tr>
            <td>${i + 1}</td>
            <td>${s.nim}</td>
            <td>${s.name}</td>
            <td style="color:#37F297;">${s.hadir}</td>
            <td style="color:#5B8CFF;">${s.izin}</td>
            <td style="color:#FFD15B;">${s.sakit}</td>
            <td style="color:#FF6B6B;">${s.alfa}</td>
            <td>${s.total}</td>
            <td style="color:#8CE0FF;">${persen}%</td>
          </tr>`;
      });
      document.getElementById('rekapContainer').style.display = 'block';
    })
    .catch(() => alert('⚠️ Gagal memuat data.'));
}
</script>
</body>
</html>
