<?php
require __DIR__.'/../../inc/auth.php';

$file = __DIR__.'/template_footer.json';
$data = json_decode(file_get_contents('php://input'), true);

if (!$data) {
  echo json_encode(['success' => false, 'msg' => 'Invalid data']);
  exit;
}

$json = json_encode([
  'label' => htmlspecialchars($data['label'] ?? 'Kepala Sekolah'),
  'name' => htmlspecialchars($data['name'] ?? ''),
  'active' => (bool)($data['active'] ?? false)
], JSON_PRETTY_PRINT);

if (file_put_contents($file, $json)) {
  echo json_encode(['success' => true]);
} else {
  echo json_encode(['success' => false]);
}
?>
