<?php
require __DIR__ . '/../../inc/auth.php';
require __DIR__ . '/../../inc/db.php';

$nim = trim($_GET['nim'] ?? '');

if (!$nim) {
  die("<h2 style='color:red;text-align:center;margin-top:50px;'>❌ QR Code tidak valid.</h2>");
}

$s = $conn->query("
  SELECT s.*, c.name AS class_name, g.name AS group_name, t.name AS tier_name
  FROM students s
  JOIN classes c ON s.class_id = c.id
  JOIN class_groups g ON c.group_id = g.id
  JOIN class_tiers t ON g.tier_id = t.id
  WHERE s.nim = '$nim'
  LIMIT 1
")->fetch_assoc();

if (!$s) {
  die("<h2 style='color:red;text-align:center;margin-top:50px;'>⚠️ Data siswa tidak ditemukan.</h2>");
}

$date = date('Y-m-d');
$time = date('H:i:s');

$cek = $conn->query("SELECT id FROM attendance_daily WHERE student_id={$s['id']} AND tanggal='$date'");
$alreadyAbsent = ($cek && $cek->num_rows > 0);

$now = date('Y-m-d H:i:s');
if (!empty($s['qr_expiry']) && $now > $s['qr_expiry']) {
  die("<h2 style='color:red;text-align:center;margin-top:50px;'>⚠️ QR Code sudah kedaluwarsa.</h2>");
}

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
  if (!$alreadyAbsent) {
    $q = "
      INSERT INTO attendance_daily (student_id, class_id, tanggal, jam_masuk, status, keterangan, created_at)
      VALUES ({$s['id']}, {$s['class_id']}, '$date', '$time', 'Hadir', '', NOW())
    ";
    $conn->query($q);
    $alreadyAbsent = true;
  }
}
?>
<!DOCTYPE html>
<html lang="id">
<head>
  <meta charset="UTF-8">
  <meta name="viewport" content="width=device-width, initial-scale=1.0">
  <title>Absensi QR</title>
  <link href="https://cdn.jsdelivr.net/npm/tailwindcss@3.3.2/dist/tailwind.min.css" rel="stylesheet">
  <style>
    body {
      background: linear-gradient(135deg, #dbeafe, #e0f2fe);
      font-family: 'Poppins', sans-serif;
      animation: fadeIn 0.6s ease-in-out;
      height: 100vh;
      display: flex;
      align-items: center;
      justify-content: center;
      padding: 1rem;
    }
    @keyframes fadeIn {
      from { opacity: 0; transform: scale(0.98); }
      to { opacity: 1; transform: scale(1); }
    }
    .card {
      animation: slideUp 0.6s ease-in-out;
    }
    @keyframes slideUp {
      from { opacity: 0; transform: translateY(30px); }
      to { opacity: 1; transform: translateY(0); }
    }
    .icon-box {
      background-color: #2563eb;
      width: 70px;
      height: 70px;
      border-radius: 50%;
      display: flex;
      align-items: center;
      justify-content: center;
      margin: 0 auto 1rem;
      animation: pulse 2s infinite;
    }
    .icon-box svg {
      stroke: white;
      width: 36px;
      height: 36px;
    }
    @keyframes pulse {
      0%, 100% { transform: scale(1); opacity: 1; }
      50% { transform: scale(1.05); opacity: 0.9; }
    }
  </style>
</head>
<body>

  <div class="bg-white/95 backdrop-blur-md rounded-2xl shadow-2xl p-8 w-full max-w-md border border-blue-100 card">

    <?php if (!$alreadyAbsent && $_SERVER['REQUEST_METHOD'] !== 'POST'): ?>
      <div class="icon-box">
        <svg viewBox="0 0 24 24" fill="none" stroke-width="2">
          <path d="M8 6h13M8 12h13M8 18h13M3 6h.01M3 12h.01M3 18h.01"/>
        </svg>
      </div>
      <h2 class="text-2xl font-semibold text-blue-700 mb-5 text-center">Konfirmasi Kehadiran</h2>

      <form method="POST" class="space-y-4">
        <div>
          <label class="block text-sm font-medium text-gray-600">Nama Lengkap</label>
          <input type="text" readonly value="<?= htmlspecialchars($s['name']) ?>"
            class="mt-1 w-full px-4 py-2 rounded-lg border border-gray-200 bg-gray-50 text-gray-700 focus:ring-2 focus:ring-blue-400">
        </div>

        <div>
          <label class="block text-sm font-medium text-gray-600">Kelas</label>
          <input type="text" readonly value="<?= htmlspecialchars($s['tier_name']) ?> - <?= htmlspecialchars($s['group_name']) ?> - <?= htmlspecialchars($s['class_name']) ?>"
            class="mt-1 w-full px-4 py-2 rounded-lg border border-gray-200 bg-gray-50 text-gray-700 focus:ring-2 focus:ring-blue-400">
        </div>

        <div>
          <label class="block text-sm font-medium text-gray-600">Tanggal & Waktu</label>
          <input type="text" readonly value="<?= $date ?> — <?= $time ?>"
            class="mt-1 w-full px-4 py-2 rounded-lg border border-gray-200 bg-gray-50 text-gray-700 focus:ring-2 focus:ring-blue-400">
        </div>

        <button type="submit"
          class="w-full bg-blue-600 hover:bg-blue-700 text-white font-semibold py-3 rounded-lg transition-all duration-200 shadow-md hover:shadow-xl transform hover:scale-105">
          ✅ Konfirmasi Absen Sekarang
        </button>
      </form>

    <?php elseif ($alreadyAbsent): ?>
      <div class="icon-box bg-green-500">
        <svg viewBox="0 0 24 24" fill="none" stroke-width="2">
          <polyline points="20 6 9 17 4 12" />
        </svg>
      </div>
      <h2 class="text-2xl font-bold text-green-600 mb-3 text-center">Absen Berhasil!</h2>
      <p class="text-gray-600 mb-6 text-center">
        Terima kasih, <b><?= htmlspecialchars($s['name']) ?></b><br>
        dari kelas <b><?= htmlspecialchars($s['tier_name']) ?> - <?= htmlspecialchars($s['group_name']) ?> - <?= htmlspecialchars($s['class_name']) ?></b>
      </p>
      <div class="bg-green-50 border border-green-200 text-green-700 rounded-lg py-2 text-sm font-medium text-center">
        ✅ Tanggal: <?= $date ?> — Jam: <?= $time ?>
      </div>
      <a href="/system-absent/" class="block mt-6 text-blue-600 hover:underline text-center text-sm">⬅️ Kembali ke Beranda</a>
    <?php endif; ?>

  </div>

</body>
</html>
