<?php
require __DIR__.'/../../inc/auth.php';
if(!canAccess('user','view')) {
  echo "<script>alert('Akses ditolak!');history.back();</script>";
  exit;
}

?>

<div class="p-6 rounded-2xl bg-[#141D2F] border border-white/10">
  <div class="flex justify-between items-center mb-4">
    <h1 class="text-2xl font-semibold">Daftar Akun</h1>
    <a href="tambah.php" class="bg-[#5B8CFF] text-[#0E1525] px-4 py-2 rounded-lg hover:bg-[#8CE0FF] font-semibold">+ Tambah Akun</a>
  </div>

  <table class="w-full text-sm text-left border-collapse">
    <thead class="text-[#92A2C2] border-b border-white/10">
      <tr><th class="py-2 px-2">#</th><th>Nama</th><th>Username</th><th>Tag</th><th>Aksi</th></tr>
    </thead>
    <tbody>
      <?php
      $no=1;
      $q=$conn->query("SELECT * FROM users ORDER BY id ASC");
      while($r=$q->fetch_assoc()){ ?>
      <tr class="border-b border-white/5 hover:bg-white/5">
        <td class="py-2 px-2"><?=$no++?></td>
        <td><?=$r['nama']?></td>
        <td><?=$r['username']?></td>
        <td><?=$r['tag']?></td>
        <td>
          <a href="akses.php?id=<?=$r['id']?>" class="text-[#5B8CFF] hover:underline">Akses</a> |
          <a href="edit.php?id=<?=$r['id']?>" class="text-yellow-400 hover:underline">Edit</a> |
          <a href="hapus.php?id=<?=$r['id']?>" class="text-red-400 hover:underline" onclick="return confirm('Hapus akun ini?')">Hapus</a>
        </td>
      </tr>
      <?php } ?>
    </tbody>
  </table>
</div>

<?php
$content = ob_get_clean();
require __DIR__.'/../../inc/layout.php';
?>
