<?php
require __DIR__ . '/../../inc/db.php';
require __DIR__ . '/../../vendor/autoload.php';

use PhpOffice\PhpSpreadsheet\Spreadsheet;
use PhpOffice\PhpSpreadsheet\Writer\Xlsx;
use Dompdf\Dompdf;

$type = $_GET['type'] ?? 'excel';
$format = $_GET['format'] ?? 'A4';

// Query data jadwal
$data = $conn->query("
  SELECT j.hari, t.name AS tingkat, g.name AS jurusan, c.name AS kelas,
         m.nama_mapel AS mapel, j.jam_mulai, j.jam_selesai, j.guru_pengampu, j.ruang
  FROM jadwal_pelajaran j
  LEFT JOIN classes c ON j.kelas_id=c.id
  LEFT JOIN class_groups g ON c.group_id=g.id
  LEFT JOIN class_tiers t ON c.tier_id=t.id
  LEFT JOIN mapel m ON j.mapel_id=m.id
  ORDER BY FIELD(j.hari,'Senin','Selasa','Rabu','Kamis','Jumat','Sabtu'), j.jam_mulai
");

if ($type === 'excel') {
  $sheet = new Spreadsheet();
  $s = $sheet->getActiveSheet();
  $s->setTitle('Jadwal Pelajaran');

  $headers = ['Hari','Tingkat','Jurusan','Kelas','Mata Pelajaran','Jam Mulai','Jam Selesai','Guru','Ruang'];
  $col = 'A';
  foreach ($headers as $h) $s->setCellValue($col++.'1', $h);

  $row = 2;
  while ($r = $data->fetch_assoc()) {
    $col = 'A';
    foreach ($r as $val) $s->setCellValue($col++.$row, $val);
    $row++;
  }

  $writer = new Xlsx($sheet);
  header('Content-Type: application/vnd.openxmlformats-officedocument.spreadsheetml.sheet');
  header('Content-Disposition: attachment; filename="jadwal_pelajaran.xlsx"');
  $writer->save('php://output');
  exit;
}

// PDF
$html = '<h3 style="text-align:center;margin-bottom:10px;">Jadwal Pelajaran</h3>';
$html .= '<table width="100%" border="1" cellspacing="0" cellpadding="6" style="border-collapse:collapse;font-size:12px;">
<tr style="background:#e0f4ff;text-align:center;font-weight:bold;">
<td>Hari</td><td>Tingkat</td><td>Jurusan</td><td>Kelas</td><td>Mapel</td>
<td>Jam Mulai</td><td>Jam Selesai</td><td>Guru</td><td>Ruang</td></tr>';
while ($r = $data->fetch_assoc()) {
  $html .= '<tr>';
  foreach ($r as $v) $html .= '<td>'.htmlspecialchars($v).'</td>';
  $html .= '</tr>';
}
$html .= '</table>';

$dompdf = new Dompdf();
$dompdf->setPaper($format, 'landscape');
$dompdf->loadHtml($html);
$dompdf->render();
$dompdf->stream("jadwal_pelajaran.pdf", ["Attachment"=>true]);
exit;
