<?php
require __DIR__ . '/../../inc/auth.php';
require __DIR__ . '/../../inc/db.php';

$title = "Manajemen Jadwal Pelajaran";
$title_icon = "fa-solid fa-calendar-days";
ob_start();

// === Ambil data dropdown ===
$mapel = $conn->query("SELECT id, nama_mapel FROM mapel WHERE status='Aktif' ORDER BY nama_mapel ASC");

// === API HANDLER (AJAX) ===
if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['action'])) {
  header('Content-Type: application/json');

  switch ($_POST['action']) {
    case 'add':
      $kelas_id = $_POST['kelas_id'] ?? '';
      $mapel_id = $_POST['mapel_id'] ?? '';
      $guru_pengampu = trim($_POST['guru_pengampu'] ?? '');
      $hari = $_POST['hari'] ?? '';
      $jam_mulai = $_POST['jam_mulai'] ?? '';
      $jam_selesai = $_POST['jam_selesai'] ?? '';
      $ruang = trim($_POST['ruang'] ?? '');
      $status = $_POST['status'] ?? 'Aktif';

      if ($kelas_id && $mapel_id && $hari && $jam_mulai && $jam_selesai) {
        $stmt = $conn->prepare("INSERT INTO jadwal_pelajaran (kelas_id, mapel_id, guru_pengampu, hari, jam_mulai, jam_selesai, ruang, status)
                                VALUES (?, ?, ?, ?, ?, ?, ?, ?)");
        $stmt->bind_param("iissssss", $kelas_id, $mapel_id, $guru_pengampu, $hari, $jam_mulai, $jam_selesai, $ruang, $status);
        $stmt->execute();
        echo json_encode(["success" => true, "message" => "✅ Jadwal pelajaran berhasil ditambahkan."]);
      } else {
        echo json_encode(["success" => false, "message" => "⚠️ Harap isi semua kolom wajib."]);
      }
      exit;

    case 'edit':
      $id = (int)$_POST['id'];
      $kelas_id = $_POST['kelas_id'] ?? '';
      $mapel_id = $_POST['mapel_id'] ?? '';
      $guru_pengampu = trim($_POST['guru_pengampu'] ?? '');
      $hari = $_POST['hari'] ?? '';
      $jam_mulai = $_POST['jam_mulai'] ?? '';
      $jam_selesai = $_POST['jam_selesai'] ?? '';
      $ruang = trim($_POST['ruang'] ?? '');
      $status = $_POST['status'] ?? 'Aktif';

      $stmt = $conn->prepare("UPDATE jadwal_pelajaran 
                              SET kelas_id=?, mapel_id=?, guru_pengampu=?, hari=?, jam_mulai=?, jam_selesai=?, ruang=?, status=? 
                              WHERE id=?");
      $stmt->bind_param("iissssssi", $kelas_id, $mapel_id, $guru_pengampu, $hari, $jam_mulai, $jam_selesai, $ruang, $status, $id);
      $stmt->execute();
      echo json_encode(["success" => true, "message" => "✏️ Jadwal berhasil diperbarui."]);
      exit;

    case 'delete':
      $id = (int)$_POST['id'];
      $stmt = $conn->prepare("DELETE FROM jadwal_pelajaran WHERE id=?");
      $stmt->bind_param("i", $id);
      $stmt->execute();
      echo json_encode(["success" => true, "message" => "🗑️ Jadwal berhasil dihapus."]);
      exit;

    case 'get_table':
      ob_start();
      $filterHari = $_POST['hari'] ?? '';
      $filterGuru = $_POST['guru'] ?? '';
      $filterKelas = $_POST['kelas'] ?? '';

      $where = [];
      if ($filterHari) $where[] = "j.hari='$filterHari'";
      if ($filterGuru) $where[] = "j.guru_pengampu='$filterGuru'";
      if ($filterKelas) $where[] = "j.kelas_id='$filterKelas'";
      $whereSQL = $where ? 'WHERE ' . implode(' AND ', $where) : '';

      $result = $conn->query("
        SELECT 
          j.id, j.kelas_id, j.mapel_id, j.guru_pengampu, j.hari, j.jam_mulai, j.jam_selesai, j.ruang, j.status,
          c.name AS nama_kelas, c.group_id, c.tier_id,
          g.name AS nama_group,
          t.name AS nama_tier,
          m.nama_mapel
        FROM jadwal_pelajaran j
        LEFT JOIN classes c ON j.kelas_id = c.id
        LEFT JOIN class_groups g ON c.group_id = g.id
        LEFT JOIN class_tiers t ON c.tier_id = t.id
        LEFT JOIN mapel m ON j.mapel_id = m.id
        $whereSQL
        ORDER BY FIELD(j.hari,'Senin','Selasa','Rabu','Kamis','Jumat','Sabtu'), j.jam_mulai
      ");
      include __DIR__ . '/jadwal_table.php';
      echo json_encode(["html" => ob_get_clean()]);
      exit;
  }
}
?>

<div class="main-content p-6">
  <!-- HEADER -->
  <div class="flex justify-between items-center mb-6">
    <div class="flex gap-3">
      <button id="btnTambahJadwal"
        class="bg-gradient-to-r from-[#79d8ff] to-[#8CE0FF] text-[#0b1223] px-5 py-2.5 rounded-lg text-sm font-semibold hover:from-[#9BEAFF] hover:to-[#c3f2ff] shadow-[0_0_10px_rgba(140,224,255,0.4)] flex items-center gap-2">
        <i class="fa-solid fa-plus"></i> Tambah Jadwal
      </button>

      <div class="relative">
        <button id="btnExportToggle"
          class="bg-[#0E1525] hover:bg-[#1E2B44] text-[#8CE0FF] border border-[#2A3550] px-4 py-2 rounded-lg font-semibold transition-all flex items-center gap-2">
          <i class="fa-solid fa-file-export"></i> Export
          <i class="fa-solid fa-caret-down"></i>
        </button>
        <div id="exportDropdown"
          class="hidden absolute right-0 mt-2 bg-[#0E1525] border border-[#2A3550] rounded-lg shadow-lg overflow-hidden z-50 w-40">
          <button class="block w-full text-left px-4 py-2 text-sm text-gray-200 hover:bg-[#1E2B44]" onclick="exportFile('excel')">📊 Excel</button>
          <button class="block w-full text-left px-4 py-2 text-sm text-gray-200 hover:bg-[#1E2B44]" onclick="exportFile('pdfA4')">📄 PDF A4</button>
          <button class="block w-full text-left px-4 py-2 text-sm text-gray-200 hover:bg-[#1E2B44]" onclick="exportFile('pdfA3')">🖨️ PDF A3</button>
        </div>
      </div>
    </div>
  </div>

  <!-- FILTER -->
  <div class="flex flex-wrap gap-3 mb-5">
    <select id="filterHari" class="input-field !w-auto">
      <option value="">Semua Hari</option>
      <option>Senin</option><option>Selasa</option><option>Rabu</option>
      <option>Kamis</option><option>Jumat</option><option>Sabtu</option>
    </select>

    <select id="filterGuru" class="input-field !w-auto">
      <option value="">Semua Guru</option>
      <?php
      $guru = $conn->query("SELECT DISTINCT guru_pengampu FROM jadwal_pelajaran WHERE guru_pengampu != '' ORDER BY guru_pengampu ASC");
      while ($g = $guru->fetch_assoc()) echo "<option value='{$g['guru_pengampu']}'>{$g['guru_pengampu']}</option>";
      ?>
    </select>

    <select id="filterKelas" class="input-field !w-auto">
      <option value="">Semua Kelas</option>
      <?php
      $kelas = $conn->query("SELECT id, name FROM classes ORDER BY name");
      while ($k = $kelas->fetch_assoc()) echo "<option value='{$k['id']}'>{$k['name']}</option>";
      ?>
    </select>
    <button id="btnResetFilter"
  class="bg-[#0E1525] hover:bg-[#1E2B44] text-[#8CE0FF] border border-[#2A3550] px-4 py-2 rounded-lg font-semibold transition-all flex items-center gap-2">
  <i class="fa-solid fa-filter-circle-xmark"></i> Reset Filter
</button>

  </div>
  

  <!-- TABEL -->
  <div id="jadwalList" class="bg-[#0E1525]/50 border border-[#1d2845] rounded-2xl p-6 shadow-[0_0_15px_rgba(140,224,255,0.1)]">
    <?php
    $result = $conn->query("
      SELECT 
        j.id, j.kelas_id, j.mapel_id, j.guru_pengampu, j.hari, j.jam_mulai, j.jam_selesai, j.ruang, j.status,
        c.name AS nama_kelas, c.group_id, c.tier_id,
        g.name AS nama_group,
        t.name AS nama_tier,
        m.nama_mapel
      FROM jadwal_pelajaran j
      LEFT JOIN classes c ON j.kelas_id = c.id
      LEFT JOIN class_groups g ON c.group_id = g.id
      LEFT JOIN class_tiers t ON c.tier_id = t.id
      LEFT JOIN mapel m ON j.mapel_id = m.id
      ORDER BY FIELD(j.hari,'Senin','Selasa','Rabu','Kamis','Jumat','Sabtu'), j.jam_mulai
    ");
    include __DIR__ . '/jadwal_table.php';
    ?>
  </div>
</div>

<!-- MODAL TAMBAH / EDIT -->
<div id="modalJadwal" class="hidden fixed inset-0 bg-black/60 backdrop-blur-sm flex items-center justify-center z-[9999]">
  <div class="bg-[#0b1223] border border-[#1d2845] rounded-2xl shadow-[0_0_30px_rgba(140,224,255,0.2)] w-full max-w-4xl p-8 relative">
    <button id="closeModal" class="absolute top-3 right-4 text-gray-400 hover:text-white text-xl">
      <i class="fa-solid fa-xmark"></i>
    </button>
    <h2 class="text-[#8CE0FF] font-semibold text-lg mb-6 flex items-center gap-2">
      <i class="fa-solid fa-layer-group text-[#8CE0FF]/80"></i> Tambah Jadwal Pelajaran
    </h2>
    <?php include __DIR__ . '/jadwal_form.php'; ?>
  </div>
</div>

<div id="overlayLoader" class="hidden fixed inset-0 bg-black/40 backdrop-blur-sm flex items-center justify-center z-[99999]">
  <div class="flex flex-col items-center text-[#8CE0FF]">
    <i class="fa-solid fa-spinner fa-spin text-3xl mb-3"></i>
    <span class="font-semibold text-sm tracking-wide">Memproses data...</span>
  </div>
</div>


<!-- TOAST -->
<div id="toast" class="fixed top-8 left-1/2 -translate-x-1/2 hidden z-[9999] px-6 py-3 rounded-lg text-sm font-semibold text-white shadow-lg backdrop-blur-md opacity-0 transition-all duration-500"></div>

<script>
let isEditing = false;

// ======= TOAST =======
function showToast(msg, type = 'info') {
  const t = document.getElementById('toast');
  const color = {
    success: 'bg-emerald-600/90 border border-emerald-400',
    error: 'bg-red-600/90 border border-red-400',
    warning: 'bg-yellow-600/90 border border-yellow-400',
    info: 'bg-sky-600/90 border border-sky-400'
  };
  t.className = `fixed top-8 left-1/2 -translate-x-1/2 z-[9999] px-6 py-3 rounded-lg text-sm font-semibold text-white shadow-lg ${color[type]}`;
  t.innerText = msg;
  t.classList.remove('hidden');
  setTimeout(() => t.style.opacity = '1', 100);
  setTimeout(() => { t.style.opacity = '0'; setTimeout(() => t.classList.add('hidden'), 500) }, 2500);
}

// ======= REFRESH TABLE =======
async function refreshTable() {
  const fd = new FormData();
  fd.append('action', 'get_table');
  const res = await fetch('', { method: 'POST', body: fd });
  const data = await res.json();
  document.getElementById('jadwalList').innerHTML = data.html;
}

// ======= SUBMIT FORM =======
document.getElementById('formJadwal').addEventListener('submit', async e => {
  e.preventDefault();
  const fd = new FormData(e.target);
  fd.append('action', isEditing ? 'edit' : 'add');
  const res = await fetch('', { method: 'POST', body: fd });
  const data = await res.json();
  showToast(data.message, data.success ? 'success' : 'warning');
  if (data.success) {
    refreshTable();
    e.target.reset();
    document.getElementById('btnSubmit').innerHTML = '<i class="fa-solid fa-save mr-2"></i> Simpan Jadwal';
    document.getElementById('btnCancelEdit').classList.add('hidden');
    isEditing = false;
  }
});

// Modal control
const modal = document.getElementById('modalJadwal');
document.getElementById('btnTambahJadwal').addEventListener('click', () => modal.classList.remove('hidden'));
document.getElementById('closeModal').addEventListener('click', () => modal.classList.add('hidden'));
window.addEventListener('click', e => { if (e.target === modal) modal.classList.add('hidden'); });

// Export dropdown
const btnExportToggle = document.getElementById('btnExportToggle');
const exportDropdown = document.getElementById('exportDropdown');
btnExportToggle.addEventListener('click', () => exportDropdown.classList.toggle('hidden'));
window.addEventListener('click', e => { if (!btnExportToggle.contains(e.target)) exportDropdown.classList.add('hidden'); });

// ======= EXPORT TANPA RELOAD =======
async function exportFile(type) {
  const btn = document.getElementById('btnExportToggle');
  btn.disabled = true;
  btn.innerHTML = '<i class="fa-solid fa-spinner fa-spin"></i> Exporting...';
  try {
    const format = type.includes('pdf') ? type.replace('pdf','').toUpperCase() : '';
    const url = `/system-absent/modules/jadwal_pelajaran/export_jadwal.php?type=${type.includes('excel') ? 'excel' : 'pdf'}&format=${format || 'A4'}`;
    const res = await fetch(url);
    const blob = await res.blob();
    const a = document.createElement('a');
    a.href = URL.createObjectURL(blob);
    a.download = type.includes('excel') ? 'jadwal_pelajaran.xlsx' : `jadwal_pelajaran_${format || 'A4'}.pdf`;
    a.click();
    showToast('✅ File berhasil diekspor!', 'success');
  } catch {
    showToast('❌ Gagal export file.', 'error');
  } finally {
    btn.disabled = false;
    btn.innerHTML = '<i class="fa-solid fa-file-export"></i> Export <i class="fa-solid fa-caret-down"></i>';
  }
}



// ======= MODE EDIT =======
async function editJadwal(row) {
  const modal = document.getElementById('modalJadwal');
  const tierSelect = document.getElementById('tier_id');
  const groupSelect = document.getElementById('group_id');
  const classSelect = document.getElementById('kelas_id');

  // Isi field dasar
  document.getElementById('editId').value = row.id;
  document.getElementById('mapel_id').value = row.mapel_id;
  document.getElementById('hari').value = row.hari;
  document.getElementById('jam_mulai').value = row.jam_mulai;
  document.getElementById('jam_selesai').value = row.jam_selesai;
  document.getElementById('guru_pengampu').value = row.guru_pengampu;
  document.getElementById('ruang').value = row.ruang;

  // ====== LOAD DROPDOWN SECARA DINAMIS ======
  // Set tingkat
  tierSelect.value = row.tier_id;

  // Load jurusan berdasarkan tier
  const resGroup = await fetch(`/system-absent/inc/ajax_get_groups.php?tier_id=${row.tier_id}`);
  const groups = await resGroup.json();
  groupSelect.innerHTML = '<option value="">-- Pilih Jurusan --</option>';
  groups.forEach(g => {
    const opt = document.createElement('option');
    opt.value = g.id;
    opt.textContent = g.name;
    groupSelect.appendChild(opt);
  });
  groupSelect.value = row.group_id;

  // Load kelas berdasarkan jurusan
  const resClass = await fetch(`/system-absent/inc/ajax_get_classes.php?group_id=${row.group_id}`);
  const classes = await resClass.json();
  classSelect.innerHTML = '<option value="">-- Pilih Kelas --</option>';
  classes.forEach(c => {
    const opt = document.createElement('option');
    opt.value = c.id;
    opt.textContent = c.name;
    classSelect.appendChild(opt);
  });
  classSelect.value = row.kelas_id;

  // ====== UBAH TAMPILAN MODAL KE MODE EDIT ======
  modal.classList.remove('hidden');
  document.querySelector('#modalJadwal h2').innerHTML =
    '<i class="fa-solid fa-pen-to-square text-[#8CE0FF]/80"></i> Edit Jadwal Pelajaran';
  
  isEditing = true;
  document.getElementById('btnSubmit').innerText = 'Perbarui Jadwal';
  document.getElementById('btnCancelEdit').classList.remove('hidden');
  showToast('Mode edit aktif', 'info');
}

// ======= BATAL EDIT =======
document.getElementById('btnCancelEdit').addEventListener('click', () => {
  const form = document.getElementById('formJadwal');
  form.reset();
  isEditing = false;
  document.getElementById('btnSubmit').innerHTML = '<i class="fa-solid fa-save mr-2"></i> Simpan Jadwal';
  document.getElementById('btnCancelEdit').classList.add('hidden');
  document.getElementById('modalJadwal').classList.add('hidden'); // 🔹 tutup modal
});


// ======= DELETE CONFIRM INLINE =======
async function deleteJadwal(id, button) {
  // Hapus konfirmasi lain jika ada
  document.querySelectorAll('.confirm-box').forEach(el => el.remove());

  // Buat popup konfirmasi mini
  const confirmBox = document.createElement('div');
  confirmBox.className = 'confirm-box absolute bg-[#0e1525] border border-[#2a3550] rounded-lg p-3 text-sm text-gray-200 shadow-lg';
  confirmBox.innerHTML = `
    <p class="mb-2 text-gray-300">Yakin hapus jadwal ini?</p>
    <div class="flex justify-end gap-2">
      <button class="px-3 py-1 text-gray-300 border border-[#2a3550] rounded hover:bg-[#1e2b44]" id="cancelDel">Batal</button>
      <button class="px-3 py-1 bg-red-600 text-white rounded hover:bg-red-700" id="confirmDel">Hapus</button>
    </div>
  `;

  // Posisi popup tepat di bawah tombol hapus
  const rect = button.getBoundingClientRect();
  confirmBox.style.top = `${rect.bottom + window.scrollY + 6}px`;
  confirmBox.style.left = `${rect.left - 100}px`;
  confirmBox.style.zIndex = '99999';
  document.body.appendChild(confirmBox);

  // Klik batal
  confirmBox.querySelector('#cancelDel').addEventListener('click', () => confirmBox.remove());

  // Klik hapus
  confirmBox.querySelector('#confirmDel').addEventListener('click', async () => {
    const fd = new FormData();
    fd.append('action', 'delete');
    fd.append('id', id);
    const res = await fetch('', { method: 'POST', body: fd });
    const data = await res.json();
    confirmBox.remove();
    showToast(data.message, data.success ? 'success' : 'error');
    if (data.success) refreshTable();
  });
}

// ======= AUTO GURU =======
document.getElementById('mapel_id').addEventListener('change', async e => {
  const mapelId = e.target.value;
  const guruInput = document.getElementById('guru_pengampu');
  guruInput.value = '';
  if (!mapelId) return;

  const res = await fetch(`/system-absent/inc/ajax_get_guru_mapel.php?mapel_id=${mapelId}`);
  const data = await res.json();
  if (data && data.guru_pengampu) guruInput.value = data.guru_pengampu;
});

// ====== FILTER ======
async function applyFilters() {
  const fd = new FormData();
  fd.append('action', 'get_table');
  fd.append('hari', document.getElementById('filterHari').value);
  fd.append('guru', document.getElementById('filterGuru').value);
  fd.append('kelas', document.getElementById('filterKelas').value);

  const res = await fetch('', { method: 'POST', body: fd });
  const data = await res.json();
  document.getElementById('jadwalList').innerHTML = data.html;
}

// Panggil filter saat dropdown berubah
['filterHari', 'filterGuru', 'filterKelas'].forEach(id => {
  document.getElementById(id).addEventListener('change', applyFilters);
});

// Tombol refresh manual
document.getElementById('btnRefresh').addEventListener('click', applyFilters);

// ======= DROPDOWN BERTINGKAT (Tingkat → Jurusan → Kelas) =======
document.getElementById('tier_id').addEventListener('change', async e => {
  const tierId = e.target.value;
  const groupSelect = document.getElementById('group_id');
  const classSelect = document.getElementById('kelas_id');
  groupSelect.innerHTML = '<option value="">-- Pilih Jurusan --</option>';
  classSelect.innerHTML = '<option value="">-- Pilih Kelas --</option>';
  if (!tierId) return;

  const res = await fetch(`/system-absent/inc/ajax_get_groups.php?tier_id=${tierId}`);
  const groups = await res.json();
  groups.forEach(g => {
    const opt = document.createElement('option');
    opt.value = g.id;
    opt.textContent = g.name;
    groupSelect.appendChild(opt);
  });
});

document.getElementById('group_id').addEventListener('change', async e => {
  const groupId = e.target.value;
  const classSelect = document.getElementById('kelas_id');
  classSelect.innerHTML = '<option value="">-- Pilih Kelas --</option>';
  if (!groupId) return;

  const res = await fetch(`/system-absent/inc/ajax_get_classes.php?group_id=${groupId}`);
  const classes = await res.json();
  classes.forEach(c => {
    const opt = document.createElement('option');
    opt.value = c.id;
    opt.textContent = c.name;
    classSelect.appendChild(opt);
  });
});
    
// ======= RESET FILTER =======
document.getElementById('btnResetFilter').addEventListener('click', () => {
  ['filterHari','filterGuru','filterKelas'].forEach(id => document.getElementById(id).value = '');
  applyFilters();
  showToast('Filter berhasil direset', 'info');
});

</script>


<style>
.confirm-box {
  animation: fadeIn 0.2s ease;
}
@keyframes fadeIn {
  from { opacity: 0; transform: translateY(-5px); }
  to { opacity: 1; transform: translateY(0); }
}
.input-field {
  width: 100%; background: #0E1525;
  border: 1px solid #2A3550; border-radius: 0.5rem;
  padding: 0.5rem 0.75rem; color: #E6EEF9;
  transition: all 0.25s ease;
}
.input-field:focus {
  border-color: #8CE0FF; box-shadow: 0 0 0 3px rgba(140,224,255,0.25); outline: none;
}
.input-field:hover { border-color: rgba(140,224,255,0.4); }
/* ======== FIX MODAL SELALU DI TENGAH & BISA SCROLL ======== */
/* ===== FIX MODAL CENTER DAN RAPIH ===== */
/* ===== FIX MODAL SELALU DI TENGAH, TIDAK IKUT SCROLL ===== */
#modalJadwal {
  position: fixed;
  inset: 0;
  display: flex;
  align-items: center;
  justify-content: center;
  background: rgba(0, 0, 0, 0.6);
  backdrop-filter: blur(4px);
  z-index: 9999;
  animation: fadeIn 0.25s ease forwards;
  overflow: hidden; /* biar modal tetap diam, halaman belakang gak scroll */
}

/* kotak modal */
#modalJadwal > div {
  background: #0b1223;
  border: 1px solid #1d2845;
  border-radius: 1rem;
  box-shadow: 0 0 25px rgba(140, 224, 255, 0.2);
  width: 100%;
  max-width: 900px; /* ukuran ideal modal */
  max-height: 90vh; /* biar gak lebih tinggi dari layar */
  overflow-y: auto; /* konten di dalam modal bisa di-scroll */
  padding: 2rem;
  animation: scaleIn 0.25s ease forwards;
}

/* scrollbar halus di dalam modal */
#modalJadwal > div::-webkit-scrollbar {
  width: 6px;
}
#modalJadwal > div::-webkit-scrollbar-thumb {
  background: rgba(140,224,255,0.4);
  border-radius: 3px;
}
#modalJadwal > div::-webkit-scrollbar-thumb:hover {
  background: rgba(140,224,255,0.7);
}

/* saat modal ditutup */
#modalJadwal.hidden {
  display: none !important;
}

/* animasi */
@keyframes fadeIn {
  from {opacity:0; backdrop-filter:blur(0px);}
  to {opacity:1; backdrop-filter:blur(4px);}
}
@keyframes scaleIn {
  from {opacity:0; transform:scale(0.9);}
  to {opacity:1; transform:scale(1);}
}


</style>


<?php
$content = ob_get_clean();
include __DIR__ . '/../../inc/layout.php';
?>
