<form id="formJadwal" class="space-y-6">
  <input type="hidden" name="id" id="editId">

  <div class="grid md:grid-cols-2 gap-6">
    <div class="space-y-4">
      <div>
        <label class="text-sm text-gray-300 mb-1 block">Tingkat</label>
        <select id="tier_id" class="input-field">
          <option value="">-- Pilih Tingkat --</option>
          <?php
          $tiers = $conn->query("SELECT id, name FROM class_tiers ORDER BY name");
          while ($t = $tiers->fetch_assoc()) echo "<option value='{$t['id']}'>{$t['name']}</option>";
          ?>
        </select>
      </div>

      <div>
        <label class="text-sm text-gray-300 mb-1 block">Jurusan</label>
        <select id="group_id" class="input-field">
          <option value="">-- Pilih Jurusan --</option>
        </select>
      </div>

      <div>
        <label class="text-sm text-gray-300 mb-1 block">Kelas</label>
        <select name="kelas_id" id="kelas_id" required class="input-field">
          <option value="">-- Pilih Kelas --</option>
        </select>
      </div>

      <div>
        <label class="text-sm text-gray-300 mb-1 block">Hari</label>
        <select name="hari" id="hari" required class="input-field">
          <option value="">-- Pilih Hari --</option>
          <option>Senin</option><option>Selasa</option><option>Rabu</option>
          <option>Kamis</option><option>Jumat</option><option>Sabtu</option>
        </select>
      </div>
    </div>

    <div class="space-y-4">
      <div>
        <label class="text-sm text-gray-300 mb-1 block">Mata Pelajaran</label>
        <select name="mapel_id" id="mapel_id" required class="input-field">
          <option value="">-- Pilih Mapel --</option>
          <?php while ($m = $mapel->fetch_assoc()): ?>
            <option value="<?= $m['id'] ?>"><?= htmlspecialchars($m['nama_mapel']) ?></option>
          <?php endwhile; ?>
        </select>
      </div>

      <div class="grid grid-cols-2 gap-3">
        <div>
          <label class="text-sm text-gray-300 mb-1 block">Jam Mulai</label>
          <input type="time" name="jam_mulai" id="jam_mulai" required class="input-field">
        </div>
        <div>
          <label class="text-sm text-gray-300 mb-1 block">Jam Selesai</label>
          <input type="time" name="jam_selesai" id="jam_selesai" required class="input-field">
        </div>
      </div>

      <div>
        <label class="text-sm text-gray-300 mb-1 block">Guru Pengampu</label>
        <input type="text" name="guru_pengampu" id="guru_pengampu" class="input-field">
      </div>

      <div>
        <label class="text-sm text-gray-300 mb-1 block">Ruang</label>
        <input type="text" name="ruang" id="ruang" class="input-field">
      </div>
    </div>
  </div>

  <div class="flex justify-end gap-3 pt-4 border-t border-[#1d2845] mt-6">
    <button type="button" id="btnCancelEdit"
      class="hidden px-6 py-2.5 rounded-lg text-sm text-gray-300 border border-[#2A3550] hover:bg-[#1E2B44] transition-all duration-300">
      Batal
    </button>
    <button type="submit" id="btnSubmit"
      class="bg-gradient-to-r from-[#79d8ff] to-[#8CE0FF] text-[#0b1223] px-6 py-2.5 rounded-lg text-sm font-semibold tracking-wide hover:from-[#9BEAFF] hover:to-[#c3f2ff] transition-all duration-300 shadow-[0_0_10px_rgba(140,224,255,0.4)]">
      <i class="fa-solid fa-save mr-2"></i> Simpan Jadwal
    </button>
  </div>
</form>
