<?php
if (!isset($result)) {
  require __DIR__ . '/../../inc/db.php';
  $result = $conn->query("
    SELECT 
      j.*, 
      c.name AS nama_kelas, 
      g.name AS nama_group, 
      t.name AS nama_tier, 
      m.nama_mapel
    FROM jadwal_pelajaran j
    LEFT JOIN classes c ON j.kelas_id = c.id
    LEFT JOIN class_groups g ON c.group_id = g.id
    LEFT JOIN class_tiers t ON c.tier_id = t.id
    LEFT JOIN mapel m ON j.mapel_id = m.id
    ORDER BY FIELD(j.hari,'Senin','Selasa','Rabu','Kamis','Jumat','Sabtu'), j.jam_mulai
  ");
}
?>

<table class="w-full text-sm border border-[#1E2B44] rounded-2xl overflow-hidden shadow-[0_0_15px_rgba(140,224,255,0.1)]">
  <thead class="bg-gradient-to-r from-[#0F1A2F] to-[#14253D] text-[#8CE0FF] uppercase text-[12px] tracking-wider border-b border-[#1E2B44]">
    <tr class="text-center">
      <th class="py-3 px-4 w-[10%]">Tingkat</th>
      <th class="py-3 px-4 w-[12%]">Jurusan</th>
      <th class="py-3 px-4 w-[10%]">Kelas</th>
      <th class="py-3 px-4 w-[14%]">Mata Pelajaran</th>
      <th class="py-3 px-4 w-[10%]">Hari</th>
      <th class="py-3 px-4 w-[16%]">Jam</th>
      <th class="py-3 px-4 w-[12%]">Guru</th>
      <th class="py-3 px-4 w-[10%]">Ruang</th>
      <th class="py-3 px-4 w-[6%]">Aksi</th>
    </tr>
  </thead>
  <tbody class="text-gray-200 text-center">
    <?php if ($result && $result->num_rows > 0): ?>
      <?php while ($r = $result->fetch_assoc()): ?>
        <tr class="border-t border-[#1E2B44]/60 hover:bg-[#1A2944]/50 transition-all duration-200">
          <td class="py-3 px-4"><?= htmlspecialchars($r['nama_tier'] ?? '-') ?></td>
          <td class="py-3 px-4"><?= htmlspecialchars($r['nama_group'] ?? '-') ?></td>
          <td class="py-3 px-4"><?= htmlspecialchars($r['nama_kelas'] ?? '-') ?></td>
          <td class="py-3 px-4"><?= htmlspecialchars($r['nama_mapel'] ?? '-') ?></td>
          <td class="py-3 px-4"><?= htmlspecialchars($r['hari'] ?? '-') ?></td>
          <td class="py-3 px-4"><?= substr($r['jam_mulai'] ?? '-', 0, 5) ?> - <?= substr($r['jam_selesai'] ?? '-', 0, 5) ?></td>
          <td class="py-3 px-4"><?= htmlspecialchars($r['guru_pengampu'] ?? '-') ?></td>
          <td class="py-3 px-4"><?= htmlspecialchars($r['ruang'] ?? '-') ?></td>
          <td class="py-3 px-4 text-center">
            <div class="flex items-center justify-center gap-2">
              <button onclick='editJadwal(<?= json_encode($r) ?>)' 
                      class="text-[#8CE0FF] hover:text-[#A8EFFF] transition-all">
                <i class="fa-solid fa-pen"></i>
              </button>
            <button onclick="deleteJadwal(<?= $r['id'] ?>, this)" 
        class="text-red-400 hover:text-red-500 transition-all">
  <i class="fa-solid fa-trash"></i>
</button>


            </div>
          </td>
        </tr>
      <?php endwhile; ?>
    <?php else: ?>
      <tr>
        <td colspan="9" class="py-6 text-center text-gray-400 italic">Belum ada jadwal ditambahkan.</td>
      </tr>
    <?php endif; ?>
  </tbody>
</table>
