<?php
require __DIR__.'/../../inc/auth.php';
require __DIR__.'/../../inc/db.php';
header('Content-Type: application/json');

try {
  $q = $conn->query("
    SELECT l.id, u.username AS user, l.action,
           DATE_FORMAT(l.created_at, '%d %M %Y %H:%i') AS time
    FROM logs l
    LEFT JOIN users u ON l.user_id = u.id
    WHERE l.module = 'kelas'
    ORDER BY l.created_at DESC
    LIMIT 30
  ");

  $logs = [];
  while($r = $q->fetch_assoc()) $logs[] = $r;

  echo json_encode(['success' => true, 'logs' => $logs]);

} catch (Exception $e) {
  echo json_encode(['success' => false, 'error' => $e->getMessage()]);
}
?>
