<?php
require __DIR__.'/../../inc/auth.php';
require __DIR__.'/../../inc/db.php';
if(!canAccess('kelas','view')) { echo "<script>alert('Akses ditolak!');history.back();</script>"; exit; }

$title = "Data Kelas";
ob_start();

// Ambil data kelas
$q = "
SELECT c.id, c.name AS class_name, c.capacity, c.homeroom_teacher,
       t.name AS tier_name, g.name AS group_name
FROM classes c
LEFT JOIN class_tiers t ON c.tier_id = t.id
LEFT JOIN class_groups g ON c.group_id = g.id
ORDER BY t.name, g.name, c.name
";
$data = $conn->query($q);
?>

<style>
/* === PERBAIKAN POSISI MODAL EDIT (AGAR TENGAH) === */
#editModal {
  display: none;
  position: fixed;
  inset: 0;
  z-index: 50;
  background: rgba(0, 0, 0, 0.6);
  justify-content: center;
  align-items: center;
  backdrop-filter: blur(4px);
}
#editModal.flex {
  display: flex !important;
}
#editModal > div {
  background: #141D2F;
  border: 1px solid rgba(255,255,255,0.1);
  border-radius: 1rem;
  padding: 1.5rem;
  width: 90%;
  max-width: 400px;
  box-shadow: 0 10px 40px rgba(0,0,0,0.5);
  animation: popupFade 0.25s ease;
}
@keyframes popupFade {
  from {opacity: 0; transform: translateY(-20px) scale(0.95);}
  to {opacity: 1; transform: translateY(0) scale(1);}
}
@media (max-width: 768px) {
  #editModal > div {
    width: 95%;
    padding: 1.2rem;
  }
}

/* === MOBILE LAYOUT KHUSUS HALAMAN DATA KELAS === */
@media (max-width: 768px) {
  .kelas-card-root {
    padding: 1rem;
    border-radius: 1rem;
  }

  .kelas-header-row {
    flex-direction: column;
    align-items: flex-start;
    gap: 0.75rem;
  }

  .kelas-filter-row {
    flex-direction: column;
    align-items: stretch;
    margin-top: 0.75rem;
    gap: 0.5rem;
  }

  .kelas-filter-row select {
    width: 100%;
    font-size: 0.85rem;
  }

  .kelas-filter-row button {
    width: 100%;
    justify-content: center;
    font-size: 0.85rem;
  }

  .kelas-table-wrapper {
    margin-top: 1rem;
    overflow-x: auto;
    -webkit-overflow-scrolling: touch;
    border-radius: 0.75rem;
    border: 1px solid rgba(255,255,255,0.08);
  }

  #kelasTable {
    min-width: 700px;      /* bikin bisa swipe kanan-kiri */
    font-size: 0.8rem;
  }

  #kelasTable th,
  #kelasTable td {
    padding: 0.4rem 0.5rem;
  }
}
</style>

<div class="p-6 bg-[#141D2F] rounded-2xl border border-white/10 relative kelas-card-root">
  <div class="flex justify-between items-center mb-4 kelas-header-row">
    <h1 class="text-xl font-semibold text-[#8CE0FF]">📘 Data Kelas</h1>
    <a href="tambah.php" class="bg-[#5B8CFF] text-[#0E1525] px-4 py-2 rounded font-semibold hover:bg-[#8CE0FF] transition">+ Tambah</a>
  </div>

  <div class="flex items-center gap-2 kelas-filter-row">
    <select id="filterTier" class="p-2 rounded bg-[#0E1525] border border-white/10 text-[#B7C9E5]">
      <option value="">Semua Tingkatan</option>
    </select>
    <select id="filterGroup" class="p-2 rounded bg-[#0E1525] border border-white/10 text-[#B7C9E5]">
      <option value="">Semua Jurusan</option>
    </select>
    <button onclick="exportExcel()" 
            class="ml-2 bg-[#5B8CFF] text-[#0E1525] px-3 py-2 rounded font-semibold hover:bg-[#8CE0FF] transition">
      📤 Export Excel
    </button>
  </div>

  <!-- WRAPPER AGAR TABEL BISA DI-SCROLL DI HP -->
  <div class="kelas-table-wrapper mt-4">
    <table id="kelasTable" class="min-w-full text-sm text-[#B7C9E5]">
      <thead class="text-[#8CE0FF] border-b border-white/10">
        <tr>
          <th class="p-2 text-left">No</th>
          <th class="p-2 text-left">Tingkatan</th>
          <th class="p-2 text-left">Jurusan</th>
          <th class="p-2 text-left">Nama Kelas</th>
          <th class="p-2 text-left">Wali Kelas</th>
          <th class="p-2 text-center">Kapasitas</th>
          <th class="p-2 text-center">Aksi</th>
        </tr>
      </thead>
      <tbody>
        <?php 
        $no = 1;
        while($r = $data->fetch_assoc()): 
        ?>
        <tr class="border-b border-white/5 hover:bg-[#0E1525]/60 transition" id="row-<?=$r['id']?>">
          <td class="p-2"><?= $no++ ?></td>
          <td class="p-2"><?= htmlspecialchars($r['tier_name']) ?></td>
          <td class="p-2"><?= htmlspecialchars($r['group_name']) ?></td>
          <td class="p-2 font-semibold"><?= htmlspecialchars($r['class_name']) ?></td>
          <td class="p-2"><?= htmlspecialchars($r['homeroom_teacher']) ?></td>
          <td class="p-2 text-center"><?= htmlspecialchars($r['capacity']) ?></td>
          <td class="p-2 text-center">
            <button onclick="editKelas(<?=$r['id']?>)" class="text-[#5B8CFF] hover:underline">Edit</button> |
            <button onclick="confirmDelete('hapus_kelas.php?id=<?=$r['id']?>', <?=$r['id']?>)" class="text-red-400 hover:underline">Hapus</button> |
            <button onclick="lihatSiswa(<?=$r['id']?>, '<?= addslashes($r['class_name']) ?>')" class="text-[#8CE0FF] hover:underline">Detail</button>      
          </td>
        </tr>
        <?php endwhile; ?>
      </tbody>
    </table>
  </div>

  <div id="toastContainer" class="absolute left-1/2 -translate-x-1/2 top-[-3.5rem] flex justify-center z-40 pointer-events-none"></div>
</div>

<div class="flex justify-end mt-4">
  <button onclick="openLogModal()" class="bg-[#5B8CFF] text-[#0E1525] px-4 py-2 rounded font-semibold hover:bg-[#8CE0FF] transition">
    🕓 Cek Riwayat
  </button>
</div>  

<!-- Modal Edit -->
<div id="editModal" class="hidden">
  <div>
    <h2 class="text-xl text-[#8CE0FF] font-semibold mb-3">Edit Kelas</h2>
    <input type="hidden" id="edit_id">
    <label class="block text-[#B7C9E5] text-sm mb-1">Nama Kelas</label>
    <input type="text" id="edit_name" class="w-full p-2 rounded bg-[#0E1525] border border-white/10 mb-3">

    <label class="block text-[#B7C9E5] text-sm mb-1">Wali Kelas</label>
    <input type="text" id="edit_wali" class="w-full p-2 rounded bg-[#0E1525] border border-white/10 mb-3">

    <label class="block text-[#B7C9E5] text-sm mb-1">Kapasitas</label>
    <input type="number" id="edit_capacity" class="w-full p-2 rounded bg-[#0E1525] border border-white/10 mb-4">

    <div class="flex justify-end gap-2">
      <button onclick="closeEditModal()" class="bg-gray-600 px-3 py-1 rounded text-white">Batal</button>
      <button onclick="simpanEdit()" class="bg-[#5B8CFF] text-[#0E1525] px-3 py-1 rounded font-semibold">Simpan</button>
    </div>
  </div>
</div>

<!-- Modal Log Aktivitas -->
<div id="logModal" class="fixed inset-0 bg-black/60 hidden items-center justify-center z-50">
  <div class="bg-[#141D2F] p-6 rounded-2xl w-[600px] border border-white/10 shadow-xl">
    <div class="flex justify-between items-center mb-4">
      <h2 class="text-xl font-semibold text-[#8CE0FF]">🕓 Riwayat Aktivitas Kelas</h2>
      <button onclick="closeLogModal()" class="text-[#B7C9E5] hover:text-[#8CE0FF]">✕</button>
    </div>
    <div id="logContainer" class="max-h-[400px] overflow-y-auto text-[#B7C9E5] text-sm space-y-2">
      <p class="text-center text-[#92A2C2]">Memuat data...</p>
    </div>
  </div>
</div>

<!-- Modal Konfirmasi Hapus -->
<div id="confirmModal" class="fixed inset-0 bg-black/40 hidden items-center justify-center z-50">
  <div class="bg-[#141D2F] border border-white/10 rounded-2xl p-6 w-[320px] text-center shadow-2xl">
    <h3 class="text-lg font-semibold text-[#8CE0FF] mb-3">Konfirmasi</h3>
    <p class="text-[#B7C9E5] text-sm mb-5">Apakah Anda yakin ingin menghapus data ini?</p>
    <div class="flex justify-center gap-3">
      <button id="confirmCancel" class="px-4 py-2 bg-gray-600/70 hover:bg-gray-500/90 rounded-lg text-white text-sm">Batal</button>
      <button id="confirmOk" class="px-4 py-2 bg-[#FF5555]/90 hover:bg-[#FF7777] rounded-lg text-white text-sm font-medium">Hapus</button>
    </div>
  </div>
</div>

<!-- Modal Detail Siswa -->
<div id="modalSiswa" class="fixed inset-0 bg-black/70 hidden items-center justify-center z-50">
  <div class="bg-[#141D2F] p-6 rounded-2xl w-[600px] border border-white/10">
    <h2 id="titleSiswa" class="text-xl font-semibold text-[#8CE0FF] mb-3">Daftar Siswa</h2>
    <div id="siswaContent" class="text-[#B7C9E5] text-sm max-h-[400px] overflow-y-auto">
      <div class="text-center text-[#92A2C2] p-3">Memuat data...</div>
    </div>
    <div class="text-right mt-4">
      <button onclick="tutupSiswa()" class="bg-gray-600 px-3 py-1 rounded">Tutup</button>
    </div>
  </div>
</div>

<!-- DataTables -->
<link rel="stylesheet" href="https://cdn.datatables.net/2.0.8/css/dataTables.tailwindcss.css">
<script src="https://cdn.datatables.net/2.0.8/js/dataTables.js"></script>
<script>
// === DataTables ===
document.addEventListener('DOMContentLoaded', function() {
  new DataTable('#kelasTable', {
    searchable: true,
    perPage: 10,
    labels: {
      placeholder: "Cari data...",
      perPage: "{select} data per halaman",
      noRows: "Tidak ada data kelas.",
      info: "Menampilkan {start}–{end} dari {rows} data"
    }
  });
});

// === Load Filter Dropdown ===
fetch('get_filter_data.php')
  .then(r => r.json())
  .then(d => {
    if (d.tiers) {
      const tierSel = document.getElementById('filterTier');
      d.tiers.forEach(t => {
        const opt = document.createElement('option');
        opt.value = t.name;
        opt.textContent = t.name;
        tierSel.appendChild(opt);
      });
    }
    if (d.groups) {
      const grpSel = document.getElementById('filterGroup');
      d.groups.forEach(g => {
        const opt = document.createElement('option');
        opt.value = g.name;
        opt.textContent = g.name;
        grpSel.appendChild(opt);
      });
    }
  });

// === Filter real-time ===
document.getElementById('filterTier').addEventListener('change', filterTable);
document.getElementById('filterGroup').addEventListener('change', filterTable);

function filterTable() {
  const tier = document.getElementById('filterTier').value.toLowerCase();
  const group = document.getElementById('filterGroup').value.toLowerCase();
  document.querySelectorAll('#kelasTable tbody tr').forEach(row => {
    const t = row.cells[1].textContent.toLowerCase();
    const g = row.cells[2].textContent.toLowerCase();
    row.style.display = ((!tier || t.includes(tier)) && (!group || g.includes(group))) ? '' : 'none';
  });
}

function exportExcel() {
  const rows = [['No','Tingkatan','Jurusan','Nama Kelas','Wali Kelas','Kapasitas']];
  document.querySelectorAll('#kelasTable tbody tr').forEach((r,i)=>{
    if(r.style.display==='none') return;
    const c = [...r.cells].map(td=>td.innerText.trim());
    rows.push(c.slice(0,6));
  });
  const csv = rows.map(r=>r.join(',')).join('\n');
  const blob = new Blob([csv], {type:'text/csv;charset=utf-8;'});
  const url = URL.createObjectURL(blob);
  const a = document.createElement('a');
  a.href = url;
  a.download = 'data_kelas.csv';
  a.click();
  URL.revokeObjectURL(url);
  showToast('Data berhasil di-export ke Excel 📄','success');
}

// === Toast Notification (Top-Center Inside Content) ===
function showToast(message, type = 'info') {
  const container = document.getElementById('toastContainer');
  const toast = document.createElement('div');
  toast.className = `
    px-5 py-3 rounded-xl shadow-lg text-sm font-medium border backdrop-blur-md
    opacity-0 transform translate-y-[-10px] transition-all duration-500
    ${type === 'success' ? 'bg-[#0D2618]/90 border-[#37F297] text-[#C9FFE3]' :
     type === 'error' ? 'bg-[#2A1414]/90 border-[#FF5555] text-[#FFCACA]' :
     'bg-[#1A2337]/90 border-[#8CE0FF] text-[#B7C9E5]'}
  `;
  toast.innerHTML = `
    <div class="flex items-center gap-3">
      <span class="text-lg">
        ${type === 'success' ? '✅' : type === 'error' ? '⚠️' : 'ℹ️'}
      </span>
      <span>${message}</span>
    </div>
  `;
  container.appendChild(toast);
  requestAnimationFrame(() => {
    toast.classList.remove('opacity-0', 'translate-y-[-10px]');
    toast.classList.add('opacity-100', 'translate-y-0');
  });
  setTimeout(() => {
    toast.classList.remove('opacity-100', 'translate-y-0');
    toast.classList.add('opacity-0', 'translate-y-[-10px]');
    setTimeout(() => toast.remove(), 400);
  }, 3000);
}

// === Modal Edit ===
function editKelas(id) {
  fetch('get_kelas.php?id=' + id)
    .then(res => res.json())
    .then(d => {
      if (!d.success) return showToast('Data tidak ditemukan!', 'error');
      document.getElementById('edit_id').value = d.data.id;
      document.getElementById('edit_name').value = d.data.name;
      document.getElementById('edit_wali').value = d.data.homeroom_teacher;
      document.getElementById('edit_capacity').value = d.data.capacity;
      const modal = document.getElementById('editModal');
      modal.classList.remove('hidden');
      modal.classList.add('flex');
    });
}
function closeEditModal() {
  const modal = document.getElementById('editModal');
  modal.classList.add('hidden');
  modal.classList.remove('flex');
}

// === Simpan hasil edit ===
function simpanEdit() {
  const id = document.getElementById('edit_id').value;
  const name = document.getElementById('edit_name').value;
  const wali = document.getElementById('edit_wali').value;
  const capacity = document.getElementById('edit_capacity').value;

  fetch('update_kelas.php', {
    method: 'POST',
    headers: {'Content-Type': 'application/x-www-form-urlencoded'},
    body: `id=${id}&name=${encodeURIComponent(name)}&wali=${encodeURIComponent(wali)}&capacity=${capacity}`
  })
  .then(res => res.json())
  .then(d => {
    if (!d.success) return showToast('Gagal menyimpan: ' + d.error, 'error');
    showToast('Perubahan berhasil disimpan.', 'success');
    closeEditModal();
    setTimeout(() => location.reload(), 1200);
  });
}

// === Konfirmasi Hapus (Tanpa Reload) ===
function confirmDelete(url, id) {
  const modal = document.getElementById('confirmModal');
  const btnOk = document.getElementById('confirmOk');
  const btnCancel = document.getElementById('confirmCancel');

  modal.classList.remove('hidden');
  modal.classList.add('flex');

  btnOk.replaceWith(btnOk.cloneNode(true));
  btnCancel.replaceWith(btnCancel.cloneNode(true));

  document.getElementById('confirmCancel').onclick = () => {
    modal.classList.add('hidden');
    modal.classList.remove('flex');
  };

  document.getElementById('confirmOk').onclick = async () => {
    modal.classList.add('hidden');
    modal.classList.remove('flex');
    showToast('Menghapus data...', 'info');
    try {
      const res = await fetch(url);
      const data = await res.json();
      if (!data.success) {
        showToast('Gagal menghapus: ' + data.error, 'error');
        return;
      }
      const row = document.getElementById('row-' + id);
      if (row) {
        row.classList.add('opacity-0', 'transition-all', 'duration-500');
        setTimeout(() => row.remove(), 500);
      }
      showToast('Data berhasil dihapus.', 'success');
    } catch (err) {
      showToast('Koneksi gagal: ' + err.message, 'error');
    }
  };
}


// === Log Modal ===
function openLogModal() {
  document.getElementById('logModal').classList.remove('hidden');
  document.getElementById('logModal').classList.add('flex');
  loadLogs();
}
function closeLogModal() {
  document.getElementById('logModal').classList.add('hidden');
  document.getElementById('logModal').classList.remove('flex');
}
function loadLogs() {
  const container = document.getElementById('logContainer');
  container.innerHTML = "<p class='text-center text-[#92A2C2]'>Memuat data...</p>";
  fetch('get_logs.php')
    .then(res => res.json())
    .then(data => {
      if (!data.success || !data.logs.length) {
        container.innerHTML = "<p class='text-center text-[#92A2C2]'>Belum ada aktivitas yang tercatat.</p>";
        return;
      }
      container.innerHTML = data.logs.map(log => `
        <div class="border-b border-white/10 pb-2 mb-2">
          <div class="font-semibold text-[#8CE0FF]">${log.user}</div>
          <div>${log.action}</div>
          <div class="text-xs text-[#92A2C2]">${log.time}</div>
        </div>`).join('');
    })
    .catch(err => {
      container.innerHTML = "<p class='text-center text-red-400'>Gagal memuat log.</p>";
    });
}

// === Modal Detail Siswa ===
function lihatSiswa(classId, className) {
  const modal = document.getElementById('modalSiswa');
  const content = document.getElementById('siswaContent');
  const title = document.getElementById('titleSiswa');

  title.innerText = "👨‍🎓 Siswa Kelas: " + className;
  modal.classList.remove('hidden');
  modal.classList.add('flex');
  content.innerHTML = `<div class='text-center text-[#92A2C2] p-3'>Memuat data...</div>`;

  fetch('../siswa/get_siswa.php?class_id=' + classId)
    .then(r => r.json())
    .then(d => {
      if (!d.success || d.data.length === 0) {
        content.innerHTML = `<div class='text-center text-[#92A2C2] p-3'>Belum ada siswa di kelas ini.</div>`;
        return;
      }
      let html = `
        <table class="min-w-full text-sm text-[#B7C9E5] border border-white/10 rounded-lg">
          <thead class="text-[#8CE0FF] bg-[#0E1525]">
            <tr>
              <th class="p-2 text-left">No</th>
              <th class="p-2 text-left">NIM</th>
              <th class="p-2 text-left">Nama</th>
              <th class="p-2 text-left">Email</th>
              <th class="p-2 text-left">WA</th>
            </tr>
          </thead>
          <tbody>
      `;
      d.data.forEach((s, i) => {
        html += `
          <tr class="border-b border-white/10 hover:bg-[#0E1525]/60 transition">
            <td class="p-2">${i+1}</td>
            <td class="p-2">${s.nim}</td>
            <td class="p-2">${s.name}</td>
            <td class="p-2">${s.email || '-'}</td>
            <td class="p-2">${s.whatsapp || '-'}</td>
          </tr>`;
      });
      html += `</tbody></table>`;
      content.innerHTML = html;
    })
    .catch(err => {
      content.innerHTML = `<div class='text-red-400 text-center p-3'>Gagal memuat data: ${err.message}</div>`;
    });
}

function tutupSiswa() {
  document.getElementById('modalSiswa').classList.add('hidden');
  document.getElementById('modalSiswa').classList.remove('flex');
}

// === FIX Notifikasi Tambah Kelas Muncul Telat ===
document.addEventListener("DOMContentLoaded", () => {
  const msg = localStorage.getItem("toastMessage");
  const type = localStorage.getItem("toastType");
  if (msg) {
    setTimeout(() => {
      showToast(msg, type || "info");
      localStorage.removeItem("toastMessage");
      localStorage.removeItem("toastType");
    }, 300);
  }
});


// === Proteksi Aksi Jika Tidak Ada Akses ===
document.addEventListener("DOMContentLoaded", () => {
  const canEdit = <?= canAccess('kelas','edit') ? 'true' : 'false' ?>;
  const canDelete = <?= canAccess('kelas','delete') ? 'true' : 'false' ?>;
  const canAdd = <?= canAccess('kelas','add') ? 'true' : 'false' ?>;

  // --- Override fungsi Edit ---
  const originalEdit = window.editKelas;
  if (typeof originalEdit === "function") {
    window.editKelas = function(id) {
      if (!canEdit) return showToast("🚫 Kamu tidak punya izin untuk edit data!", "error");
      return originalEdit(id);
    };
  }

  // --- Override fungsi Hapus ---
  const originalDelete = window.confirmDelete;
  if (typeof originalDelete === "function") {
    window.confirmDelete = function(url, id) {
      if (!canDelete) return showToast("🚫 Kamu tidak punya izin untuk hapus data!", "error");
      return originalDelete(url, id);
    };
  }

  // --- Disable tombol tambah ---
  const btnTambah = document.querySelector('a[href="tambah.php"]');
  if (btnTambah && !canAdd) {
    btnTambah.classList.add("opacity-50", "cursor-not-allowed");
    btnTambah.addEventListener("click", (e) => {
      e.preventDefault();
      showToast("❌ Kamu tidak memiliki akses untuk menambah data!", "error");
    });
  }
});


</script>

<?php
$content = ob_get_clean();
require __DIR__.'/../../inc/layout.php';
?>
