<?php
require __DIR__.'/../../inc/auth.php';
require __DIR__.'/../../inc/db.php';
if(!canAccess('kelas','add')) { 
  echo "<script>alert('Akses ditolak!');history.back();</script>"; 
  exit; 
}

$title = "Tambah Kelas";

// Ambil data dropdown awal
$tiers  = $conn->query("SELECT id, name FROM class_tiers ORDER BY name");
$groups = $conn->query("SELECT id, name FROM class_groups ORDER BY name");

// Simpan data kelas utama
if($_SERVER['REQUEST_METHOD']==='POST'){
  $tier_id  = (int)($_POST['tier_id'] ?? 0);
  $group_id = (int)($_POST['group_id'] ?? 0);
  $name     = trim($conn->real_escape_string($_POST['name'] ?? ''));
  $capacity = (int)($_POST['capacity'] ?? 0);
  $wali     = trim($conn->real_escape_string($_POST['wali'] ?? ''));
  $code     = strtoupper(substr($name,0,3))."-".rand(100,999);

  // ✅ Validasi duplikat
  $cek = $conn->query("SELECT id FROM classes WHERE name='$name' AND group_id=$group_id AND tier_id=$tier_id");
  if ($cek->num_rows > 0) {
    echo "<script>
      localStorage.setItem('toastMessage', 'Kelas dengan kombinasi ini sudah ada!');
      localStorage.setItem('toastType', 'error');
      location='tambah.php';
    </script>";
    exit;
  }

if ($tier_id && $group_id && $name !== '') {
  $conn->query("
    INSERT INTO classes (tier_id, group_id, name, capacity, homeroom_teacher, created_at)
    VALUES ($tier_id, $group_id, '$name', $capacity, '$wali', NOW())
  ");

  // Tambah ke log
  $conn->query("
    INSERT INTO logs (user_id, module, action)
    VALUES ({$_SESSION['user_id']}, 'kelas', 'Menambahkan kelas: $name')
  ");

  echo "<script>
    localStorage.setItem('toastMessage', 'Kelas berhasil ditambahkan!');
    localStorage.setItem('toastType', 'success');
    location='index.php';
  </script>";
  exit;
}

}

ob_start();
?>

<div class="p-6 rounded-2xl bg-[#141D2F] border border-white/10 max-w-md">
  <h1 class="text-xl font-semibold mb-4 text-[#8CE0FF]">Tambah Kelas Baru</h1>
  <form method="POST" class="grid gap-3">

    <!-- Dropdown Tingkatan -->
    <div>
      <label class="block mb-1 text-sm text-[#92A2C2]">Tingkatan</label>
      <div class="flex gap-2">
        <select id="tier_id" name="tier_id" required class="w-full p-2 rounded bg-[#0E1525] border border-white/10">
          <option value="">-- Pilih --</option>
          <?php while($r=$tiers->fetch_assoc()): ?>
            <option value="<?=$r['id']?>"><?=$r['name']?></option>
          <?php endwhile; ?>
        </select>
        <button type="button" onclick="openModal('tier')" class="bg-[#5B8CFF] text-[#0E1525] px-3 rounded font-bold">+</button>
      </div>
    </div>

    <!-- Dropdown Jurusan -->
    <div>
      <label class="block mb-1 text-sm text-[#92A2C2]">Jurusan</label>
      <div class="flex gap-2">
        <select id="group_id" name="group_id" required class="w-full p-2 rounded bg-[#0E1525] border border-white/10">
          <option value="">-- Pilih --</option>
          <?php while($g=$groups->fetch_assoc()): ?>
            <option value="<?=$g['id']?>"><?=$g['name']?></option>
          <?php endwhile; ?>
        </select>
        <button type="button" onclick="openModal('group')" class="bg-[#5B8CFF] text-[#0E1525] px-3 rounded font-bold">+</button>
      </div>
    </div>

    <!-- Nama Kelas -->
    <div>
      <label class="block mb-1 text-sm text-[#92A2C2]">Nama Kelas</label>
      <input type="text" name="name" required class="w-full p-2 rounded bg-[#0E1525] border border-white/10">
    </div>

    <!-- Wali Kelas -->
    <div>
      <label class="block mb-1 text-sm text-[#92A2C2]">Wali Kelas</label>
      <input type="text" name="wali" required class="w-full p-2 rounded bg-[#0E1525] border border-white/10">
    </div>

    <!-- Daya Tampung -->
    <div>
      <label class="block mb-1 text-sm text-[#92A2C2]">Daya Tampung</label>
      <input type="number" name="capacity" value="30" required class="w-full p-2 rounded bg-[#0E1525] border border-white/10">
    </div>

    <button type="submit" class="mt-4 bg-[#5B8CFF] text-[#0E1525] font-semibold rounded py-2 hover:bg-[#8CE0FF] transition">
      Simpan
    </button>
  </form>
</div>

<!-- Modal Tambah Tingkatan / Jurusan -->
<div id="modal" class="fixed inset-0 bg-black/60 hidden items-center justify-center">
  <div class="bg-[#141D2F] p-6 rounded-2xl w-80">
    <h2 id="modal-title" class="text-xl font-semibold text-[#8CE0FF] mb-3">Tambah</h2>
    <input type="text" id="modal-input" class="w-full p-2 rounded bg-[#0E1525] border border-white/10 mb-4" placeholder="Nama...">
    <div class="flex justify-end gap-2">
      <button onclick="closeModal()" class="px-3 py-1 bg-gray-600 rounded">Batal</button>
      <button onclick="saveModal()" class="px-3 py-1 bg-[#5B8CFF] text-[#0E1525] rounded font-semibold">Simpan</button>
    </div>
  </div>
</div>

<script>
let mode = '';

function openModal(type) {
  mode = type;
  document.getElementById('modal').classList.remove('hidden');
  document.getElementById('modal-title').innerText = 'Tambah ' + (type === 'tier' ? 'Tingkatan' : 'Jurusan');
  document.getElementById('modal-input').value = '';
  document.getElementById('modal-input').focus();
}

function closeModal() {
  document.getElementById('modal').classList.add('hidden');
}

function saveModal() {
  const name = document.getElementById('modal-input').value.trim();
  if (!name) {
    showToast('Nama tidak boleh kosong!', 'warning');
    return;
  }

  const baseUrl = window.location.pathname.split('/modules/kelas/')[0] + '/modules/kelas/';
  const target  = baseUrl + 'ajax_add_' + mode + '.php';

  fetch(target, {
    method: 'POST',
    headers: {'Content-Type': 'application/x-www-form-urlencoded'},
    body: 'name=' + encodeURIComponent(name) + '&tier_id=' + document.getElementById('tier_id').value
  })
  .then(async res => {
    const text = await res.text();
    try {
      return JSON.parse(text);
    } catch (e) {
      throw new Error("Respon bukan JSON: " + text);
    }
  })
  .then(d => {
    if (!d.success) throw new Error(d.error || 'Gagal menyimpan');
    showToast('Berhasil menambahkan ' + name, 'success');
    closeModal();
    location.reload();
  })
  .catch(err => {
    console.error('Error detail:', err);
    alert('Error koneksi: ' + err.message);
  });
}

// === Menampilkan notifikasi global (pakai localStorage) ===
document.addEventListener('DOMContentLoaded', ()=>{
  const msg = localStorage.getItem('toastMessage');
  const type = localStorage.getItem('toastType');
  if(msg){
    showToast(msg, type || 'info');
    localStorage.removeItem('toastMessage');
    localStorage.removeItem('toastType');
  }
});
</script>

<?php
$content = ob_get_clean();
require __DIR__.'/../../inc/layout.php';
?>
