<?php
require __DIR__.'/../../inc/db.php';
session_start();

$id       = (int)($_POST['id'] ?? 0);
$name     = trim($conn->real_escape_string($_POST['name'] ?? ''));
$wali     = trim($conn->real_escape_string($_POST['wali'] ?? ''));
$capacity = (int)($_POST['capacity'] ?? 0);

if ($id <= 0 || $name === '') {
  echo json_encode(['success' => false, 'error' => 'Data tidak valid.']);
  exit;
}

// Ambil tier & group dari kelas yang diupdate
$kelas = $conn->query("SELECT tier_id, group_id FROM classes WHERE id=$id")->fetch_assoc();
if (!$kelas) {
  echo json_encode(['success' => false, 'error' => 'Data kelas tidak ditemukan.']);
  exit;
}
$tier_id  = (int)$kelas['tier_id'];
$group_id = (int)$kelas['group_id'];

// 🔍 Cek duplikat (abaikan spasi DALAM kata dan huruf besar/kecil)
$normalizedName = strtolower(str_replace(' ', '', $name));

$cek = $conn->query("
  SELECT id FROM classes 
  WHERE REPLACE(LOWER(name), ' ', '') = '$normalizedName'
    AND tier_id = $tier_id 
    AND group_id = $group_id 
    AND id != $id
  LIMIT 1
");

if ($cek && $cek->num_rows > 0) {
  echo json_encode([
    'success' => false,
    'error' => 'Nama kelas sudah digunakan pada tingkatan dan jurusan yang sama!'
  ]);
  exit;
}

// ✅ Update data kelas
$q = "UPDATE classes 
      SET name='$name', homeroom_teacher='$wali', capacity=$capacity 
      WHERE id=$id";

if ($conn->query($q)) {
  // Tambahkan log aktivitas
  $uid = $_SESSION['user_id'] ?? 0;
  $conn->query("
    INSERT INTO logs (user_id, module, action, created_at)
    VALUES ($uid, 'kelas', 'Memperbarui kelas: $name', NOW())
  ");

  echo json_encode(['success' => true]);
} else {
  echo json_encode(['success' => false, 'error' => $conn->error]);
}
?>
