<?php
require __DIR__.'/../../inc/auth.php';
require __DIR__.'/../../inc/db.php';
logActivity('Laporan', 'view');


date_default_timezone_set('Asia/Jakarta');

$title = "Laporan Absensi";

// Filter tanggal (default: hari ini)
$tanggal_awal = $_GET['awal'] ?? date('Y-m-01');
$tanggal_akhir = $_GET['akhir'] ?? date('Y-m-d');

// Ambil data absensi sesuai filter
$q = $conn->query("
  SELECT a.*, u.nama 
  FROM attendance a 
  LEFT JOIN users u ON a.user_id=u.id 
  WHERE a.tanggal BETWEEN '$tanggal_awal' AND '$tanggal_akhir'
  ORDER BY a.tanggal DESC
");

// Hitung rekap status
$rekap = ['Hadir'=>0, 'Telat'=>0, 'Izin'=>0, 'Sakit'=>0];
$rq = $conn->query("
  SELECT status, COUNT(*) AS jml 
  FROM attendance 
  WHERE tanggal BETWEEN '$tanggal_awal' AND '$tanggal_akhir'
  GROUP BY status
");
while($r = $rq->fetch_assoc()){
  $rekap[$r['status']] = (int)$r['jml'];
}

ob_start();
?>
<div class="p-6 rounded-2xl bg-[#141D2F] border border-white/10 text-[#E2E8F0]">
  <h1 class="text-3xl font-semibold mb-6">🧾 Laporan Absensi</h1>

  <!-- Filter tanggal -->
  <form method="GET" class="flex flex-wrap items-end gap-3 mb-6">
    <div>
      <label class="text-sm text-[#92A2C2]">Tanggal Awal</label>
      <input type="date" name="awal" value="<?=$tanggal_awal?>" class="bg-[#0E1525] border border-white/10 text-white rounded p-2">
    </div>
    <div>
      <label class="text-sm text-[#92A2C2]">Tanggal Akhir</label>
      <input type="date" name="akhir" value="<?=$tanggal_akhir?>" class="bg-[#0E1525] border border-white/10 text-white rounded p-2">
    </div>
    <button type="submit" class="bg-[#5B8CFF] text-[#0E1525] px-4 py-2 rounded-lg hover:bg-[#8CE0FF] transition font-semibold">Tampilkan</button>
    <a href="export_excel.php?awal=<?=$tanggal_awal?>&akhir=<?=$tanggal_akhir?>" 
       class="bg-[#22C55E] text-[#0E1525] px-4 py-2 rounded-lg hover:bg-[#86EFAC] font-semibold">📤 Export Excel</a>
  </form>

  <!-- Rekap Status -->
  <div class="grid grid-cols-2 md:grid-cols-4 gap-4 mb-6">
    <?php foreach ($rekap as $status => $jumlah): ?>
      <div class="bg-[#1B2845] p-4 rounded-xl text-center border border-white/10">
        <h2 class="text-sm text-[#92A2C2]"><?=$status?></h2>
        <p class="text-2xl font-bold text-[#8CE0FF]"><?=$jumlah?></p>
      </div>
    <?php endforeach; ?>
  </div>

 <!-- Tabel Data -->
<div class="overflow-x-auto">
  <table class="min-w-full border border-white/10 rounded-xl overflow-hidden text-sm text-[#E2E8F0]">
    <thead class="bg-[#1B2845] text-[#8CE0FF] uppercase tracking-wider text-xs">
      <tr>
        <th class="py-3 px-4 text-left w-[15%]">Tanggal</th>
        <th class="py-3 px-4 text-left w-[30%]">Nama</th>
        <th class="py-3 px-4 text-center w-[15%]">Jam Masuk</th>
        <th class="py-3 px-4 text-center w-[15%]">Status</th>
        <th class="py-3 px-4 text-left w-[25%]">Keterangan</th>
      </tr>
    </thead>
    <tbody>
      <?php 
      $row_exist = false;
      while($r=$q->fetch_assoc()): 
        $row_exist = true;
      ?>
      <tr class="border-b border-white/5 hover:bg-[#2A3D69] transition">
        <td class="py-3 px-4 align-middle"><?=$r['tanggal']?></td>
        <td class="py-3 px-4 align-middle"><?=$r['nama']?></td>
        <td class="py-3 px-4 text-center align-middle"><?=$r['jam_masuk']?></td>
        <td class="py-3 px-4 text-center align-middle font-semibold 
          <?=($r['status']=='Hadir'?'text-[#8CE0FF]':
            ($r['status']=='Telat'?'text-[#FACC15]':
            ($r['status']=='Izin'?'text-[#22C55E]':'text-[#EF4444]')))?>">
          <?=$r['status']?>
        </td>
        <td class="py-3 px-4 align-middle"><?=$r['keterangan']?></td>
      </tr>
      <?php endwhile; ?>

      <?php if(!$row_exist): ?>
        <tr>
          <td colspan="5" class="text-center py-4 text-[#92A2C2] italic">
            Tidak ada data absensi pada rentang tanggal ini.
          </td>
        </tr>
      <?php endif; ?>
    </tbody>
  </table>
</div>

</div>
<?php
$content = ob_get_clean();
require __DIR__.'/../../inc/layout.php';
?>
