<?php
require __DIR__.'/../../inc/auth.php';
require __DIR__.'/../../inc/db.php';
date_default_timezone_set('Asia/Jakarta');

$user_id = $_GET['user_id'] ?? 0;
$tanggal = $_GET['tanggal'] ?? date('Y-m-d');

// Ambil data user
$u = $conn->query("SELECT * FROM users WHERE id=$user_id")->fetch_assoc();

// Ambil log aktivitas user di tanggal itu
$q = $conn->query("
  SELECT * 
  FROM user_activity_log
  WHERE user_id=$user_id AND DATE(log_time)='$tanggal'
  ORDER BY log_time DESC
");

$title = "Detail Aktivitas: {$u['nama']} ($tanggal)";
ob_start();
?>
<div class="p-6 rounded-2xl bg-[#141D2F] border border-white/10 text-[#E2E8F0]">
  <h1 class="text-2xl font-semibold mb-6">📋 Aktivitas: <?=$u['nama']?> (<?=$tanggal?>)</h1>

  <a href="index.php?tanggal=<?=$tanggal?>" class="bg-[#8CE0FF] text-[#0E1525] px-4 py-1 rounded-lg hover:bg-[#5B8CFF] font-semibold mb-6 inline-block">
    ← Kembali
  </a>

  <div class="overflow-x-auto mt-4">
    <table class="min-w-full border border-white/10 rounded-xl text-sm">
      <thead class="bg-[#1B2845] text-[#8CE0FF] uppercase tracking-wider text-xs">
        <tr>
          <th class="py-3 px-4 text-left w-[20%]">Menu</th>
          <th class="py-3 px-4 text-center w-[10%]">Aksi</th>
          <th class="py-3 px-4 text-center w-[15%]">IP</th>
          <th class="py-3 px-4 text-center w-[20%]">Waktu</th>
        </tr>
      </thead>
      <tbody>
        <?php if($q->num_rows == 0): ?>
          <tr><td colspan="4" class="text-center py-4 text-[#92A2C2] italic">Belum ada aktivitas user ini pada tanggal ini.</td></tr>
        <?php else: while($r=$q->fetch_assoc()): ?>
          <tr class="border-b border-white/5 hover:bg-[#2A3D69] transition">
            <td class="py-3 px-4"><?=$r['menu']?></td>
            <td class="py-3 px-4 text-center"><?=$r['action']?></td>
            <td class="py-3 px-4 text-center"><?=$r['ip_address']?></td>
            <td class="py-3 px-4 text-center text-[#8CE0FF]"><?=date('H:i:s', strtotime($r['log_time']))?></td>
          </tr>
        <?php endwhile; endif; ?>
      </tbody>
    </table>
  </div>
</div>
<?php
$content = ob_get_clean();
require __DIR__.'/../../inc/layout.php';
?>
