<?php
require __DIR__.'/../../inc/auth.php';
require __DIR__.'/../../inc/db.php';
$title = "Riwayat Login & Aktivitas User";

// Ambil data login
$q_login = $conn->query("
  SELECT l.*, u.nama 
  FROM user_logins l 
  LEFT JOIN users u ON l.user_id=u.id
  ORDER BY l.login_time DESC
  LIMIT 100
");

// Ambil data aktivitas
$q_activity = $conn->query("
  SELECT a.*, u.nama 
  FROM user_activity_log a 
  LEFT JOIN users u ON a.user_id=u.id
  ORDER BY a.log_time DESC
  LIMIT 200
");

ob_start();
?>
<div class="p-6 rounded-2xl bg-[#141D2F] border border-white/10 text-[#E2E8F0]">
  <h1 class="text-3xl font-semibold mb-6">🧑‍💻 Riwayat Login & Aktivitas User</h1>

  <!-- Tabel Riwayat Login -->
  <h2 class="text-2xl font-semibold mb-4">🕓 Riwayat Login</h2>
  <div class="overflow-x-auto mb-10">
    <table class="min-w-full border border-white/10 rounded-xl text-sm">
      <thead class="bg-[#1B2845] text-[#8CE0FF] uppercase tracking-wider text-xs">
        <tr>
          <th class="py-3 px-4 text-left">Nama User</th>
          <th class="py-3 px-4 text-left">Username</th>
          <th class="py-3 px-4 text-center">IP Address</th>
          <th class="py-3 px-4 text-left">Perangkat</th>
          <th class="py-3 px-4 text-center">Waktu Login</th>
        </tr>
      </thead>
      <tbody>
        <?php if($q_login->num_rows == 0): ?>
          <tr><td colspan="5" class="text-center py-4 text-[#92A2C2] italic">Belum ada riwayat login.</td></tr>
        <?php else: while($r=$q_login->fetch_assoc()): ?>
          <tr class="border-b border-white/5 hover:bg-[#2A3D69] transition">
            <td class="py-3 px-4"><?=$r['nama']?></td>
            <td class="py-3 px-4"><?=$r['username']?></td>
            <td class="py-3 px-4 text-center"><?=$r['ip_address']?></td>
            <td class="py-3 px-4 truncate" title="<?=$r['user_agent']?>"><?=substr($r['user_agent'],0,50)?>...</td>
            <td class="py-3 px-4 text-center text-[#8CE0FF]"><?=date('d M Y H:i:s', strtotime($r['login_time']))?></td>
          </tr>
        <?php endwhile; endif; ?>
      </tbody>
    </table>
  </div>

  <!-- Tabel Aktivitas -->
  <h2 class="text-2xl font-semibold mb-4">📋 Aktivitas Pengguna</h2>
  <div class="overflow-x-auto">
    <table class="min-w-full border border-white/10 rounded-xl text-sm">
      <thead class="bg-[#1B2845] text-[#8CE0FF] uppercase tracking-wider text-xs">
        <tr>
          <th class="py-3 px-4 text-left">Nama User</th>
          <th class="py-3 px-4 text-left">Menu</th>
          <th class="py-3 px-4 text-center">Aksi</th>
          <th class="py-3 px-4 text-center">IP</th>
          <th class="py-3 px-4 text-center">Waktu</th>
        </tr>
      </thead>
      <tbody>
        <?php if($q_activity->num_rows == 0): ?>
          <tr><td colspan="5" class="text-center py-4 text-[#92A2C2] italic">Belum ada aktivitas pengguna.</td></tr>
        <?php else: while($r=$q_activity->fetch_assoc()): ?>
          <tr class="border-b border-white/5 hover:bg-[#2A3D69] transition">
            <td class="py-3 px-4"><?=$r['nama']?></td>
            <td class="py-3 px-4"><?=$r['menu']?></td>
            <td class="py-3 px-4 text-center"><?=$r['action']?></td>
            <td class="py-3 px-4 text-center"><?=$r['ip_address']?></td>
            <td class="py-3 px-4 text-center text-[#8CE0FF]"><?=date('d M Y H:i:s', strtotime($r['log_time']))?></td>
          </tr>
        <?php endwhile; endif; ?>
      </tbody>
    </table>
  </div>
</div>
<?php
$content = ob_get_clean();
require __DIR__.'/../../inc/layout.php';
?>
