<?php
require __DIR__ . '/../../inc/auth.php';
require __DIR__ . '/../../inc/db.php';

$title = "Manajemen Mata Pelajaran";
$title_icon = "fa-solid fa-book";

ob_start();

// === API HANDLER (AJAX) ===
if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['action'])) {
  header('Content-Type: application/json');

  // === TAMBAH ===
  if ($_POST['action'] === 'add') {
    $kode = trim($_POST['kode_mapel'] ?? '');
    $nama = trim($_POST['nama_mapel'] ?? '');
    $guru = trim($_POST['guru_pengampu'] ?? '');
    $deskripsi = trim($_POST['deskripsi'] ?? '');
    $status = trim($_POST['status'] ?? 'Aktif');

    if ($kode && $nama) {
      $stmt = $conn->prepare("INSERT INTO mapel (kode_mapel, nama_mapel, guru_pengampu, deskripsi, status)
                              VALUES (?, ?, ?, ?, ?)");
      $stmt->bind_param("sssss", $kode, $nama, $guru, $deskripsi, $status);
      $stmt->execute();
      echo json_encode(["success" => true, "message" => "✅ Mata pelajaran berhasil ditambahkan."]);
    } else {
      echo json_encode(["success" => false, "message" => "⚠️ Harap isi kolom kode dan nama mapel."]);
    }
    exit;
  }

  // === EDIT ===
  if ($_POST['action'] === 'edit') {
    $id = (int)$_POST['id'];
    $kode = trim($_POST['kode_mapel'] ?? '');
    $nama = trim($_POST['nama_mapel'] ?? '');
    $guru = trim($_POST['guru_pengampu'] ?? '');
    $deskripsi = trim($_POST['deskripsi'] ?? '');
    $status = trim($_POST['status'] ?? 'Aktif');

    $stmt = $conn->prepare("UPDATE mapel SET kode_mapel=?, nama_mapel=?, guru_pengampu=?, deskripsi=?, status=? WHERE id=?");
    $stmt->bind_param("sssssi", $kode, $nama, $guru, $deskripsi, $status, $id);
    $stmt->execute();
    echo json_encode(["success" => true, "message" => "✏️ Data mapel berhasil diperbarui."]);
    exit;
  }

  // === HAPUS ===
  if ($_POST['action'] === 'delete') {
    $id = (int)$_POST['id'];
    $stmt = $conn->prepare("DELETE FROM mapel WHERE id=?");
    $stmt->bind_param("i", $id);
    $stmt->execute();
    echo json_encode(["success" => true, "message" => "🗑️ Mata pelajaran berhasil dihapus."]);
    exit;
  }

  // === REFRESH TABLE ===
  if ($_POST['action'] === 'get_table') {
    ob_start();
    $result = $conn->query("SELECT * FROM mapel ORDER BY created_at DESC");
    include __DIR__ . '/mapel_table.php';
    echo json_encode(["html" => ob_get_clean()]);
    exit;
  }
}
?>

<!-- ========== KONTEN ========== -->
<div class="main-content p-6">

  <!-- FORM -->
  <form id="formMapel"
    class="bg-[#141D2F]/80 border border-[#1E2B44] rounded-2xl p-6 shadow-lg mb-10 space-y-5">
    <input type="hidden" name="id" id="editId">

    <div class="grid md:grid-cols-2 gap-6">
      <div>
        <label class="text-sm text-gray-300 mb-1 block">Kode Mapel</label>
        <input type="text" name="kode_mapel" id="kode_mapel" required
          class="w-full bg-[#0E1525] border border-[#2A3550] rounded-lg px-3 py-2 text-gray-100 focus:ring-2 focus:ring-[#8CE0FF] outline-none">
      </div>
      <div>
        <label class="text-sm text-gray-300 mb-1 block">Nama Mapel</label>
        <input type="text" name="nama_mapel" id="nama_mapel" required
          class="w-full bg-[#0E1525] border border-[#2A3550] rounded-lg px-3 py-2 text-gray-100 focus:ring-2 focus:ring-[#8CE0FF] outline-none">
      </div>
    </div>

    <div class="grid md:grid-cols-2 gap-6">
      <div>
        <label class="text-sm text-gray-300 mb-1 block">Guru Pengampu</label>
        <input type="text" name="guru_pengampu" id="guru_pengampu"
          class="w-full bg-[#0E1525] border border-[#2A3550] rounded-lg px-3 py-2 text-gray-100 focus:ring-2 focus:ring-[#8CE0FF] outline-none">
      </div>
      <div>
        <label class="text-sm text-gray-300 mb-1 block">Status</label>
        <select name="status" id="status"
          class="w-full bg-[#0E1525] border border-[#2A3550] rounded-lg px-3 py-2 text-gray-100 focus:ring-2 focus:ring-[#8CE0FF]">
          <option value="Aktif">Aktif</option>
          <option value="Nonaktif">Nonaktif</option>
        </select>
      </div>
    </div>

    <div>
      <label class="text-sm text-gray-300 mb-1 block">Deskripsi (Opsional)</label>
      <textarea name="deskripsi" id="deskripsi" rows="2"
        class="w-full bg-[#0E1525] border border-[#2A3550] rounded-lg px-3 py-2 text-gray-100 focus:ring-2 focus:ring-[#8CE0FF] resize-none"></textarea>
    </div>

    <div class="text-right pt-2">
      <button type="submit" id="btnSubmit"
        class="bg-[#8CE0FF] text-[#0E1525] px-5 py-2 rounded-lg text-sm font-semibold hover:bg-[#9CE8FF] transition-all shadow-md hover:shadow-[#8CE0FF]/40">
        Simpan Mapel
      </button>
    </div>
  </form>

  <!-- LIST MAPEL -->
  <div id="mapelList">
    <?php include __DIR__ . '/mapel_table.php'; ?>
  </div>
</div>

<!-- TOAST -->
<div id="toast" class="fixed top-8 left-1/2 -translate-x-1/2 hidden z-[9999] px-6 py-3 rounded-lg text-sm font-semibold text-white shadow-lg backdrop-blur-md opacity-0 transition-all duration-500"></div>

<script>
let isEditing = false;

function showToast(msg, type = 'info') {
  const t = document.getElementById('toast');
  const color = {
    success: 'bg-emerald-600/90 border border-emerald-400',
    error: 'bg-red-600/90 border border-red-400',
    warning: 'bg-yellow-600/90 border border-yellow-400',
    info: 'bg-sky-600/90 border border-sky-400'
  };
  t.className = `fixed top-8 left-1/2 -translate-x-1/2 z-[9999] px-6 py-3 rounded-lg text-sm font-semibold text-white shadow-lg ${color[type]}`;
  t.innerText = msg;
  t.classList.remove('hidden');
  setTimeout(() => t.style.opacity = '1', 100);
  setTimeout(() => { t.style.opacity = '0'; setTimeout(() => t.classList.add('hidden'), 500) }, 2500);
}

async function refreshTable() {
  const fd = new FormData();
  fd.append('action', 'get_table');
  const res = await fetch('', { method: 'POST', body: fd });
  const data = await res.json();
  document.getElementById('mapelList').innerHTML = data.html;
}

document.getElementById('formMapel').addEventListener('submit', async e => {
  e.preventDefault();
  const fd = new FormData(e.target);
  fd.append('action', isEditing ? 'edit' : 'add');
  const res = await fetch('', { method: 'POST', body: fd });
  const data = await res.json();
  showToast(data.message, data.success ? 'success' : 'warning');
  if (data.success) {
    refreshTable();
    e.target.reset();
    document.getElementById('btnSubmit').innerText = 'Simpan Mapel';
    isEditing = false;
  }
});

function editMapel(row) {
  document.getElementById('editId').value = row.id;
  document.getElementById('kode_mapel').value = row.kode_mapel;
  document.getElementById('nama_mapel').value = row.nama_mapel;
  document.getElementById('guru_pengampu').value = row.guru_pengampu;
  document.getElementById('deskripsi').value = row.deskripsi;
  document.getElementById('status').value = row.status;
  document.getElementById('btnSubmit').innerText = 'Perbarui Mapel';
  isEditing = true;
  showToast('Mode edit aktif', 'info');
}

async function deleteMapel(id) {
  if (!confirm("Yakin ingin menghapus mata pelajaran ini?")) return;
  const fd = new FormData();
  fd.append('action', 'delete');
  fd.append('id', id);
  const res = await fetch('', { method: 'POST', body: fd });
  const data = await res.json();
  showToast(data.message, data.success ? 'success' : 'error');
  if (data.success) refreshTable();
}
</script>

<?php
$content = ob_get_clean();
include __DIR__ . '/../../inc/layout.php';
?>
