<?php
// Jika variabel $result belum ada, maka jalankan query manual
if (!isset($result)) {
  require __DIR__ . '/../../inc/db.php';
  $result = $conn->query("SELECT * FROM mapel ORDER BY created_at DESC");
}
?>

<table class="w-full text-sm border border-[#1E2B44] rounded-lg overflow-hidden">
  <thead class="bg-[#101827]/80 text-[#8CE0FF] uppercase text-xs tracking-wider">
    <tr>
      <th class="px-4 py-2 text-left">Kode</th>
      <th class="px-4 py-2 text-left">Nama Mapel</th>
      <th class="px-4 py-2 text-left">Guru Pengampu</th>
      <th class="px-4 py-2 text-left">Status</th>
      <th class="px-4 py-2 text-center w-28">Aksi</th>
    </tr>
  </thead>
  <tbody class="text-gray-300">
    <?php if ($result && $result->num_rows > 0): ?>
      <?php while ($r = $result->fetch_assoc()): ?>
        <tr class="border-t border-[#1E2B44] hover:bg-[#1E2942]/60 transition" id="mapel-<?= $r['id'] ?>">
          <td class="px-4 py-2"><?= htmlspecialchars($r['kode_mapel']) ?></td>
          <td class="px-4 py-2"><?= htmlspecialchars($r['nama_mapel']) ?></td>
          <td class="px-4 py-2"><?= htmlspecialchars($r['guru_pengampu'] ?: '-') ?></td>
          <td class="px-4 py-2">
            <span class="px-2 py-1 text-xs rounded-full <?= $r['status'] === 'Aktif' ? 'bg-emerald-600/30 text-emerald-300' : 'bg-red-600/30 text-red-300' ?>">
              <?= $r['status'] ?>
            </span>
          </td>
          <td class="px-4 py-2 text-center">
            <button onclick='editMapel(<?= json_encode($r) ?>)' class="text-blue-400 hover:text-blue-300 mx-1">
              <i class="fa-solid fa-pen"></i>
            </button>
            <button onclick="deleteMapel(<?= $r['id'] ?>)" class="text-red-400 hover:text-red-300 mx-1">
              <i class="fa-solid fa-trash"></i>
            </button>
          </td>
        </tr>
      <?php endwhile; ?>
    <?php else: ?>
      <tr>
        <td colspan="5" class="text-center py-4 text-gray-500">Belum ada mata pelajaran.</td>
      </tr>
    <?php endif; ?>
  </tbody>
</table>
