<?php
require __DIR__ . '/../../inc/auth.php';
require __DIR__ . '/../../inc/db.php';

$title = "Manajemen Pengumuman";
$title_icon = "fa-solid fa-bullhorn";

ob_start();

// ==== DEBUG MODE AMAN UNTUK HOSTING ====
mysqli_report(MYSQLI_REPORT_OFF);

// === API HANDLER (AJAX) ===
if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['action'])) {
  header('Content-Type: application/json; charset=utf-8');

  // Cek koneksi
  if (!isset($conn) || !$conn instanceof mysqli) {
    echo json_encode(["success" => false, "message" => "❌ Gagal terhubung ke database."]);
    exit;
  }

  // Fungsi bantu untuk log error
  function logError($msg) {
    file_put_contents(__DIR__ . '/error_log_pengumuman.txt', date('Y-m-d H:i:s') . " - " . $msg . "\n", FILE_APPEND);
  }

  try {
    // === TAMBAH ===
  if ($_POST['action'] === 'add') {
  $judul = trim($_POST['judul'] ?? '');
  $isi = trim($_POST['isi'] ?? '');
  $tanggal = trim($_POST['tanggal'] ?? '');
  $status = trim($_POST['status'] ?? 'Aktif');
  $remind_before = (int) ($_POST['remind_before'] ?? 0);

  // Tambahan kolom default
  $target = 'semua';
  $start_date = null;
  $end_date = null;
  $created_by = $_SESSION['user_name'] ?? 'admin'; // atau ganti sesuai field login kamu

  if ($judul && $isi && $tanggal) {
    $stmt = $conn->prepare("
      INSERT INTO announcements
      (title, content, event_date, status, target, start_date, end_date, created_by)
      VALUES (?, ?, ?, ?, ?, ?, ?, ?)
    ");
    if (!$stmt) {
      logError('SQL Error (Add): ' . $conn->error);
      echo json_encode(["success" => false, "message" => "❌ Query gagal: " . $conn->error]);
      exit;
    }
    $stmt->bind_param("ssssssss", $judul, $isi, $tanggal, $status, $target, $start_date, $end_date, $created_by);
    $stmt->execute();

    echo json_encode(["success" => true, "message" => "✅ Pengumuman berhasil disimpan!"]);
  } else {
    echo json_encode(["success" => false, "message" => "⚠️ Harap isi semua kolom dengan benar."]);
  }
  exit;
}

    // === HAPUS ===
    if ($_POST['action'] === 'delete') {
      $id = (int)$_POST['id'];
      $stmt = $conn->prepare("DELETE FROM announcements WHERE id = ?");
      $stmt->bind_param("i", $id);
      $stmt->execute();
      echo json_encode(["success" => true, "message" => "🗑️ Pengumuman berhasil dihapus."]);
      exit;
    }

    // === EDIT ===
    if ($_POST['action'] === 'edit') {
  $id = (int) $_POST['id'];
  $judul = trim($_POST['judul'] ?? '');
  $isi = trim($_POST['isi'] ?? '');
  $tanggal = trim($_POST['tanggal'] ?? '');
  $status = trim($_POST['status'] ?? 'Aktif');
  $remind_before = (int) ($_POST['remind_before'] ?? 0);
  $target = 'semua';
  $start_date = null;
  $end_date = null;

  if ($judul && $isi && $tanggal) {
    $stmt = $conn->prepare("
      UPDATE announcements
      SET title=?, content=?, event_date=?, status=?, target=?, start_date=?, end_date=?
      WHERE id=?
    ");
    if (!$stmt) {
      logError('SQL Error (Edit): ' . $conn->error);
      echo json_encode(["success" => false, "message" => "❌ Query gagal: " . $conn->error]);
      exit;
    }
    $stmt->bind_param("sssssssi", $judul, $isi, $tanggal, $status, $target, $start_date, $end_date, $id);
    $stmt->execute();

    echo json_encode(["success" => true, "message" => "✏️ Pengumuman berhasil diperbarui!"]);
  } else {
    echo json_encode(["success" => false, "message" => "⚠️ Harap isi semua kolom dengan benar."]);
  }
  exit;
}

    // === REFRESH TABEL ===
    if ($_POST['action'] === 'get_table') {
      ob_start();
      $data = $conn->query("SELECT * FROM announcements ORDER BY event_date DESC");
      include __DIR__ . '/pengumuman_table.php';
      echo json_encode(["html" => ob_get_clean()]);
      exit;
    }

  } catch (Throwable $e) {
    logError($e->getMessage());
    echo json_encode(["success" => false, "message" => "❌ Terjadi kesalahan server."]);
    exit;
  }
}
?>

<!-- ======================== KONTEN ======================== -->
<div class="main-content p-6">

  <form id="formPengumuman"
    class="bg-[#141D2F]/80 border border-[#1E2B44] rounded-2xl p-6 shadow-lg mb-10 space-y-5">
    <input type="hidden" name="id" id="editId">

    <div class="grid md:grid-cols-2 gap-6">
      <div>
        <label class="block text-sm font-medium text-gray-300 mb-1">Judul Pengumuman</label>
        <input type="text" name="judul" id="judul" required
          class="w-full bg-[#0E1525] border border-[#2A3550] rounded-lg px-3 py-2 text-gray-100 focus:ring-2 focus:ring-[#8CE0FF] outline-none transition">
      </div>
      <div>
        <label class="block text-sm font-medium text-gray-300 mb-1">Tanggal & Waktu Kegiatan</label>
        <input type="datetime-local" name="tanggal" id="tanggal" required
          class="w-full bg-[#0E1525] border border-[#2A3550] rounded-lg px-3 py-2 text-gray-100 focus:ring-2 focus:ring-[#8CE0FF] outline-none transition">
      </div>
    </div>

    <div>
      <label class="block text-sm font-medium text-gray-300 mb-1">Isi Pengumuman</label>
      <textarea name="isi" id="isi" rows="3" required
        class="w-full bg-[#0E1525] border border-[#2A3550] rounded-lg px-3 py-2 text-gray-100 focus:ring-2 focus:ring-[#8CE0FF] outline-none resize-none"></textarea>
    </div>

    <div class="grid md:grid-cols-2 gap-6">
      <div>
        <label class="block text-sm font-medium text-gray-300 mb-1">Waktu Pengingat</label>
        <select name="remind_before" id="remind_before"
          class="w-full bg-[#0E1525] border border-[#2A3550] rounded-lg px-3 py-2 text-gray-100 focus:ring-2 focus:ring-[#8CE0FF] outline-none">
          <option value="">Tidak ada pengingat</option>
          <option value="15">15 menit sebelum</option>
          <option value="30">30 menit sebelum</option>
          <option value="60">1 jam sebelum</option>
          <option value="1440">1 hari sebelum</option>
        </select>
      </div>

      <div>
        <label class="block text-sm font-medium text-gray-300 mb-1">Status</label>
        <select name="status" id="status"
          class="w-full bg-[#0E1525] border border-[#2A3550] rounded-lg px-3 py-2 text-gray-100 focus:ring-2 focus:ring-[#8CE0FF] outline-none">
          <option value="Aktif">Aktif</option>
          <option value="Nonaktif">Nonaktif</option>
        </select>
      </div>
    </div>

    <div class="text-right pt-2">
      <button type="submit" id="btnSubmit"
        class="bg-[#8CE0FF] text-[#0E1525] px-5 py-2 rounded-lg text-sm font-semibold hover:bg-[#9CE8FF] transition-all shadow-md hover:shadow-[#8CE0FF]/40">
        Simpan Pengumuman
      </button>
    </div>
  </form>

  <div id="pengumumanList" class="transition-all duration-500">
    <?php include __DIR__ . '/pengumuman_table.php'; ?>
  </div>
</div>

<!-- MODAL & TOAST -->
<div id="confirmModal"
  class="fixed inset-0 bg-black/60 backdrop-blur-sm hidden z-[999] flex items-center justify-center transition-all duration-300">
  <div id="modalBox"
    class="bg-gradient-to-b from-[#141D2F] to-[#0E1525] border border-[#2A3550] rounded-2xl shadow-2xl p-8 w-[95%] max-w-md text-center scale-95 opacity-0 transition-all duration-300">
    <div class="mb-4 text-[#8CE0FF] text-2xl">
      <i class="fa-solid fa-triangle-exclamation"></i>
    </div>
    <h2 class="text-lg font-semibold text-[#E6EEF9] mb-2">Konfirmasi Hapus</h2>
    <p class="text-sm text-gray-400 mb-6">Yakin ingin menghapus pengumuman ini?</p>
    <div class="flex justify-center gap-4">
      <button id="confirmYes"
        class="px-6 py-2 rounded-lg text-sm font-semibold bg-gradient-to-r from-[#8CE0FF] to-[#6CC7E0] text-[#0E1525] hover:opacity-90 transition-all shadow-lg">
        Hapus
      </button>
      <button id="confirmNo"
        class="px-6 py-2 rounded-lg text-sm font-semibold bg-[#1B253A] text-gray-300 hover:bg-[#243250] transition-all">
        Batal
      </button>
    </div>
  </div>
</div>

<div id="toast"
  class="fixed top-8 left-1/2 -translate-x-1/2 hidden z-[9999] px-6 py-3 rounded-lg text-sm font-semibold text-white shadow-lg backdrop-blur-md opacity-0 transition-all duration-500"></div>

<script>
let deleteId = null, isEditing = false;

// ===== TOAST =====
function showToast(msg, type = 'info') {
  const t = document.getElementById('toast');
  const color = {
    success: 'bg-emerald-600/90 border border-emerald-400',
    error: 'bg-red-600/90 border border-red-400',
    warning: 'bg-yellow-600/90 border border-yellow-400',
    info: 'bg-sky-600/90 border border-sky-400'
  };
  t.className = `fixed top-8 left-1/2 -translate-x-1/2 z-[9999] px-6 py-3 rounded-lg text-sm font-semibold text-white shadow-lg ${color[type]}`;
  t.innerText = msg;
  t.classList.remove('hidden');
  setTimeout(() => t.style.opacity = '1', 100);
  setTimeout(() => { t.style.opacity = '0'; setTimeout(() => t.classList.add('hidden'), 500) }, 2500);
}

// ===== REFRESH TABLE TANPA RELOAD =====
async function refreshTable() {
  const fd = new FormData();
  fd.append('action', 'get_table');
  const res = await fetch('', { method: 'POST', body: fd });
  const data = await res.json();
  document.getElementById('pengumumanList').innerHTML = data.html;
}

// ===== TAMBAH / UPDATE =====
document.getElementById('formPengumuman').addEventListener('submit', async e => {
  e.preventDefault();
  const fd = new FormData(e.target);
  fd.append('action', isEditing ? 'edit' : 'add');
  const res = await fetch('', { method: 'POST', body: fd });
  const data = await res.json();
  showToast(data.message, data.success ? 'success' : 'warning');
  if (data.success) {
    refreshTable();
    e.target.reset();
    document.getElementById('btnSubmit').innerText = 'Simpan Pengumuman';
    isEditing = false;
  }
});

// ===== EDIT =====
function editPengumuman(r) {
  document.getElementById('editId').value = r.id;
  document.getElementById('judul').value = r.title;
  document.getElementById('isi').value = r.content;
  document.getElementById('tanggal').value = r.event_date.replace(' ', 'T');
  document.getElementById('remind_before').value = r.remind_before;
  document.getElementById('status').value = r.status;
  document.getElementById('btnSubmit').innerText = 'Perbarui Pengumuman';
  isEditing = true;
  showToast('Mode edit aktif', 'info');
}

// ===== HAPUS =====
function deletePengumuman(id) {
  deleteId = id;
  const m = document.getElementById('confirmModal');
  const box = document.getElementById('modalBox');
  m.classList.remove('hidden');
  setTimeout(() => { box.style.opacity = '1'; box.style.transform = 'scale(1)'; }, 50);
}

document.getElementById('confirmNo').onclick = () => {
  const m = document.getElementById('confirmModal');
  const box = document.getElementById('modalBox');
  box.style.opacity = '0'; box.style.transform = 'scale(0.9)';
  setTimeout(() => m.classList.add('hidden'), 250);
  deleteId = null;
};

document.getElementById('confirmYes').onclick = async () => {
  if (!deleteId) return;
  const fd = new FormData();
  fd.append('action', 'delete');
  fd.append('id', deleteId);
  const res = await fetch('', { method: 'POST', body: fd });
  const data = await res.json();
  document.getElementById('confirmModal').classList.add('hidden');
  showToast(data.message, data.success ? 'success' : 'error');
  if (data.success) refreshTable();
};

function openAnnouncement(id) {
  const row = document.querySelector(`[data-id='${id}']`);
  if (!row) {
    showToast("Pengumuman tidak ditemukan", "warning");
    return;
  }
  row.scrollIntoView({ behavior: "smooth", block: "center" });
  row.classList.add("bg-[#2a3b5f]");
  setTimeout(() => row.classList.remove("bg-[#2a3b5f]"), 2000);
}
</script>

<?php
$content = ob_get_clean();
include __DIR__ . '/../../inc/layout.php';
?>
