<?php
// file: modules/pengumuman/pengumuman_table.php
$data = $conn->query("SELECT * FROM announcements ORDER BY event_date DESC");
?>

<table class="w-full text-sm text-gray-300">
  <thead class="text-[#8CE0FF]">
    <tr>
      <th class="py-2 text-left">#</th>
      <th class="py-2 text-left">Judul</th>
      <th class="py-2 text-left">Tanggal & Waktu</th>
      <th class="py-2 text-left">Status</th>
      <th class="py-2 text-center">Aksi</th>
    </tr>
  </thead>
  <tbody>
    <?php $no = 1; while ($r = $data->fetch_assoc()): ?>
      <tr data-id="<?= $r['id'] ?>" class="border-t border-[#1E2B44] hover:bg-[#1B253A] transition-all duration-300">
      <td class="py-2 px-2"><?= $no++ ?></td>
      <td class="py-2 px-2"><?= htmlspecialchars($r['title']) ?></td>
      <td class="py-2 px-2"><?= date('d/m/Y H:i', strtotime($r['event_date'])) ?></td>
      <td class="py-2 px-2">
        <?php if ($r['status'] === 'Aktif'): ?>
          <span class="bg-emerald-600/20 text-emerald-400 px-3 py-1 rounded-full text-xs font-semibold">Aktif</span>
        <?php else: ?>
          <span class="bg-gray-600/30 text-gray-400 px-3 py-1 rounded-full text-xs font-semibold">Nonaktif</span>
        <?php endif; ?>
      </td>
      <td class="py-2 text-center flex justify-center gap-3">
        <button onclick='editPengumuman(<?= json_encode($r) ?>)'
          class="text-[#8CE0FF] hover:text-sky-400 transition">
          <i class="fa-solid fa-pen-to-square"></i>
        </button>
        <button onclick="deletePengumuman(<?= $r['id'] ?>)"
          class="text-red-400 hover:text-red-500 transition">
          <i class="fa-solid fa-trash"></i>
        </button>
      </td>
    </tr>
    <?php endwhile; ?>
  </tbody>
</table>
