<?php
require __DIR__ . '/../../inc/db.php';
date_default_timezone_set('Asia/Jakarta');

$token = $_GET['token'] ?? '';

// Validasi token QR
$q = $conn->query("
 SELECT q.*, c.name AS class_name
FROM attendance_qr q
LEFT JOIN classes c ON c.id = q.class_id
WHERE q.qr_token = '$token'

");

$qr = $q->fetch_assoc();
$is_event = ($qr['qr_type'] === 'event');


if (!$qr) {
    die("<h2 style='color:red;text-align:center;margin-top:100px;'>❌ QR tidak valid.</h2>");
}

$now = time();
if ($now < strtotime($qr['start_date']) || $now > strtotime($qr['end_date'])) {
  $isExpired = $now > strtotime($qr['end_date']);
  $statusText = $isExpired ? "QR Sudah Kadaluarsa" : "QR Belum Aktif";
  $descText = $isExpired
    ? "Masa berlaku QR ini telah berakhir. Silakan hubungi guru/pengajar untuk mendapatkan QR baru."
    : "QR ini belum aktif. Silakan coba kembali setelah waktu mulai yang ditentukan.";
  $icon = $isExpired ? "⚠️" : "⏳";

  die('
  <!DOCTYPE html>
  <html lang="id">
  <head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>'.$statusText.'</title>
    <link href="https://cdn.jsdelivr.net/npm/tailwindcss@2.2.19/dist/tailwind.min.css" rel="stylesheet">
    <style>
body {
  background: linear-gradient(160deg, #0b1120 0%, #0f172a 60%, #1e293b 100%);
  color: #dbeafe;
  font-family: "Inter", sans-serif;
  display: flex;
  flex-direction: column;
  min-height: 100vh;
  overflow-x: hidden;
  overflow-y: auto;
}


      @keyframes fadeIn { from { opacity: 0; transform: translateY(20px);} to {opacity: 1; transform: translateY(0);} }
      @keyframes glow {
        0%,100% { box-shadow: 0 0 10px rgba(140,224,255,0.3);}
        50% { box-shadow: 0 0 25px rgba(140,224,255,0.6);}
      }
      .animate-fadeIn{animation:fadeIn .6s ease-in-out forwards}
      .animate-glow{animation:glow 2.5s infinite ease-in-out}
    </style>
  </head>
  <body class="px-4">

    <main class="flex flex-col items-center justify-center flex-grow py-10">
      <div class="text-center max-w-md w-full bg-[#1e293b]/70 backdrop-blur-xl rounded-2xl p-8 shadow-2xl border border-[#334155] animate-fadeIn animate-glow">
        <div class="text-6xl mb-4">'.$icon.'</div>
        <h1 class="text-2xl font-bold mb-2 text-blue-400">'.$statusText.'</h1>
        <p class="text-gray-300 text-sm mb-5 leading-relaxed">'.$descText.'</p>
        <div class="bg-[#0f172a]/80 text-xs text-gray-400 px-4 py-3 rounded-lg border border-[#1E2B44]">
          <p><span class="font-semibold text-blue-400">Mulai aktif:</span> '.date('d M Y H:i', strtotime($qr['start_date'])).'</p>
          <p><span class="font-semibold text-blue-400">Berakhir:</span> '.date('d M Y H:i', strtotime($qr['end_date'])).'</p>
        </div>
        <a href="/" class="inline-block mt-6 bg-gradient-to-r from-blue-600 to-blue-800 hover:from-blue-500 hover:to-blue-700 text-white px-6 py-2.5 rounded-lg font-medium shadow-md transition-all duration-300">
          🔄 Kembali ke Beranda
        </a>
      </div>
    </main>

    <footer class="border-t border-[#1E2B44] bg-[#0b1223]/95 backdrop-blur-md text-center text-gray-500 text-xs py-3 w-full animate-fadeIn fixed bottom-0 left-0">
      © '.date('Y').' <span class="text-[#8CE0FF] font-medium">System Absent</span>. All rights reserved.
    </footer>
  ');
}

$class_id   = (int)$qr['class_id'];
$class_name = htmlspecialchars($qr['class_name'], ENT_QUOTES, 'UTF-8');

$tanggal_hari_ini = date('Y-m-d');

if ($is_event) {
  // EVENT → jangan load siswa dulu
  $siswa = false;
  $class_name = 'Event (Semua Kelas)';
} else {
  // RUTIN → load siswa seperti biasa
  $class_id   = (int)$qr['class_id'];
  $class_name = htmlspecialchars($qr['class_name'], ENT_QUOTES, 'UTF-8');

  $siswa = $conn->query("
    SELECT 
      s.id, 
      s.name,
      (
        SELECT ad.status 
        FROM attendance_daily ad 
        WHERE ad.student_id = s.id 
          AND ad.tanggal = '$tanggal_hari_ini'
        LIMIT 1
      ) AS status_today
    FROM students s
    WHERE s.class_id = $class_id
    ORDER BY s.name
  ");
}

?>
<!DOCTYPE html>
<html lang="id">
<head>
<meta charset="UTF-8">
<meta name="viewport" content="width=device-width, initial-scale=1.0">
<title>Absensi Kelas <?= $class_name ?></title>
<link href="https://cdn.jsdelivr.net/npm/tailwindcss@2.2.19/dist/tailwind.min.css" rel="stylesheet">
<style>
body {
  background: linear-gradient(160deg, #0b1120 0%, #0f172a 60%, #1e293b 100%);
  color: #dbeafe;
  font-family: "Inter", sans-serif;
  display: flex;
  flex-direction: column;
  min-height: 100vh;
  overflow-x: hidden;
  overflow-y: auto;
}


main {
  flex-grow: 1;
  display: flex;
  flex-direction: column;
  justify-content: flex-start;
  align-items: center;
  padding: 1.25rem 1rem 6.5rem; 
}

  select,
  input {
    font-size: 15px;
  }

  @keyframes fadeIn {
    from { opacity: 0; transform: scale(0.95); }
    to   { opacity: 1; transform: scale(1); }
  }
  .animate-fadeIn { animation: fadeIn 0.25s ease-out forwards; }

  @keyframes slideUp {
    from { opacity: 0; transform: translateY(20px); }
    to   { opacity: 1; transform: translateY(0); }
  }
  .animate-slideUp { animation: slideUp 0.25s ease-out forwards; }

  @keyframes glow {
    0%, 100% { box-shadow: 0 0 10px rgba(140, 224, 255, 0.2); }
    50%      { box-shadow: 0 0 25px rgba(140, 224, 255, 0.5); }
  }

  /* Tombol Laporkan */
#reportButton {
  position: fixed;
  bottom: 6rem;           /* sebelumnya 3.25rem */
  right: 1.5rem;
  backdrop-filter: blur(6px);
  box-shadow: 0 4px 16px rgba(250, 204, 21, 0.25);
  z-index: 1000;
}

  #reportButton:hover {
    box-shadow: 0 6px 20px rgba(250, 204, 21, 0.4);
    transform: translateY(-3px);
  }

  /* Field di modal laporan */
  #reportModal input,
  #reportModal textarea {
    background: #ffffff !important;
    color: #000000 !important;
    -webkit-text-fill-color: #000000;
    border: 1px solid #475569;
    border-radius: 8px;
  }
  #reportModal input::placeholder,
  #reportModal textarea::placeholder {
    color: #555 !important;
  }
  #reportModal input:focus,
  #reportModal textarea:focus {
    outline: none;
    border-color: #facc15;
    box-shadow: 0 0 0 2px rgba(250, 204, 21, 0.3);
  }

  /* Gaya item siswa */
  .student-item {
    position: relative;
    border-radius: 9999px;
    background: rgba(15, 23, 42, 0.9);
    border: 1px solid rgba(148, 163, 184, 0.45);
    transition: all 0.16s ease-out;
  }
  .student-item::before {
    content: "";
    position: absolute;
    left: 12px;
    width: 9px;
    height: 9px;
    border-radius: 9999px;
    background: #38bdf8;
    opacity: 0.7;
  }
  .student-item span.student-name {
    padding-left: 0.75rem;
  }
  .student-item:hover {
    border-color: #38bdf8;
    background: radial-gradient(circle at top left, rgba(56,189,248,0.18), rgba(15,23,42,0.98));
    transform: translateY(-1px);
  }
  .student-item.selected {
    background: radial-gradient(circle at top left, rgba(56,189,248,0.28), rgba(15,23,42,0.98));
    border-color: #38bdf8;
    box-shadow: 0 0 0 1px rgba(56,189,248,0.6);
  }
  
    .student-item.already-absen {
    opacity: 0.6;
    cursor: not-allowed;
    background: rgba(15,23,42,0.7);
  }
  .student-item.already-absen:hover {
    transform: none;
    border-color: rgba(148, 163, 184, 0.6);
  }
  .student-item.already-absen::before {
    background: #22c55e; /* titik di kiri jadi hijau */
  }


  /* Icon ceklis */
  .check-icon {
    opacity: 0;
    transform: scale(0.9);
    transition: opacity 0.15s ease-out, transform 0.15s ease-out;
  }
  .student-item.selected .check-icon {
    opacity: 1;
    transform: scale(1);
  }

  /* TOAST TOP CENTER */
  #toast {
    position: fixed;
    top: 0.75rem;
    left: 50%;
    transform: translate(-50%, -18px);
    z-index: 1500;

    width: min(92%, 430px);

    opacity: 0;
    pointer-events: none;
    transition: opacity 0.25s ease-out, transform 0.25s ease-out;
  }
  #toastInner {
    display: flex;
    align-items: center;
    gap: 0.65rem;
    padding: 0.75rem 1rem;
    border-radius: 9999px;
    background: rgba(15, 23, 42, 0.96);
    border: 1px solid rgba(148, 163, 184, 0.65);
    box-shadow: 0 18px 45px rgba(15, 23, 42, 0.9);
    backdrop-filter: blur(14px);
    font-size: 0.85rem;
  }
  #toastIcon {
    width: 30px;
    height: 30px;
    border-radius: 9999px;
    display: flex;
    align-items: center;
    justify-content: center;
    font-size: 18px;
    background: rgba(15,23,42,0.9);
  }
  #toast.show {
    opacity: 1;
    transform: translate(-50%, 0);
    pointer-events: auto;
  }
</style>
</head>
<body>

  <main class="animate-fadeIn">
    <div class="bg-[#1e293b] p-6 rounded-2xl shadow-2xl w-full max-w-md form-card border border-[#334155] animate-glow">
        <h2 class="text-xl font-bold text-center text-blue-400">
  <?php if ($is_event): ?>
    📋 Absensi Kegiatan: <?= htmlspecialchars($qr['event_name']) ?>
  <?php else: ?>
    📋 Absensi Kelas <?= $class_name ?>
  <?php endif; ?>
</h2>


         <!-- FORM ABSENSI -->
      <form id="absenForm" method="POST" class="space-y-4">
          <?php if ($is_event): ?>
  <div>
    <label class="text-sm text-blue-300">Pilih Kelas</label>
    <select id="eventClassSelect"
            class="mt-1 w-full bg-white text-black text-sm rounded-lg px-3 py-2"
            required>
      <option value="">-- Pilih Kelas --</option>
      <?php
      $kc = $conn->query("SELECT id, name FROM classes ORDER BY name");
      while ($r = $kc->fetch_assoc()) {
        echo "<option value='{$r['id']}'>{$r['name']}</option>";
      }
      ?>
    </select>
  </div>
<?php endif; ?>

        <input type="hidden" id="tokenField" name="token" value="<?= htmlspecialchars($token, ENT_QUOTES, 'UTF-8') ?>">

      <!-- MULTI SELECT SISWA -->
<div>
  <label class="text-sm text-blue-300">
    Pilih Siswa (bisa lebih dari satu)
  </label>

  <div id="studentList" class="mt-2 space-y-2 max-h-64 overflow-y-auto pr-1">

    <?php if ($is_event): ?>
      <!-- MODE EVENT -->
      <p class="text-sm text-gray-400 text-center">
        Pilih kelas terlebih dahulu untuk menampilkan daftar siswa.
      </p>

    <?php else: ?>
      <!-- MODE RUTIN -->
      <?php while ($s = $siswa->fetch_assoc()):
        $status_today = $s['status_today'] ?? null;
        $already = !empty($status_today);
      ?>
        <button
          type="button"
          class="student-item w-full flex items-center justify-between px-4 py-2
                 hover:bg-[#020617] transition-all duration-150 text-left select-none
                 <?= $already ? 'already-absen' : '' ?>"
          data-already="<?= $already ? '1' : '0'; ?>"
          <?= $already ? 'disabled' : '' ?>
        >
          <span class="text-sm student-name">
            <?= htmlspecialchars($s['name']) ?>
          </span>
          <div class="flex items-center gap-2">
            <?php if ($already): ?>
              <span class="text-[11px] px-2 py-0.5 rounded-full 
                           bg-emerald-500/10 text-emerald-300 
                           border border-emerald-400/40 whitespace-nowrap">
                <?= htmlspecialchars($status_today) ?>
              </span>
            <?php else: ?>
              <span class="check-icon text-green-400 text-lg">✔</span>
            <?php endif; ?>
          </div>
          <input type="hidden" class="student-id" value="<?= $s['id'] ?>">
        </button>
      <?php endwhile; ?>
    <?php endif; ?>

  </div>
</div>


        <!-- NAMA BARU (OPSIONAL) -->
    <!-- NAMA BARU (POPUP) -->
<div class="pt-2 border-t border-[#334155]/60 mt-3">
  <button
    type="button"
    onclick="openNewNameModal()"
    class="text-xs text-blue-300 hover:text-blue-200 underline">
    + Nama belum ada di daftar?
  </button>
</div>
  <!-- STATUS ABSENSI -->
          <div class="mt-3">
            <label for="statusField" class="text-sm text-blue-300">Status Absensi:</label>
            <select id="statusField"
                    class="mt-1 w-full bg-white text-black text-sm rounded-lg px-3 py-2
                           focus:outline-none focus:ring-2 focus:ring-blue-400">
              <option value="Hadir">Hadir</option>
              <option value="Izin">Izin</option>
              <option value="Sakit">Sakit</option>
            </select>
          </div>

        <button type="submit" class="bg-gradient-to-r from-blue-600 to-blue-800 hover:from-blue-500 hover:to-blue-700 w-full py-2 rounded-xl font-semibold text-white transition-all duration-300">
          ✅ Kirim Absensi
        </button>
      </form>
      <div class="mt-4 text-center text-[11px] text-gray-400 leading-snug">
  <span class="opacity-80">QR berlaku hingga</span><br>
  <span id="endTimeText" class="text-[#fbbf24] font-medium"></span>
</div>

    </div>
    


  </main>

  <!-- TOMBOL LAPORKAN -->
  <button id="reportButton" type="button" onclick="openReportModal()"
    class="fixed bottom-6 right-6 flex items-center gap-2 bg-gradient-to-r from-yellow-500 to-amber-400 
    hover:from-yellow-400 hover:to-amber-300 text-[#0f172a] font-semibold rounded-full 
    px-5 py-3 shadow-lg shadow-yellow-600/30 hover:scale-105 transition-all duration-300 
    border border-yellow-500/50 z-[1000]">
    <span class="text-lg">⚠️</span>
    <span class="font-medium tracking-wide">Laporkan</span>
  </button>

  <!-- MODAL LAPORAN -->
  <div id="reportModal"
    class="hidden fixed inset-0 z-[2000] flex items-center justify-center sm:justify-end sm:items-center sm:pr-[5vw]"
    style="background: rgba(0,0,0,0.85) !important; backdrop-filter:none !important;">

    <div class="modal-card w-[92%] max-w-[520px]
                rounded-2xl
                bg-gradient-to-b from-[#1b2437] to-[#0f172a]
                text-[#E2E8F0] shadow-2xl border border-[#334155]/60
                animate-slideUp sm:animate-fadeIn">

      <div class="flex items-center justify-between px-5 py-3 border-b border-[#334155]/60">
        <div>
          <h2 class="text-lg font-semibold text-yellow-400">Laporkan jika ada kendala</h2>
          <p class="text-[11px] text-gray-400">Kesalahan nama, absensi tidak tercatat, atau kendala teknis.</p>
        </div>
        <button aria-label="Tutup" onclick="closeReportModal()" class="ml-3 text-gray-400 hover:text-yellow-400 text-xl leading-none">×</button>
      </div>

      <div class="px-5 pt-3 pb-4 space-y-3">
        <div>
          <label class="block text-[12px] font-medium text-[#EFDCA6] mb-1">Nama Pelapor</label>
          <input id="reportName" type="text"
            class="w-full p-2.5 rounded-lg border border-[#475569]
                   focus:ring-2 focus:ring-yellow-400 outline-none placeholder-gray-500"
            placeholder="Masukkan nama Anda">
        </div>

        <div>
          <label class="block text-[12px] font-medium text-[#EFDCA6] mb-1">Isi Laporan</label>
          <textarea id="reportMessage" rows="3"
            class="w-full p-2.5 rounded-lg border border-[#475569]
                   focus:ring-2 focus:ring-yellow-400 outline-none placeholder-gray-500 resize-none"
            placeholder="Tuliskan kendala atau pesan untuk admin..."></textarea>
        </div>

        <div class="flex justify-end gap-3 pt-3 border-t border-[#334155]/60">
          <button onclick="closeReportModal()"
                  class="px-4 py-2 rounded-lg bg-gray-600/80 text-white text-sm font-medium hover:bg-gray-500">Batal</button>
          <button onclick="sendReport()"
                  class="px-5 py-2 rounded-lg font-semibold bg-yellow-400 text-[#0f172a] hover:bg-yellow-300 shadow-md">Kirim</button>
        </div>
      </div>
    </div>
  </div>

  <!-- MODAL NAMA BARU -->
  <div id="newNameModal"
       class="hidden fixed inset-0 z-[1900] flex items-center justify-center px-4"
       style="background: rgba(0,0,0,0.8);">
    <div class="w-full max-w-md rounded-2xl
                bg-gradient-to-b from-[#1b2437] to-[#020617]
                border border-[#334155]/70 shadow-2xl
                animate-slideUp">
      <div class="flex items-center justify-between px-5 py-3 border-b border-[#334155]/60">
        <div>
          <h2 class="text-base font-semibold text-blue-300">Tambah nama baru</h2>
          <p class="text-[11px] text-gray-400">
            Nama yang ditambahkan akan langsung dicatat dengan status absensi yang dipilih.
          </p>
        </div>
        <button type="button"
                onclick="closeNewNameModal()"
                class="text-gray-400 hover:text-blue-300 text-xl leading-none">
          ×
        </button>
      </div>

      <div class="px-5 pt-3 pb-4 space-y-3">
        <div>
          <label class="block text-[12px] font-medium text-blue-200 mb-1">Nama Baru</label>
          <input id="newNameInput" type="text"
                 class="w-full p-2.5 rounded-lg border border-[#475569]
                        bg-white text-black placeholder-gray-500
                        focus:outline-none focus:ring-2 focus:ring-blue-400"
                 placeholder="Masukkan nama siswa">
        </div>

        <div>
          <label class="block text-[12px] font-medium text-blue-200 mb-1">Status Absensi</label>
          <select id="newNameStatus"
                  class="w-full p-2.5 rounded-lg border border-[#475569]
                         bg-white text-black text-sm
                         focus:outline-none focus:ring-2 focus:ring-blue-400">
            <option value="Hadir">Hadir</option>
            <option value="Izin">Izin</option>
            <option value="Sakit">Sakit</option>
          </select>
        </div>

        <div class="flex justify-end gap-3 pt-3 border-t border-[#334155]/60">
          <button type="button"
                  onclick="closeNewNameModal()"
                  class="px-4 py-2 rounded-lg bg-gray-600/80 text-white text-xs font-medium hover:bg-gray-500">
            Batal
          </button>
          <button type="button"
                  onclick="sendNewName()"
                  class="px-5 py-2 rounded-lg bg-blue-500 text-white text-xs font-semibold hover:bg-blue-400 shadow-md">
            Simpan &amp; Catat
          </button>
        </div>
      </div>
    </div>
  </div>

  <footer class="border-t border-[#1E2B44] bg-[#0b1223]/95 backdrop-blur-md text-center text-gray-500 text-xs py-3 w-full fixed bottom-0 left-0 animate-fadeIn">
    © <?= date('Y') ?> <span class="text-[#8CE0FF] font-medium">System Absent</span>. All rights reserved.
  </footer>

  <!-- TOAST -->
  <div id="toast">
    <div id="toastInner">
      <div id="toastIcon">✓</div>
      <div class="flex-1">
        <p id="toastTitle" class="font-semibold text-slate-50 mb-0.5">Info</p>
        <p id="toastText" class="text-slate-200 text-[12px]"></p>
      </div>
    </div>
  </div>
  
<?php if ($is_event): ?>
<script>
const classSelect = document.getElementById('eventClassSelect');
const studentList = document.getElementById('studentList');

function bindStudentClick() {
  document.querySelectorAll('.student-item').forEach(item => {
    item.onclick = () => {
      if (item.dataset.already === '1') return;
      item.classList.toggle('selected');
    };
  });
}

classSelect.addEventListener('change', async () => {
  const classId = classSelect.value;
  if (!classId) return;

  studentList.innerHTML =
    '<p class="text-sm text-gray-400 text-center">Memuat siswa...</p>';

  const res = await fetch(
    `/system-absent/modules/qr_absen/load_students.php?class_id=${classId}`
  );

  const html = await res.text();
  studentList.innerHTML = html;

  // 🔥 INI WAJIB
  bindStudentClick();
});
</script>
<?php endif; ?>




  <script>
    // ===== TOAST =====
    let toastTimer;
    function showToast(type, title, message) {
      const toast    = document.getElementById('toast');
      const iconBox  = document.getElementById('toastIcon');
      const titleEl  = document.getElementById('toastTitle');
      const textEl   = document.getElementById('toastText');
      const inner    = document.getElementById('toastInner');

      let icon = "✅";
      let grad = "linear-gradient(135deg,#16a34a,#22c55e)";
      let border = "#22c55e";

      if (type === "warning") {
        icon   = "⚠️";
        grad   = "linear-gradient(135deg,#eab308,#facc15)";
        border = "#facc15";
      } else if (type === "error") {
        icon   = "✖";
        grad   = "linear-gradient(135deg,#ef4444,#f97373)";
        border = "#f97373";
      }

      iconBox.textContent = icon;
      inner.style.background = grad;
      inner.style.borderColor = border;
      inner.style.boxShadow = "0 18px 45px rgba(15,23,42,0.9)";

      titleEl.textContent = title;
      textEl.textContent  = message;

      toast.classList.add('show');
      clearTimeout(toastTimer);
      toastTimer = setTimeout(() => {
        toast.classList.remove('show');
      }, 3500);
    }

     // ===== MULTI SELECT SISWA =====
    function markAsAlreadyAbsen(item, status) {
      // hapus highlight pilihan
      item.classList.remove('selected');

      // tandai sudah absen
      item.classList.add('already-absen');
      item.dataset.already = '1';
      item.setAttribute('disabled', 'disabled');

      // ganti icon ceklis jadi badge status
      const rightBox = item.querySelector('.flex.items-center.gap-2');
      if (rightBox) {
        rightBox.innerHTML = `
          <span class="text-[11px] px-2 py-0.5 rounded-full 
                       bg-emerald-500/10 text-emerald-300 
                       border border-emerald-400/40 whitespace-nowrap">
            ${status}
          </span>
        `;
      }
    }

 function bindStudentClick() {
  const studentItems = document.querySelectorAll('.student-item');
  studentItems.forEach(item => {
    item.onclick = () => {
      if (item.dataset.already === '1') return;
      item.classList.toggle('selected');
    };
  });
}

       document.getElementById('absenForm').addEventListener('submit', async (e) => {
      e.preventDefault();

      const token = "<?= htmlspecialchars($token, ENT_QUOTES, 'UTF-8') ?>";
      const selected = Array.from(document.querySelectorAll('.student-item.selected'));

      // Ambil nilai status dari dropdown utama
      const statusField = document.getElementById('statusField');
      const status = statusField ? statusField.value : 'Hadir';

      if (selected.length === 0) {
        showToast("warning", "Belum memilih", "Pilih minimal satu siswa terlebih dahulu.");
        return;
      }

      const baseURL = window.location.origin + "/system-absent/modules/qr_absen/submit_absen.php";

      let successCount = 0;
      let failCount = 0;
      let lastError = "";

      for (const item of selected) {
        const idInput = item.querySelector('.student-id');
        if (!idInput) continue;
        const studentId = idInput.value;

        const fd = new FormData();
        fd.append('token', token);
        fd.append('student_id', studentId);
        fd.append('status', status);
        <?php if ($is_event): ?>
fd.append('class_id', document.getElementById('eventClassSelect').value);
<?php endif; ?>


        try {
          const res  = await fetch(baseURL, { method: "POST", body: fd });
          const data = await res.json();
          if (data.success) {
            successCount++;
            markAsAlreadyAbsen(item, status);
          } else {
            failCount++;
            lastError = data.message || "Gagal mengirim absensi untuk salah satu siswa.";
          }
        } catch (err) {
          failCount++;
          lastError = err.message;
        }
      }

      if (successCount && !failCount) {
        showToast("success", "Berhasil", `Berhasil mengirim absensi untuk ${successCount} data.`);
      } else if (successCount && failCount) {
        showToast("warning", "Sebagian berhasil", `Berhasil: ${successCount}, Gagal: ${failCount}. ${lastError}`);
      } else {
        showToast("error", "Gagal", lastError || "Gagal mengirim absensi.");
      }

      if (successCount) {
        selected.forEach(item => item.classList.remove('selected'));
      }
    });



    // ===== POPUP NAMA BARU =====
    function openNewNameModal() {
      const modal       = document.getElementById('newNameModal');
      const input       = document.getElementById('newNameInput');
      const statusField = document.getElementById('statusField');
      const newStatus   = document.getElementById('newNameStatus');

      // sync status popup dengan dropdown utama
      if (statusField && newStatus) {
        newStatus.value = statusField.value;
      }

      if (modal) {
        modal.classList.remove('hidden');
      }
      document.body.style.overflow = 'hidden';

      // fokus ke input
      setTimeout(() => {
        if (input) input.focus();
      }, 50);
    }

    function closeNewNameModal() {
      const modal = document.getElementById('newNameModal');
      const input = document.getElementById('newNameInput');
      if (modal) {
        modal.classList.add('hidden');
      }
      document.body.style.overflow = '';
      if (input) input.value = '';
    }

    window.openNewNameModal  = openNewNameModal;
    window.closeNewNameModal = closeNewNameModal;

    async function sendNewName() {
      const input       = document.getElementById('newNameInput');
      const statusSelect= document.getElementById('newNameStatus');
      const name        = input.value.trim();
      const status      = statusSelect.value;

      if (!name) {
        showToast("warning", "Nama belum diisi", "Masukkan nama siswa terlebih dahulu.");
        input.focus();
        return;
      }

      const token   = "<?= htmlspecialchars($token, ENT_QUOTES, 'UTF-8') ?>";
      const baseURL = window.location.origin + "/system-absent/modules/qr_absen/submit_absen.php";

      const fd = new FormData();
      fd.append('token', token);
      fd.append('new_name', name);
      fd.append('status', status);
      // 🔥 AUTO BACA KELAS SAAT EVENT
const classSelect = document.getElementById('eventClassSelect');
if (classSelect && classSelect.value) {
  fd.append('class_id', classSelect.value);
}


      try {
        const res  = await fetch(baseURL, { method: "POST", body: fd });
        const data = await res.json();

              if (data.success) {
        showToast("success", "Nama ditambahkan",
          data.message || `Nama ${name} sudah ditambahkan dan dicatat ${status}.`);
        closeNewNameModal();

        // SELALU tambahkan ke list di UI (tanpa reload)
        const list = document.getElementById('studentList');
        if (list) {
          const btn = document.createElement('button');
          btn.type = "button";
          btn.className =
            "student-item already-absen w-full flex items-center justify-between px-4 py-2 " +
            "hover:bg-[#020617] transition-all duration-150 text-left select-none";
          btn.dataset.already = "1";
          btn.disabled = true;

          const newId = data.new_student_id || ""; // kalau backend belum kirim ID, kosong juga nggak apa2 karena sudah disabled

          btn.innerHTML = `
            <span class="text-sm student-name">${name}</span>
            <div class="flex items-center gap-2">
              <span class="text-[11px] px-2 py-0.5 rounded-full 
                           bg-emerald-500/10 text-emerald-300 
                           border border-emerald-400/40 whitespace-nowrap">
                ${status}
              </span>
            </div>
            <input type="hidden" class="student-id" value="${newId}">
          `;

          list.appendChild(btn);
        }
      } else {
        showToast("error", "Gagal", data.message || "Nama baru gagal disimpan.");
      }

      } catch (err) {
        showToast("error", "Gagal", err.message || "Terjadi kesalahan jaringan.");
      }
    }

    window.sendNewName = sendNewName;


     // ===== INFO BATAS WAKTU QR (tanpa countdown) =====
const endTimeText = document.getElementById("endTimeText");

if (endTimeText) {
  const endDate = new Date("<?= $qr['end_date'] ?>");
  const now     = new Date();

  if (endDate <= now) {
    // Secara teori halaman ini tidak muncul kalau sudah kadaluarsa,
    // tapi jaga-jaga saja.
    endTimeText.textContent = "QR sudah kadaluarsa";
  } else {
    const endStr = endDate.toLocaleString("id-ID", {
      weekday: "long",
      day: "numeric",
      month: "long",
      year: "numeric",
      hour: "2-digit",
      minute: "2-digit"
    });
    endTimeText.textContent = endStr;
  }
}

    // ===== LAPORAN =====
    async function sendReport() {
      const name = document.getElementById("reportName").value.trim();
      const msg  = document.getElementById("reportMessage").value.trim();

      if (!name || !msg) {
        showToast("warning", "Lengkapi data", "Nama dan isi laporan wajib diisi.");
        return;
      }

      const baseURL = window.location.origin + "/system-absent/modules/qr_absen/report_nama.php";
      const formData = new FormData();
      formData.append("token", "<?= htmlspecialchars($token, ENT_QUOTES, 'UTF-8') ?>");
      formData.append("name", name);
      formData.append("message", msg);

      try {
        const res  = await fetch(baseURL, { method: "POST", body: formData });
        const data = await res.json();

        if (data.success) {
          showToast("success", "Laporan terkirim", data.message || "Terima kasih, laporan sudah dikirim.");
          document.getElementById("reportName").value = "";
          document.getElementById("reportMessage").value = "";
          closeReportModal();
        } else {
          showToast("error", "Gagal kirim", data.message || "Laporan gagal dikirim.");
        }
      } catch (err) {
        showToast("error", "Gagal kirim", err.message || "Terjadi kesalahan jaringan.");
      }
    }
    window.sendReport = sendReport;

    function openReportModal() {
      const modal = document.getElementById('reportModal');
      const btn   = document.getElementById('reportButton');
      modal.classList.remove('hidden');
      btn.classList.add('hidden');
      document.body.style.overflow = 'hidden';
    }
    function closeReportModal() {
      const modal = document.getElementById('reportModal');
      const btn   = document.getElementById('reportButton');
      modal.classList.add('hidden');
      btn.classList.remove('hidden');
      document.body.style.overflow = '';
    }
    window.openReportModal  = openReportModal;
    window.closeReportModal = closeReportModal;

    // Klik area gelap untuk tutup modal
    document.getElementById('reportModal').addEventListener('click', (e) => {
      if (e.target.id === 'reportModal') closeReportModal();
    });

    // ESC untuk tutup modal
    document.addEventListener('keydown', (e) => {
      if (e.key === 'Escape' && !document.getElementById('reportModal').classList.contains('hidden')) {
        closeReportModal();
      }
    });

  </script>

</body>
</html>
