<?php
// modules/qr_absen/daftar_token.php
// TIDAK BOLEH ADA SPASI/BOM DI ATAS PHP INI

require __DIR__ . '/../../inc/auth.php';
require __DIR__ . '/../../inc/db.php';
date_default_timezone_set('Asia/Jakarta');

// === AMBIL DAFTAR TOKEN ===
$sql = "
  SELECT 
    q.id,
    q.qr_token,
    q.qr_type,
    q.start_date,
    q.end_date,
    q.created_at,
    c.name AS class_name
  FROM attendance_qr q
  LEFT JOIN classes c ON c.id = q.class_id
  ORDER BY q.created_at DESC
";
$tokens = $conn->query($sql);

// =======================
// KONTEN UNTUK LAYOUT
// =======================
$page_title = 'Daftar Token Absen';
ob_start();
?>

<div class="px-4 py-6 max-w-6xl mx-auto">
  <!-- Header & CTA -->
  <div class="flex flex-col sm:flex-row sm:items-center sm:justify-between gap-3 mb-4">
    <div>
      <h1 class="text-xl sm:text-2xl font-semibold text-blue-400 flex items-center gap-2">
        <span>📇</span> Daftar Token Absen
      </h1>
      <p class="text-sm text-slate-400 mt-1">
        Token absensi rutin & event yang sudah dibuat. Kelola masa berlaku dan penghapusan dari halaman ini.
      </p>
    </div>

    <a href="generate_token_rutin.php"
       class="inline-flex items-center gap-2 rounded-lg bg-blue-600 hover:bg-blue-500 text-white text-sm font-medium px-4 py-2 shadow">
      ➕ Generate Token Rutin
    </a>
  </div>

  <!-- Container toast (notif) -->
  <div id="toastContainer"
       class="fixed top-4 left-1/2 -translate-x-1/2 z-40 w-full max-w-xl px-4 pointer-events-none">
  </div>

  <!-- Card tabel -->
  <div class="rounded-2xl border border-slate-800 bg-slate-900/70 overflow-hidden shadow">
    <div class="px-4 py-3 border-b border-slate-800 flex items-center justify-between">
      <span class="text-sm font-medium text-slate-200">Token Aktif & Riwayat</span>
      <span class="text-[11px] text-slate-500">
        Total: <?= $tokens ? $tokens->num_rows : 0 ?> token
      </span>
    </div>

    <div class="overflow-x-auto">
      <table class="min-w-full text-sm text-slate-200">
        <thead class="bg-slate-900/90 border-b border-slate-800">
          <tr>
            <th class="px-4 py-2 text-left text-xs font-semibold text-slate-400 uppercase tracking-wide">No</th>
            <th class="px-4 py-2 text-left text-xs font-semibold text-slate-400 uppercase tracking-wide">Kelas</th>
            <th class="px-4 py-2 text-left text-xs font-semibold text-slate-400 uppercase tracking-wide">Token</th>
            <th class="px-4 py-2 text-left text-xs font-semibold text-slate-400 uppercase tracking-wide">QR Type</th>
            <th class="px-4 py-2 text-left text-xs font-semibold text-slate-400 uppercase tracking-wide">Masa Kadaluarsa</th>
            <th class="px-4 py-2 text-right text-xs font-semibold text-slate-400 uppercase tracking-wide">Aksi</th>
          </tr>
        </thead>
        <tbody class="divide-y divide-slate-800">
        <?php
        $no = 1;
        if ($tokens && $tokens->num_rows):
          $now = time();
          while ($row = $tokens->fetch_assoc()):
              $start_ts = $row['start_date'] ? strtotime($row['start_date']) : null;
              $end_ts   = $row['end_date']   ? strtotime($row['end_date'])   : null;

              $start_str = $start_ts ? date('d/m/Y', $start_ts) : '-';
              $end_str   = $end_ts   ? date('d/m/Y', $end_ts)   : '-';

              if ($end_ts && $now > $end_ts) {
                  $status_label = 'Kadaluarsa';
                  $status_class = 'bg-red-500/10 text-red-300 border border-red-500/40';
              } else {
                  $status_label = 'Aktif';
                  $status_class = 'bg-emerald-500/10 text-emerald-300 border border-emerald-500/40';
              }

              $type = $row['qr_type'] ?: '-';
              $type_label = strtoupper($type);
              $type_class = $type === 'rutin'
                  ? 'bg-sky-500/10 text-sky-300 border border-sky-500/40'
                  : 'bg-indigo-500/10 text-indigo-300 border border-indigo-500/40';
        ?>
          <tr id="row-<?= (int)$row['id'] ?>" class="hover:bg-slate-800/40">
            <td class="px-4 py-2 align-top text-xs text-slate-400"><?= $no++ ?></td>

            <td class="px-4 py-2 align-top">
              <div class="text-sm font-medium text-slate-100">
                <?= htmlspecialchars($row['class_name'] ?: '—') ?>
              </div>
              <div class="text-[11px] text-slate-500">
                Dibuat: <?= date('d/m/Y H:i', strtotime($row['created_at'])) ?>
              </div>
            </td>

            <td class="px-4 py-2 align-top">
              <span class="inline-flex items-center px-3 py-1 rounded-lg bg-slate-900 border border-slate-700 font-mono text-xs tracking-widest">
                <?= htmlspecialchars($row['qr_token']) ?>
              </span>
            </td>

            <td class="px-4 py-2 align-top">
              <span class="inline-flex px-2.5 py-1 rounded-full text-[11px] font-medium <?= $type_class ?>">
                <?= $type_label ?>
              </span>
            </td>

            <td class="px-4 py-2 align-top cell-masa">
              <div class="text-xs text-slate-200 masa-range">
                <?= $start_str ?> &mdash; <?= $end_str ?>
              </div>
              <div class="mt-1 inline-flex px-2 py-0.5 rounded-full text-[11px] badge-status <?= $status_class ?>">
                <?= $status_label ?>
              </div>
            </td>

            <td class="px-4 py-2 align-top text-right">
              <div class="inline-flex gap-2">
                <button
                  type="button"
                  class="px-3 py-1.5 rounded-lg text-[11px] font-medium bg-sky-600 hover:bg-sky-500 text-white"
                  onclick="openExtendModal(this)"
                  data-id="<?= (int)$row['id'] ?>"
                  data-class="<?= htmlspecialchars($row['class_name'] ?: '-', ENT_QUOTES) ?>"
                  data-token="<?= htmlspecialchars($row['qr_token'], ENT_QUOTES) ?>"
                  data-end="<?= $end_ts ? date('Y-m-d', $end_ts) : '' ?>"
                >
                  Perpanjang
                </button>

                <button
                  type="button"
                  class="px-3 py-1.5 rounded-lg text-[11px] font-medium bg-red-600/90 hover:bg-red-500 text-white"
                  onclick="openDeleteModal(this)"
                  data-id="<?= (int)$row['id'] ?>"
                  data-label="<?= htmlspecialchars(($row['class_name'] ?: '-') . ' / ' . $row['qr_token'], ENT_QUOTES) ?>"
                >
                  Hapus
                </button>
              </div>
            </td>
          </tr>
        <?php
          endwhile;
        else:
        ?>
          <tr>
            <td colspan="6" class="px-4 py-6 text-center text-sm text-slate-500">
              Belum ada token yang dibuat.
            </td>
          </tr>
        <?php endif; ?>
        </tbody>
      </table>
    </div>
  </div>
</div>

<!-- MODAL PERPANJANG -->
<div id="extendModal"
     class="hidden fixed inset-0 z-40 items-center justify-center bg-black/70">
  <div class="w-full max-w-md mx-4 rounded-2xl bg-slate-900 border border-slate-700 shadow-2xl">
    <div class="px-5 py-3 border-b border-slate-800 flex items-center justify-between">
      <div>
        <h2 class="text-sm font-semibold text-slate-100">Perpanjang Masa Kadaluarsa</h2>
        <p class="text-[11px] text-slate-400" id="extendSubtitle"></p>
      </div>
      <button class="text-slate-400 hover:text-slate-200 text-lg leading-none"
              type="button"
              onclick="closeExtendModal()">&times;</button>
    </div>

    <form id="extendForm" class="px-5 py-4 space-y-3">
      <input type="hidden" name="action" value="extend">
      <input type="hidden" name="token_id" id="extendTokenId">

      <div>
        <label class="block text-xs font-medium text-slate-200 mb-1">
          Tanggal Berakhir Baru
        </label>
        <input type="date"
               name="new_end_date"
               id="extendEndDate"
               required
               class="w-full rounded-lg bg-slate-950 border border-slate-700 px-3 py-2 text-sm text-slate-100 focus:outline-none focus:ring-2 focus:ring-sky-500">
        <p class="text-[11px] text-slate-400 mt-1">
          Sistem akan menyimpan jam berakhir sebagai <strong>23:59:59</strong> di tanggal yang dipilih.
        </p>
      </div>

      <div class="flex justify-end gap-2 pt-2 border-t border-slate-800">
        <button type="button"
                class="px-3 py-1.5 rounded-lg bg-slate-700 text-xs text-slate-100 hover:bg-slate-600"
                onclick="closeExtendModal()">
          Batal
        </button>
        <button id="extendSubmitBtn" type="submit"
                class="px-4 py-1.5 rounded-lg bg-sky-600 text-xs font-semibold text-white hover:bg-sky-500">
          Simpan Perubahan
        </button>
      </div>
    </form>
  </div>
</div>

<!-- MODAL DELETE -->
<div id="deleteModal"
     class="hidden fixed inset-0 z-40 items-center justify-center bg-black/70">
  <div class="w-full max-w-md mx-4 rounded-2xl bg-slate-900 border border-slate-700 shadow-2xl">
    <div class="px-5 py-3 border-b border-slate-800 flex items-center justify-between">
      <h2 class="text-sm font-semibold text-red-300">Hapus Token</h2>
      <button class="text-slate-400 hover:text-slate-200 text-lg leading-none"
              type="button"
              onclick="closeDeleteModal()">&times;</button>
    </div>

    <form id="deleteForm" class="px-5 py-4 space-y-3">
      <input type="hidden" name="action" value="delete">
      <input type="hidden" name="token_id" id="deleteTokenId">

      <p class="text-sm text-slate-200">
        Apakah kamu yakin ingin menghapus token ini?
      </p>
      <p class="text-xs text-slate-400">
        Token: <span id="deleteTokenLabel" class="font-mono text-[11px] text-slate-200"></span>
      </p>
      <p class="text-[11px] text-amber-300 mt-1">
        Tindakan ini tidak bisa dibatalkan dan siswa tidak akan bisa menggunakan token ini lagi.
      </p>

      <div class="flex justify-end gap-2 pt-2 border-t border-slate-800">
        <button type="button"
                class="px-3 py-1.5 rounded-lg bg-slate-700 text-xs text-slate-100 hover:bg-slate-600"
                onclick="closeDeleteModal()">
          Batal
        </button>
        <button id="deleteSubmitBtn" type="submit"
                class="px-4 py-1.5 rounded-lg bg-red-600 text-xs font-semibold text-white hover:bg-red-500">
          Hapus
        </button>
      </div>
    </form>
  </div>
</div>

<script>
// ====== Toast helper (notif profesional) ======
function showToast(type, message) {
  const container = document.getElementById('toastContainer');
  if (!container) return;

  const wrapper = document.createElement('div');
  wrapper.className =
    'pointer-events-auto mb-3 transition-all duration-500 transform opacity-0 translate-y-2';

  let baseClass =
    'flex items-center gap-2 rounded-xl px-4 py-2 text-sm shadow-lg border ';

  let icon = 'ℹ️';
  if (type === 'success') {
    baseClass += 'bg-emerald-500/10 border-emerald-500/60 text-emerald-100';
    icon = '✅';
  } else if (type === 'error') {
    baseClass += 'bg-red-500/10 border-red-500/60 text-red-100';
    icon = '⚠️';
  } else if (type === 'warning') {
    baseClass += 'bg-amber-500/10 border-amber-500/60 text-amber-100';
    icon = '⚠️';
  } else {
    baseClass += 'bg-slate-700/80 border-slate-500/60 text-slate-50';
  }

  wrapper.innerHTML = `
    <div class="${baseClass}">
      <span class="text-lg">${icon}</span>
      <span class="text-[13px]">${message}</span>
    </div>
  `;

  container.appendChild(wrapper);

  requestAnimationFrame(() => {
    wrapper.classList.remove('opacity-0', 'translate-y-2');
  });

  setTimeout(() => {
    wrapper.classList.add('opacity-0', 'translate-y-2');
    wrapper.addEventListener('transitionend', () => wrapper.remove(), { once: true });
  }, 3000);
}

// ====== MODAL PERPANJANG ======
function openExtendModal(btn) {
  const id      = btn.dataset.id;
  const kelas   = btn.dataset.class || '-';
  const token   = btn.dataset.token || '';
  const endDate = btn.dataset.end  || '';

  document.getElementById('extendTokenId').value = id;
  document.getElementById('extendEndDate').value = endDate;
  document.getElementById('extendSubtitle').textContent =
    `${kelas} • Token: ${token}`;

  const modal = document.getElementById('extendModal');
  modal.classList.remove('hidden');
  modal.classList.add('flex');
  document.body.style.overflow = 'hidden';
}

function closeExtendModal() {
  const modal = document.getElementById('extendModal');
  modal.classList.add('hidden');
  modal.classList.remove('flex');
  document.body.style.overflow = '';
}

// ====== MODAL DELETE ======
function openDeleteModal(btn) {
  const id    = btn.dataset.id;
  const label = btn.dataset.label || '';

  document.getElementById('deleteTokenId').value   = id;
  document.getElementById('deleteTokenLabel').textContent = label;

  const modal = document.getElementById('deleteModal');
  modal.classList.remove('hidden');
  modal.classList.add('flex');
  document.body.style.overflow = 'hidden';
}

function closeDeleteModal() {
  const modal = document.getElementById('deleteModal');
  modal.classList.add('hidden');
  modal.classList.remove('flex');
  document.body.style.overflow = '';
}

// ====== AJAX submit: Perpanjang ======
document.getElementById('extendForm').addEventListener('submit', async function (e) {
  e.preventDefault();

  const btn   = document.getElementById('extendSubmitBtn');
  const label = btn.textContent;
  btn.disabled = true;
  btn.textContent = 'Menyimpan...';

  const formData = new FormData(this);

  try {
    const res  = await fetch('daftar_token_action.php', {
      method: 'POST',
      body: formData
    });
    const json = await res.json();

    if (!json.success) {
      showToast('error', json.message || 'Gagal memperbarui token.');
    } else {
      const d = json.data || {};
      const row = document.getElementById('row-' + d.id);
      if (row) {
        const rangeEl  = row.querySelector('.masa-range');
        const statusEl = row.querySelector('.badge-status');

        if (rangeEl) {
          rangeEl.textContent = (d.start_str || '-') + ' — ' + (d.end_str || '-');
        }
        if (statusEl) {
          statusEl.textContent = d.status_label || '';
          statusEl.className =
            'mt-1 inline-flex px-2 py-0.5 rounded-full text-[11px] badge-status ' +
            (d.status_class || '');
        }
      }

      closeExtendModal();
      showToast('Masa kadaluarsa diperbarui', json.message || 'Masa kadaluarsa berhasil diperbarui.');
    }
  } catch (err) {
    showToast('error', err.message || 'Terjadi kesalahan jaringan.');
  } finally {
    btn.disabled = false;
    btn.textContent = label;
  }
});

// ====== AJAX submit: Delete ======
document.getElementById('deleteForm').addEventListener('submit', async function (e) {
  e.preventDefault();

  const btn   = document.getElementById('deleteSubmitBtn');
  const label = btn.textContent;
  btn.disabled = true;
  btn.textContent = 'Menghapus...';

  const formData = new FormData(this);

  try {
    const res  = await fetch('daftar_token_action.php', {
      method: 'POST',
      body: formData
    });
    const json = await res.json();

    if (!json.success) {
      showToast('error', json.message || 'Gagal menghapus token.');
    } else {
      const d = json.data || {};
      const row = document.getElementById('row-' + d.id);
      if (row) row.remove();

      closeDeleteModal();
      showToast('Token berhasil dihapus', json.message || 'Token berhasil dihapus.');
    }
  } catch (err) {
    showToast('error', err.message || 'Terjadi kesalahan jaringan.');
  } finally {
    btn.disabled = false;
    btn.textContent = label;
  }
});
</script>

<?php

$content = ob_get_clean();
require __DIR__ . '/../../inc/layout.php';
