<?php

require __DIR__ . '/../../inc/auth.php';
require __DIR__ . '/../../inc/db.php';
date_default_timezone_set('Asia/Jakarta');

header('Content-Type: application/json; charset=utf-8');

if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
    echo json_encode([
        'success' => false,
        'message' => 'Metode tidak diizinkan.'
    ]);
    exit;
}

$action = $_POST['action'] ?? '';

if ($action === 'extend') {
    $token_id     = (int)($_POST['token_id'] ?? 0);
    $new_end_date = trim($_POST['new_end_date'] ?? '');

    if (!$token_id || !$new_end_date) {
        echo json_encode([
            'success' => false,
            'message' => 'ID token atau tanggal baru tidak valid.'
        ]);
        exit;
    }

    // Simpan sebagai akhir hari tsb
    $new_end_dt = $new_end_date . ' 23:59:59';

    $stmt = $conn->prepare("UPDATE attendance_qr SET end_date = ? WHERE id = ?");
    if (!$stmt) {
        echo json_encode([
            'success' => false,
            'message' => 'Gagal menyiapkan query update.'
        ]);
        exit;
    }

    $stmt->bind_param('si', $new_end_dt, $token_id);
    if (!$stmt->execute()) {
        echo json_encode([
            'success' => false,
            'message' => 'Gagal memperbarui tanggal kadaluarsa: ' . $stmt->error
        ]);
        exit;
    }

    // Ambil data baru untuk dikirim balik ke front-end
    $stmt2 = $conn->prepare("
        SELECT start_date, end_date
        FROM attendance_qr
        WHERE id = ?
        LIMIT 1
    ");
    $stmt2->bind_param('i', $token_id);
    $stmt2->execute();
    $res2 = $stmt2->get_result()->fetch_assoc();

    $start_ts = $res2['start_date'] ? strtotime($res2['start_date']) : null;
    $end_ts   = $res2['end_date']   ? strtotime($res2['end_date'])   : null;

    $start_str = $start_ts ? date('d/m/Y', $start_ts) : '-';
    $end_str   = $end_ts   ? date('d/m/Y', $end_ts)   : '-';

    // Status aktif / kadaluarsa
    $now = time();
    if ($end_ts && $now > $end_ts) {
        $status_label = 'Kadaluarsa';
        $status_class = 'bg-red-500/10 text-red-300 border border-red-500/40';
    } else {
        $status_label = 'Aktif';
        $status_class = 'bg-emerald-500/10 text-emerald-300 border border-emerald-500/40';
    }

    echo json_encode([
        'success' => true,
        'message' => 'Masa kadaluarsa token berhasil diperbarui.',
        'data'    => [
            'id'           => $token_id,
            'start_str'    => $start_str,
            'end_str'      => $end_str,
            'status_label' => $status_label,
            'status_class' => $status_class,
        ]
    ]);
    exit;
}

if ($action === 'delete') {
    $token_id = (int)($_POST['token_id'] ?? 0);

    if (!$token_id) {
        echo json_encode([
            'success' => false,
            'message' => 'ID token tidak valid.'
        ]);
        exit;
    }

    $stmt = $conn->prepare("DELETE FROM attendance_qr WHERE id = ?");
    if (!$stmt) {
        echo json_encode([
            'success' => false,
            'message' => 'Gagal menyiapkan query delete.'
        ]);
        exit;
    }

    $stmt->bind_param('i', $token_id);
    if (!$stmt->execute()) {
        echo json_encode([
            'success' => false,
            'message' => 'Gagal menghapus token: ' . $stmt->error
        ]);
        exit;
    }

    echo json_encode([
        'success' => true,
        'message' => 'Token berhasil dihapus.',
        'data'    => [
            'id' => $token_id,
        ]
    ]);
    exit;
}

// Aksi tidak dikenali
echo json_encode([
    'success' => false,
    'message' => 'Aksi tidak dikenali.'
]);
exit;
