<?php
require __DIR__ . '/../../inc/db.php';
require __DIR__ . '/../../inc/auth.php';
date_default_timezone_set('Asia/Jakarta');

$title = "Generate QR Absensi";
ob_start();
?>

<style>
/* ===================== LAYOUT ===================== */
.qrabsen-wrapper {
  display: flex;
  justify-content: center;
  align-items: center;
  min-height: calc(100vh - 120px);
  padding: 20px;
}

.form-card {
  background: #0f172a;
  border: 1px solid #1e293b;
  border-radius: 16px;
  box-shadow: 0 10px 40px rgba(0,0,0,0.6);
  width: 100%;
  max-width: 560px;
  padding: 1.75rem;
}

/* ===================== FORM ===================== */
label {
  display: block;
  margin-bottom: 4px;
  font-size: 0.85rem;
  color: #cbd5f5;
}

input,
select {
  width: 100%;
  padding: 0.7rem 0.85rem;
  border-radius: 8px;
  border: 1px solid #1f2937;
  background: #020617;
  color: #e5e7eb;
  font-size: 0.95rem;
}

input:focus,
select:focus {
  outline: none;
  border-color: #38bdf8;
  box-shadow: 0 0 0 2px rgba(56,189,248,.35);
}

/* ===================== BUTTON ===================== */
.btn-primary {
  background: linear-gradient(135deg, #2563eb, #1d4ed8);
  color: #fff;
  font-weight: 600;
  padding: 0.8rem;
  width: 100%;
  border-radius: 10px;
  border: none;
  cursor: pointer;
  font-size: 1rem;
}
.btn-primary:hover {
  background: linear-gradient(135deg, #3b82f6, #2563eb);
}

/* ===================== MODAL ===================== */
#qrModal {
  position: fixed;
  inset: 0;
  display: none;
  align-items: center;
  justify-content: center;
  background: rgba(0,0,0,.75);
  z-index: 9999;
}

#qrModal.active {
  display: flex;
}

.modal-content {
  background: #020617;
  border-radius: 16px;
  padding: 1.5rem;
  max-width: 420px;
  width: 100%;
  text-align: center;
  color: #e5e7eb;
  position: relative;
}

.modal-content img {
  width: 260px;
  max-width: 80vw;
  margin: 1rem auto;
}

.modal-btn {
  margin-top: .5rem;
  background: #2563eb;
  color: white;
  padding: .55rem 1rem;
  border-radius: 8px;
  border: none;
  cursor: pointer;
  width: 100%;
}

.close-btn {
  position: absolute;
  top: 10px;
  right: 14px;
  font-size: 1.4rem;
  cursor: pointer;
}

/* ===================== MOBILE ===================== */
@media (max-width: 640px) {
  .form-card {
    padding: 1.25rem 1rem;
  }
  h1 {
    font-size: 1.35rem;
  }
}
</style>

<div class="qrabsen-wrapper">
  <div class="form-card">

    <h1 class="text-xl text-center font-bold text-blue-400 mb-4">
      📅 Generate QR Absensi
    </h1>

    <form id="formGenerateQR" class="space-y-4">

      <!-- EVENT NAME -->
      <div id="eventNameWrapper" class="hidden">
        <label>Nama Kegiatan</label>
        <input
          type="text"
          name="event_name"
          id="eventNameInput"
          placeholder="Contoh: Acara A"
        >
      </div>

      <!-- CLASS -->
      <div>
        <label>Pilih Kelas</label>
        <select name="class_id" id="classSelect" required>
          <option value="">-- Pilih Kelas --</option>
          <option value="event">📌 EVENT (Semua Kelas)</option>
          <?php
          $q = $conn->query("SELECT id, name FROM classes ORDER BY name");
          while ($r = $q->fetch_assoc()) {
            echo "<option value='{$r['id']}'>{$r['name']}</option>";
          }
          ?>
        </select>
      </div>

      <!-- START -->
      <div>
        <label>Tanggal & Jam Mulai</label>
        <input type="datetime-local" name="start_date" required>
      </div>

      <!-- END -->
      <div>
        <label>Tanggal & Jam Berakhir</label>
        <input type="datetime-local" name="end_date" required>
      </div>

      <button type="submit" class="btn-primary">
        Generate QR
      </button>
    </form>
  </div>
</div>

<!-- ===================== MODAL ===================== -->
<div id="qrModal">
  <div class="modal-content">
    <span class="close-btn" id="closeModal">&times;</span>
    <h2 class="text-lg font-semibold text-blue-400 mb-2">QR Absensi</h2>
    <div id="qrContainer"></div>
    <button class="modal-btn" id="copyLinkBtn">Salin Tautan</button>
    <button class="modal-btn" id="shareWaBtn">Share WhatsApp</button>
  </div>
</div>

<script>
const form = document.getElementById('formGenerateQR');
const classSelect = document.getElementById('classSelect');
const eventWrapper = document.getElementById('eventNameWrapper');
const eventInput = document.getElementById('eventNameInput');

const qrModal = document.getElementById('qrModal');
const qrContainer = document.getElementById('qrContainer');
const closeModal = document.getElementById('closeModal');
const copyBtn = document.getElementById('copyLinkBtn');
const waBtn = document.getElementById('shareWaBtn');

let currentQRUrl = '';

/* EVENT TOGGLE */
classSelect.addEventListener('change', () => {
  if (classSelect.value === 'event') {
    eventWrapper.classList.remove('hidden');
    eventInput.required = true;
  } else {
    eventWrapper.classList.add('hidden');
    eventInput.required = false;
    eventInput.value = '';
  }
});

/* SUBMIT */
form.addEventListener('submit', async e => {
  e.preventDefault();
  const fd = new FormData(form);

  const res = await fetch('generate_qr.php', {
    method: 'POST',
    body: fd
  });

  const d = await res.json();

  if (!d.success) {
    alert(d.message);
    return;
  }

  currentQRUrl = d.qr_url;

  qrContainer.innerHTML = `
    <img src="${d.qr_img}">
    <p style="font-size:12px;color:#94a3b8">
      Aktif: ${d.active_from} — ${d.active_until}
    </p>
    <a href="${d.qr_url}" target="_blank"
       style="font-size:12px;color:#38bdf8;word-break:break-all">
       ${d.qr_url}
    </a>
  `;

  qrModal.classList.add('active');
});

/* MODAL */
closeModal.onclick = () => qrModal.classList.remove('active');

copyBtn.onclick = async () => {
  await navigator.clipboard.writeText(currentQRUrl);
  copyBtn.textContent = '✅ Disalin';
  setTimeout(() => copyBtn.textContent = 'Salin Tautan', 1500);
};

waBtn.onclick = () => {
  window.open(`https://wa.me/?text=${encodeURIComponent(currentQRUrl)}`);
};
</script>

<?php
$content = ob_get_clean();
require __DIR__ . '/../../inc/layout.php';
