<?php
session_start();
$QR_TIMEOUT = 180; // 3 menit
require __DIR__ . '/../../inc/db.php';
date_default_timezone_set('Asia/Jakarta');

$token = $_SESSION['qr_token_rutin'] ?? '';

if ($token === '' && isset($_GET['token'])) {
  $getToken = trim($_GET['token']);
  if ($getToken !== '') {
    // simpan ke session
    $_SESSION['qr_token_rutin'] = $getToken;
    $_SESSION['qr_last_active'] = time();
    $token = $getToken;

    header("Location: /absensi");
    exit;
  }
}

if ($token === '') {
  header("Location: /attandance");
  exit;
}

// =========================
// AUTO LOGOUT JIKA INAKTIF
// =========================
if (isset($_SESSION['qr_last_active'])) {
  if (time() - $_SESSION['qr_last_active'] > $QR_TIMEOUT) {
    session_unset();
    session_destroy();
    header("Location: /attandance?err=timeout");
    exit;
  }
}

// update waktu aktif
$_SESSION['qr_last_active'] = time();


// Validasi token QR (rutin / perkelas)
$tokenEsc = $conn->real_escape_string($token);
$q = $conn->query("
  SELECT q.*, c.name AS class_name 
  FROM attendance_qr q 
  JOIN classes c ON c.id = q.class_id 
  WHERE q.qr_token = '$tokenEsc'
  LIMIT 1
");
$qr = $q ? $q->fetch_assoc() : null;

if (!$qr) {
  // Token tidak ditemukan → balikkan ke halaman input token dengan kode error
  header('Location: /attandance?err=invalid_token');
  exit;
}

// =========================
// CEK MASA BERLAKU TOKEN
// =========================
$now = time();
$startTs = strtotime($qr['start_date']);
$endTs   = strtotime($qr['end_date']);

if ($now < $startTs || $now > $endTs) {
  $isExpired  = $now > $endTs;
  $statusText = $isExpired ? "QR Sudah Kadaluarsa" : "QR Belum Aktif";
  $descText   = $isExpired
    ? "Masa berlaku QR ini telah berakhir. Silakan hubungi guru/pengajar untuk mendapatkan QR baru."
    : "QR ini belum aktif. Silakan coba kembali setelah waktu mulai yang ditentukan.";
  $icon       = $isExpired ? "⚠️" : "⏳";

  die('
  <!DOCTYPE html>
  <html lang="id">
  <head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>'.$statusText.'</title>
    <link href="https://cdn.jsdelivr.net/npm/tailwindcss@2.2.19/dist/tailwind.min.css" rel="stylesheet">
    <style>
      body {
        background: linear-gradient(160deg, #0b1120 0%, #0f172a 60%, #1e293b 100%);
        color: #dbeafe;
        font-family: "Inter", sans-serif;
        min-height: 100vh;
        display: flex;
        flex-direction: column;
        justify-content: center;
        align-items: center;
        padding: 1.5rem 1rem;
      }
      @keyframes fadeIn { 
        from { opacity: 0; transform: translateY(20px);} 
        to   { opacity: 1; transform: translateY(0);} 
      }
      @keyframes glow {
        0%,100% { box-shadow: 0 0 10px rgba(140,224,255,0.3);}
        50%     { box-shadow: 0 0 25px rgba(140,224,255,0.6);}
      }
      .animate-fadeIn { animation: fadeIn .6s ease-in-out forwards; }
      .animate-glow   { animation: glow 2.5s infinite ease-in-out; }
    </style>
  </head>
  <body>
    <main class="flex flex-col items-center justify-center flex-grow">
      <div class="text-center max-w-md w-full bg-[#1e293b]/70 backdrop-blur-xl rounded-2xl p-8 shadow-2xl border border-[#334155] animate-fadeIn animate-glow">
        <div class="text-6xl mb-4">'.$icon.'</div>
        <h1 class="text-2xl font-bold mb-2 text-blue-400">'.$statusText.'</h1>
        <p class="text-gray-300 text-sm mb-5 leading-relaxed">'.$descText.'</p>
        <div class="bg-[#0f172a]/80 text-xs text-gray-400 px-4 py-3 rounded-lg border border-[#1E2B44]">
          <p><span class="font-semibold text-blue-400">Mulai aktif:</span> '.date('d M Y H:i', $startTs).'</p>
          <p><span class="font-semibold text-blue-400">Berakhir:</span> '.date('d M Y H:i', $endTs).'</p>
        </div>
        <a href="/" class="inline-block mt-6 bg-gradient-to-r from-blue-600 to-blue-800 hover:from-blue-500 hover:to-blue-700 text-white px-6 py-2.5 rounded-lg font-medium shadow-md transition-all duration-300">
          🔄 Kembali ke Beranda
        </a>
      </div>
    </main>

  </body>
  </html>
  ');
}

// =========================
// DATA KELAS & TANGGAL DEFAULT
// =========================
$class_id   = (int)$qr['class_id'];
$class_name = htmlspecialchars($qr['class_name'], ENT_QUOTES, 'UTF-8');

// Default tanggal: hari ini (boleh diganti di form)
$today = date('Y-m-d');
$startDateStr = date('Y-m-d', $startTs);
$endDateStr   = date('Y-m-d', $endTs);

// Clamp supaya default tetap dalam range token
if ($today < $startDateStr) {
  $selectedDate = $startDateStr;
} elseif ($today > $endDateStr) {
  $selectedDate = $endDateStr;
} else {
  $selectedDate = $today;
}

$maxSelectable = $endDateStr;

if ($today < $startDateStr) {
  $maxSelectable = $startDateStr;
} elseif ($today < $endDateStr) {
  $maxSelectable = $today;
}

// =========================
// CEK "LOCK" KEGIATAN PER QR + TANGGAL
// =========================
$qr_id = (int)$qr['id'];

$lockedActivityId   = null;
$lockedActivityName = '';

$lockStmt = $conn->prepare("
  SELECT ad.activity_id, a.name AS activity_name
  FROM attendance_daily ad
  LEFT JOIN activities a ON a.id = ad.activity_id
  WHERE ad.qr_id = ?
    AND ad.tanggal = ?
    AND ad.activity_id IS NOT NULL
  LIMIT 1
");
if ($lockStmt) {
  $lockStmt->bind_param('is', $qr_id, $selectedDate);
  if ($lockStmt->execute()) {
    $lockRes = $lockStmt->get_result();
    if ($lockRes && $lockRes->num_rows) {
      $lockRow            = $lockRes->fetch_assoc();
      $lockedActivityId   = (int)$lockRow['activity_id'];
      $lockedActivityName = $lockRow['activity_name'] ?? '';
    }
  }
  $lockStmt->close();
}

// =========================
// DATA SISWA
// =========================
$siswa = $conn->query("
  SELECT s.id, s.name
  FROM students s
  WHERE s.class_id = $class_id
  ORDER BY s.name
");

// === MASTER JENIS KEGIATAN ===
$activities = $conn->query("
  SELECT id, name 
  FROM activities 
  WHERE is_active = 1 
  ORDER BY name
");
?>
<!DOCTYPE html>
<html lang="id">
<head>
  <meta charset="UTF-8">
  <meta name="viewport" content="width=device-width, initial-scale=1.0">
  <title>Absensi Kelas <?= $class_name ?></title>
  <link href="https://cdn.jsdelivr.net/npm/tailwindcss@2.2.19/dist/tailwind.min.css" rel="stylesheet">
  <style>
    body {
      background: linear-gradient(160deg, #0b1120 0%, #0f172a 60%, #1e293b 100%);
      color: #dbeafe;
      font-family: "Inter", sans-serif;
      display: flex;
      flex-direction: column;
      min-height: 100vh;
      overflow-x: hidden;
      overflow-y: auto;
    }
    main {
      flex-grow: 1;
      display: flex;
      flex-direction: column;
      justify-content: flex-start;
      align-items: center;
      padding: 1.25rem 1rem 6.5rem;
    }

    select, input {
      font-size: 14px;
    }

    @keyframes fadeIn {
      from { opacity: 0; transform: scale(0.95); }
      to   { opacity: 1; transform: scale(1); }
    }
    .animate-fadeIn { animation: fadeIn 0.25s ease-out forwards; }

    @keyframes slideUp {
      from { opacity: 0; transform: translateY(20px); }
      to   { opacity: 1; transform: translateY(0); }
    }
    .animate-slideUp { animation: slideUp 0.25s ease-out forwards; }

    @keyframes glow {
      0%, 100% { box-shadow: 0 0 10px rgba(140, 224, 255, 0.2); }
      50%      { box-shadow: 0 0 25px rgba(140, 224, 255, 0.5); }
    }

    /* Tombol Laporkan */
    #reportButton {
      position: fixed;
      bottom: 6rem;
      right: 1.5rem;
      backdrop-filter: blur(6px);
      box-shadow: 0 4px 16px rgba(250, 204, 21, 0.25);
      z-index: 1000;
    }
    #reportButton:hover {
      box-shadow: 0 6px 20px rgba(250, 204, 21, 0.4);
      transform: translateY(-3px);
    }

    /* Field di modal laporan */
    #reportModal input,
    #reportModal textarea {
      background: #ffffff !important;
      color: #000000 !important;
      -webkit-text-fill-color: #000000;
      border: 1px solid #475569;
      border-radius: 8px;
    }
    #reportModal input::placeholder,
    #reportModal textarea::placeholder {
      color: #555 !important;
    }
    #reportModal input:focus,
    #reportModal textarea:focus {
      outline: none;
      border-color: #facc15;
      box-shadow: 0 0 0 2px rgba(250, 204, 21, 0.3);
    }

    /* Gaya item siswa */
    .student-item {
      position: relative;
      border-radius: 9999px;
      background: rgba(15, 23, 42, 0.9);
      border: 1px solid rgba(148, 163, 184, 0.45);
      transition: all 0.16s ease-out;
    }
    .student-item::before {
      content: "";
      position: absolute;
      left: 12px;
      width: 9px;
      height: 9px;
      border-radius: 9999px;
      background: #38bdf8;
      opacity: 0.7;
    }
    .student-item span.student-name {
      padding-left: 0.75rem;
    }
    .student-item:hover {
      border-color: #38bdf8;
      background: radial-gradient(circle at top left, rgba(56,189,248,0.18), rgba(15,23,42,0.98));
      transform: translateY(-1px);
    }
    .student-item.selected {
      background: radial-gradient(circle at top left, rgba(56,189,248,0.28), rgba(15,23,42,0.98));
      border-color: #38bdf8;
      box-shadow: 0 0 0 1px rgba(56,189,248,0.6);
    }

    .check-icon {
      opacity: 0;
      transform: scale(0.9);
      transition: opacity 0.15s ease-out, transform 0.15s ease-out;
    }
    .student-item.selected .check-icon {
      opacity: 1;
      transform: scale(1);
    }

    /* TOAST TOP CENTER */
    #toast {
      position: fixed;
      top: 0.75rem;
      left: 50%;
      transform: translate(-50%, -18px);
      z-index: 1500;
      width: min(92%, 430px);
      opacity: 0;
      pointer-events: none;
      transition: opacity 0.25s ease-out, transform 0.25s ease-out;
    }
    #toastInner {
      display: flex;
      align-items: center;
      gap: 0.65rem;
      padding: 0.75rem 1rem;
      border-radius: 9999px;
      background: rgba(15, 23, 42, 0.96);
      border: 1px solid rgba(148, 163, 184, 0.65);
      box-shadow: 0 18px 45px rgba(15, 23, 42, 0.9);
      backdrop-filter: blur(14px);
      font-size: 0.85rem;
    }
    #toastIcon {
      width: 30px;
      height: 30px;
      border-radius: 9999px;
      display: flex;
      align-items: center;
      justify-content: center;
      font-size: 18px;
      background: rgba(15,23,42,0.9);
    }
    #toast.show {
      opacity: 1;
      transform: translate(-50%, 0);
      pointer-events: auto;
    }
  </style>
</head>
<body>

  <main class="animate-fadeIn">
    <div class="bg-[#1e293b] p-6 rounded-2xl shadow-2xl w-full max-w-md form-card border border-[#334155] animate-glow">
      <h2 class="text-xl font-bold text-center text-blue-400">
        📋 Absensi Kelas <?= $class_name ?>
      </h2>

      <!-- FORM ABSENSI -->
      <form id="absenForm" method="POST" class="space-y-4">
        <input type="hidden" id="tokenField" name="token"
               value="<?= htmlspecialchars($token, ENT_QUOTES, 'UTF-8') ?>">

        <!-- TANGGAL ABSENSI -->
        <div class="mt-1">
          <label for="tanggalField" class="text-sm text-blue-300">Tanggal Absensi:</label>
          <input
            type="date"
            id="tanggalField"
            class="mt-1 w-full bg-white text-black text-sm rounded-lg px-3 py-2
                   focus:outline-none focus:ring-2 focus:ring-blue-400"
            value="<?= $selectedDate ?>"
            min="<?= $startDateStr ?>"
            max="<?= $maxSelectable ?>"
          >
          <p class="text-xs text-gray-400 mt-1" style="font-size: 12px;">
            Tanggal ini yang akan dicatat sebagai tanggal absensi di sistem.
          </p>
        </div>

        <!-- MULTI SELECT SISWA -->
        <div class="mt-2">
          <label class="text-sm text-blue-300">Pilih Siswa (bisa lebih dari satu)</label>

          <div id="studentList" class="mt-2 space-y-2 max-h-64 overflow-y-auto pr-1">
            <?php if ($siswa && $siswa->num_rows): ?>
              <?php while ($s = $siswa->fetch_assoc()): ?>
                <button
                  type="button"
                  class="student-item w-full flex items-center justify-between px-4 py-2
                         hover:bg-[#020617] transition-all duration-150 text-left select-none"
                  data-already="0"
                >
                  <span class="text-sm student-name">
                    <?= htmlspecialchars($s['name']) ?>
                  </span>
                  <div class="flex items-center gap-2">
                    <span class="check-icon text-green-400 text-lg">✔</span>
                  </div>
                  <input type="hidden" class="student-id" value="<?= (int)$s['id'] ?>">
                </button>
              <?php endwhile; ?>
            <?php else: ?>
              <p class="text-xs text-gray-400 mt-2">Belum ada data siswa di kelas ini.</p>
            <?php endif; ?>
          </div>
        </div>

        <!-- NAMA BARU (POPUP) -->
        <div class="pt-2 border-t border-[#334155]/60 mt-3">
          <button
            type="button"
            onclick="openNewNameModal()"
            class="text-xs text-blue-300 hover:text-blue-200 underline">
            + Nama belum ada di daftar?
          </button>
        </div>

        <!-- JENIS KEGIATAN -->
        <div class="mt-2">
          <label for="activityField" class="text-sm text-blue-300">Jenis Kegiatan:</label>

          <?php if ($lockedActivityId): ?>
            <div class="mt-1 flex items-center justify-between gap-2">
              <span class="inline-flex items-center px-3 py-1 rounded-full 
                           bg-emerald-100 text-emerald-800 border border-emerald-300 text-xs">
                <?= htmlspecialchars($lockedActivityName ?: 'Kegiatan sudah ditetapkan', ENT_QUOTES, 'UTF-8') ?>
              </span>
            </div>
            <input type="hidden" id="lockedActivityId" value="<?= (int)$lockedActivityId ?>">

          <?php else: ?>
            <select id="activityField"
                    class="mt-1 w-full bg-white text-black text-sm rounded-lg px-3 py-2
                           focus:outline-none focus:ring-2 focus:ring-blue-400">
              <option value="">-- Pilih Jenis Kegiatan --</option>
              <?php if ($activities && $activities->num_rows): ?>
                <?php while ($act = $activities->fetch_assoc()): ?>
                  <option value="<?= (int)$act['id'] ?>">
                    <?= htmlspecialchars($act['name']) ?>
                  </option>
                <?php endwhile; ?>
              <?php else: ?>
                <option value="">Belum ada master kegiatan</option>
              <?php endif; ?>
            </select>
            <p class="text-xs text-gray-400 mt-1" style="font-size:11px;">
              Kegiatan yang dipilih akan dipakai untuk semua absensi di tanggal ini.
            </p>
          <?php endif; ?>
        </div>

        <!-- STATUS ABSENSI -->
        <div class="mt-2">
          <label for="statusField" class="text-sm text-blue-300">Status Absensi:</label>
          <select id="statusField"
                  class="mt-1 w-full bg-white text-black text-sm rounded-lg px-3 py-2
                         focus:outline-none focus:ring-2 focus:ring-blue-400">
            <option value="Hadir">Hadir</option>
            <option value="Izin">Izin</option>
            <option value="Sakit">Sakit</option>
          </select>
        </div>
        
        <button type="submit"
          class="bg-gradient-to-r from-blue-600 to-blue-800 hover:from-blue-500 hover:to-blue-700
                 w-full py-2 rounded-xl font-semibold text-white transition-all duration-300">
          ✅ Kirim Absensi
        </button>
      </form>
    </div>
  </main>

  <!-- TOMBOL LAPORKAN -->
  <button id="reportButton" type="button" onclick="openReportModal()"
    class="fixed bottom-6 right-6 flex items-center gap-2 bg-gradient-to-r from-yellow-500 to-amber-400 
           hover:from-yellow-400 hover:to-amber-300 text-[#0f172a] font-semibold rounded-full 
           px-5 py-3 shadow-lg shadow-yellow-600/30 hover:scale-105 transition-all duration-300 
           border border-yellow-500/50 z-[1000]">
    <span class="text-lg">⚠️</span>
    <span class="font-medium tracking-wide">Laporkan</span>
  </button>

  <!-- MODAL LAPORAN -->
  <div id="reportModal"
    class="hidden fixed inset-0 z-[2000] flex items-center justify-center sm:justify-end sm:items-center sm:pr-[5vw]"
    style="background: rgba(0,0,0,0.85) !important; backdrop-filter:none !important;">

    <div class="modal-card w-[92%] max-w-[520px]
                rounded-2xl
                bg-gradient-to-b from-[#1b2437] to-[#0f172a]
                text-[#E2E8F0] shadow-2xl border border-[#334155]/60
                animate-slideUp sm:animate-fadeIn">

      <div class="flex items-center justify-between px-5 py-3 border-b border-[#334155]/60">
        <div>
          <h2 class="text-lg font-semibold text-yellow-400">Laporkan jika ada kendala</h2>
          <p class="text-[11px] text-gray-400">Kesalahan nama, absensi tidak tercatat, atau kendala teknis.</p>
        </div>
        <button aria-label="Tutup" onclick="closeReportModal()" class="ml-3 text-gray-400 hover:text-yellow-400 text-xl leading-none">×</button>
      </div>

      <div class="px-5 pt-3 pb-4 space-y-3">
        <div>
          <label class="block text-[12px] font-medium text-[#EFDCA6] mb-1">Nama Pelapor</label>
          <input id="reportName" type="text"
            class="w-full p-2.5 rounded-lg border border-[#475569]
                   focus:ring-2 focus:ring-yellow-400 outline-none placeholder-gray-500"
            placeholder="Masukkan nama Anda">
        </div>

        <div>
          <label class="block text-[12px] font-medium text-[#EFDCA6] mb-1">Isi Laporan</label>
          <textarea id="reportMessage" rows="3"
            class="w-full p-2.5 rounded-lg border border-[#475569]
                   focus:ring-2 focus:ring-yellow-400 outline-none placeholder-gray-500 resize-none"
            placeholder="Tuliskan kendala atau pesan untuk admin..."></textarea>
        </div>

        <div class="flex justify-end gap-3 pt-3 border-t border-[#334155]/60">
          <button onclick="closeReportModal()"
                  class="px-4 py-2 rounded-lg bg-gray-600/80 text-white text-sm font-medium hover:bg-gray-500">Batal</button>
          <button onclick="sendReport()"
                  class="px-5 py-2 rounded-lg font-semibold bg-yellow-400 text-[#0f172a] hover:bg-yellow-300 shadow-md">Kirim</button>
        </div>
      </div>
    </div>
  </div>

  <!-- MODAL NAMA BARU -->
  <div id="newNameModal"
       class="hidden fixed inset-0 z-[1900] flex items-center justify-center px-4"
       style="background: rgba(0,0,0,0.8);">
    <div class="w-full max-w-md rounded-2xl
                bg-gradient-to-b from-[#1b2437] to-[#020617]
                border border-[#334155]/70 shadow-2xl
                animate-slideUp">
      <div class="flex items-center justify-between px-5 py-3 border-b border-[#334155]/60">
        <div>
          <h2 class="text-base font-semibold text-blue-300">Tambah nama baru</h2>
          <p class="text-[11px] text-gray-400">
            Nama yang ditambahkan akan langsung dicatat dengan status absensi yang dipilih.
          </p>
        </div>
        <button type="button"
                onclick="closeNewNameModal()"
                class="text-gray-400 hover:text-blue-300 text-xl leading-none">
          ×
        </button>
      </div>

      <div class="px-5 pt-3 pb-4 space-y-3">
        <div>
          <label class="block text-[12px] font-medium text-blue-200 mb-1">Nama Baru</label>
          <input id="newNameInput" type="text"
                 class="w-full p-2.5 rounded-lg border border-[#475569]
                        bg-white text-black placeholder-gray-500
                        focus:outline-none focus:ring-2 focus:ring-blue-400"
                 placeholder="Masukkan nama siswa">
        </div>

        <div>
          <label class="block text-[12px] font-medium text-blue-200 mb-1">Status Absensi</label>
          <select id="newNameStatus"
                  class="w-full p-2.5 rounded-lg border border-[#475569]
                         bg-white text-black text-sm
                         focus:outline-none focus:ring-2 focus:ring-blue-400">
            <option value="Hadir">Hadir</option>
            <option value="Izin">Izin</option>
            <option value="Sakit">Sakit</option>
          </select>
        </div>

        <div class="flex justify-end gap-3 pt-3 border-t border-[#334155]/60">
          <button type="button"
                  onclick="closeNewNameModal()
"
                  class="px-4 py-2 rounded-lg bg-gray-600/80 text-white text-xs font-medium hover:bg-gray-500">
            Batal
          </button>
          <button type="button"
                  onclick="sendNewName()"
                  class="px-5 py-2 rounded-lg bg-blue-500 text-white text-xs font-semibold hover:bg-blue-400 shadow-md">
            Simpan &amp; Catat
          </button>
        </div>
      </div>
    </div>
  </div>

<footer class="border-t border-[#1E2B44] bg-[#0b1223]/95 backdrop-blur-md text-center text-gray-500 text-xs py-3 w-full fixed bottom-0 left-0">
  <span class="text-gray-300">Masa berlaku token sampai</span>
  <span id="endTimeText" class="text-[#fbbf24] font-semibold"></span>
</footer>

  <!-- TOAST -->
  <div id="toast">
    <div id="toastInner">
      <div id="toastIcon">✓</div>
      <div class="flex-1">
        <p id="toastTitle" class="font-semibold text-slate-50 mb-0.5">Info</p>
        <p id="toastText" class="text-slate-200 text-[12px]"></p>
      </div>
    </div>
  </div>
<script>
    // ===== ACTIVITY LOCK (CLIENT) =====
    // Nilai awal ambil dari PHP kalau sudah ada lock di DB (qr_id + tanggal)
    let currentActivityId   = <?= $lockedActivityId ? (int)$lockedActivityId : 'null' ?>;
    let currentActivityName = <?= json_encode($lockedActivityName ?? '') ?>;

    // ===== TOAST =====
    let toastTimer;
    function showToast(type, title, message) {
      const toast    = document.getElementById('toast');
      const iconBox  = document.getElementById('toastIcon');
      const titleEl  = document.getElementById('toastTitle');
      const textEl   = document.getElementById('toastText');
      const inner    = document.getElementById('toastInner');

      let icon  = "✅";
      let grad  = "linear-gradient(135deg,#16a34a,#22c55e)";
      let border= "#22c55e";

      if (type === "warning") {
        icon   = "⚠️";
        grad   = "linear-gradient(135deg,#eab308,#facc15)";
        border = "#facc15";
      } else if (type === "error") {
        icon   = "✖";
        grad   = "linear-gradient(135deg,#ef4444,#f97373)";
        border = "#f97373";
      } else if (type === "info") {
        icon   = "ℹ️";
        grad   = "linear-gradient(135deg,#3b82f6,#60a5fa)";
        border = "#60a5fa";
      }

      iconBox.textContent        = icon;
      inner.style.background     = grad;
      inner.style.borderColor    = border;
      inner.style.boxShadow      = "0 18px 45px rgba(15,23,42,0.9)";
      titleEl.textContent        = title;
      textEl.textContent         = message;

      toast.classList.add('show');
      clearTimeout(toastTimer);
      toastTimer = setTimeout(() => {
        toast.classList.remove('show');
      }, 3500);
    }

    // ===== MULTI SELECT SISWA =====
    const studentItems = document.querySelectorAll('.student-item');
    studentItems.forEach(item => {
      item.addEventListener('click', () => {
        item.classList.toggle('selected');
      });
    });

    function markAsAlreadyAbsen(item, status) {
      item.classList.remove('selected');
      item.classList.add('already-absen');
      item.dataset.already = '1';
      item.setAttribute('disabled', 'disabled');

      const rightBox = item.querySelector('.flex.items-center.gap-2');
      if (rightBox) {
        rightBox.innerHTML = `
          <span class="text-[11px] px-2 py-0.5 rounded-full 
                       bg-emerald-500/10 text-emerald-300 
                       border border-emerald-400/40 whitespace-nowrap">
            ${status}
          </span>
        `;
      }
    }

    // 🔒 Kunci dropdown kegiatan di sisi client
    function lockActivityOnClient(activityId) {
      if (!activityId) return;
      currentActivityId = activityId;

      const select = document.getElementById('activityField');
      if (select) {
        select.disabled = true;
        select.classList.add('opacity-70', 'cursor-not-allowed');

        // Tambah info kecil di bawah dropdown
        let info = document.getElementById('activityLockInfo');
        if (!info) {
          info = document.createElement('p');
          info.id = 'activityLockInfo';
          info.className = 'text-[11px] text-emerald-300 mt-1';
          select.parentNode.appendChild(info);
        }
      }

      showToast("info", "Kegiatan dikunci",
        "Tanggal ini dikunci ke kegiatan yang dipilih. Semua absensi berikutnya memakai kegiatan yang sama.");
    }

    // Kalau dari PHP sudah ada lock (currentActivityId != null), kunci dropdown sejak awal
    document.addEventListener('DOMContentLoaded', () => {
      if (currentActivityId) {
        const select = document.getElementById('activityField');
        if (select) {
          select.disabled = true;
          select.classList.add('opacity-70', 'cursor-not-allowed');
        }
      }
    });

    // ===== SUBMIT ABSEN =====
    document.getElementById('absenForm').addEventListener('submit', async (e) => {
      e.preventDefault();

      const token    = "<?= htmlspecialchars($token, ENT_QUOTES, 'UTF-8') ?>";
      const selected = Array.from(document.querySelectorAll('.student-item.selected'));

      const tanggalField   = document.getElementById('tanggalField');
      const attendanceDate = tanggalField ? tanggalField.value : '';

      if (!attendanceDate) {
        showToast("warning", "Tanggal belum diisi", "Silakan pilih tanggal absensi terlebih dahulu.");
        return;
      }

      const statusField   = document.getElementById('statusField');
      const status        = statusField ? statusField.value : 'Hadir';

      const dropdownActivity = document.getElementById('activityField');

      // 🔐 Ambil activityId dari lock dulu. Kalau belum ada lock, ambil dari dropdown.
      let activityId = currentActivityId;
      if (!activityId && dropdownActivity && dropdownActivity.value) {
        activityId = dropdownActivity.value;
      }

      if (!activityId) {
        showToast("warning", "Jenis kegiatan belum dipilih", "Pilih jenis kegiatan terlebih dahulu.");
        return;
      }

      if (selected.length === 0) {
        showToast("warning", "Belum memilih", "Pilih minimal satu siswa terlebih dahulu.");
        return;
      }

      const baseURL = window.location.origin + "/system-absent/modules/qr_absen/submit_absen.php";

      let successCount = 0;
      let failCount    = 0;
      let lastError    = "";

      for (const item of selected) {
        const idInput = item.querySelector('.student-id');
        if (!idInput) continue;
        const studentId = idInput.value;

        const fd = new FormData();
        fd.append('token',           token);
        fd.append('student_id',      studentId);
        fd.append('status',          status);
        fd.append('attendance_date', attendanceDate);
        fd.append('activity_id',     activityId);

        try {
          const res  = await fetch(baseURL, { method: "POST", body: fd });
          const data = await res.json();
          if (data.success) {
            successCount++;
            markAsAlreadyAbsen(item, status);

            // ✅ Setelah submit pertama yang sukses dan belum ada lock → kunci activity di client
            if (!currentActivityId) {
              lockActivityOnClient(activityId);
            }
          } else {
            failCount++;
            lastError = data.message || "Gagal mengirim absensi untuk salah satu siswa.";
          }
        } catch (err) {
          failCount++;
          lastError = err.message;
        }
      }

      if (successCount && !failCount) {
        showToast("success", "Berhasil", `Berhasil mengirim absensi untuk ${successCount} data.`);
      } else if (successCount && failCount) {
        showToast("warning", "Sebagian berhasil", `Berhasil: ${successCount}, Gagal: ${failCount}. ${lastError}`);
      } else {
        showToast("error", "Gagal", lastError || "Gagal mengirim absensi.");
      }

      if (successCount) {
        selected.forEach(item => item.classList.remove('selected'));
      }
    });

    // ===== POPUP NAMA BARU =====
    function openNewNameModal() {
      const modal       = document.getElementById('newNameModal');
      const input       = document.getElementById('newNameInput');
      const statusField = document.getElementById('statusField');
      const newStatus   = document.getElementById('newNameStatus');

      if (statusField && newStatus) {
        newStatus.value = statusField.value;
      }

      if (modal) {
        modal.classList.remove('hidden');
      }
      document.body.style.overflow = 'hidden';

      setTimeout(() => {
        if (input) input.focus();
      }, 50);
    }

    function closeNewNameModal() {
      const modal = document.getElementById('newNameModal');
      const input = document.getElementById('newNameInput');
      if (modal) {
        modal.classList.add('hidden');
      }
      document.body.style.overflow = '';
      if (input) input.value = '';
    }

    window.openNewNameModal  = openNewNameModal;
    window.closeNewNameModal = closeNewNameModal;

    async function sendNewName() {
      const input        = document.getElementById('newNameInput');
      const statusSelect = document.getElementById('newNameStatus');
      const name         = input.value.trim();
      const status       = statusSelect.value;

      const tanggalField   = document.getElementById('tanggalField');
      const attendanceDate = tanggalField ? tanggalField.value : '';

      if (!attendanceDate) {
        showToast("warning", "Tanggal belum diisi", "Silakan pilih tanggal absensi terlebih dahulu.");
        return;
      }

      const dropdownActivity = document.getElementById('activityField');
      let activityId = currentActivityId;
      if (!activityId && dropdownActivity && dropdownActivity.value) {
        activityId = dropdownActivity.value;
      }

      if (!activityId) {
        showToast("warning", "Jenis kegiatan belum dipilih", "Pilih jenis kegiatan terlebih dahulu.");
        return;
      }

      if (!name) {
        showToast("warning", "Nama belum diisi", "Masukkan nama siswa terlebih dahulu.");
        input.focus();
        return;
      }

      const token   = "<?= htmlspecialchars($token, ENT_QUOTES, 'UTF-8') ?>";
      const baseURL = window.location.origin + "/system-absent/modules/qr_absen/submit_absen.php";

      const fd = new FormData();
      fd.append('token',           token);
      fd.append('new_name',        name);
      fd.append('status',          status);
      fd.append('attendance_date', attendanceDate);
      fd.append('activity_id',     activityId);

      try {
        const res  = await fetch(baseURL, { method: "POST", body: fd });
        const data = await res.json();

        if (data.success) {
          showToast("success", "Nama ditambahkan",
            data.message || `Nama ${name} sudah ditambahkan dan dicatat ${status}.`);
          closeNewNameModal();

          const list = document.getElementById('studentList');
          if (list) {
            const btn = document.createElement('button');
            btn.type = "button";
            btn.className =
              "student-item already-absen w-full flex items-center justify-between px-4 py-2 " +
              "hover:bg-[#020617] transition-all duration-150 text-left select-none";
            btn.dataset.already = "1";
            btn.disabled = true;

            const newId = data.new_student_id || "";

            btn.innerHTML = `
              <span class="text-sm student-name">${name}</span>
              <div class="flex items-center gap-2">
                <span class="text-[11px] px-2 py-0.5 rounded-full 
                             bg-emerald-500/10 text-emerald-300 
                             border border-emerald-400/40 whitespace-nowrap">
                  ${status}
                </span>
              </div>
              <input type="hidden" class="student-id" value="${newId}">
            `;

            list.appendChild(btn);
          }

          // Kalau ini submit pertama dan belum ada lock → kunci activity di client
          if (!currentActivityId) {
            lockActivityOnClient(activityId);
          }

        } else {
          showToast("error", "Gagal", data.message || "Nama baru gagal disimpan.");
        }

      } catch (err) {
        showToast("error", "Gagal", err.message || "Terjadi kesalahan jaringan.");
      }
    }

    window.sendNewName = sendNewName;

    // ===== INFO BATAS WAKTU QR (tanpa countdown) =====
    const endTimeText = document.getElementById("endTimeText");
    if (endTimeText) {
      const endDate = new Date("<?= date('Y-m-d H:i:s', $endTs) ?>");
      const now     = new Date();

      if (endDate <= now) {
        endTimeText.textContent = "QR sudah kadaluarsa";
      } else {
        const endStr = endDate.toLocaleString("id-ID", {
          weekday: "long",
          day: "numeric",
          month: "long",
          year: "numeric",
          hour: "2-digit",
          minute: "2-digit"
        });
        endTimeText.textContent = endStr;
      }
    }

    // ===== LAPORAN =====
    async function sendReport() {
      const name = document.getElementById("reportName").value.trim();
      const msg  = document.getElementById("reportMessage").value.trim();

      if (!name || !msg) {
        showToast("warning", "Lengkapi data", "Nama dan isi laporan wajib diisi.");
        return;
      }

      const baseURL = window.location.origin + "/system-absent/modules/qr_absen/report_nama.php";
      const formData = new FormData();
      formData.append("token", "<?= htmlspecialchars($token, ENT_QUOTES, 'UTF-8') ?>");
      formData.append("name",  name);
      formData.append("message", msg);

      try {
        const res  = await fetch(baseURL, { method: "POST", body: formData });
        const data = await res.json();

        if (data.success) {
          showToast("success", "Laporan terkirim", data.message || "Terima kasih, laporan sudah dikirim.");
          document.getElementById("reportName").value = "";
          document.getElementById("reportMessage").value = "";
          closeReportModal();
        } else {
          showToast("error", "Gagal kirim", data.message || "Laporan gagal dikirim.");
        }
      } catch (err) {
        showToast("error", "Gagal kirim", err.message || "Terjadi kesalahan jaringan.");
      }
    }
    window.sendReport = sendReport;

    function openReportModal() {
      const modal = document.getElementById('reportModal');
      const btn   = document.getElementById('reportButton');
      modal.classList.remove('hidden');
      btn.classList.add('hidden');
      document.body.style.overflow = 'hidden';
    }
    function closeReportModal() {
      const modal = document.getElementById('reportModal');
      const btn   = document.getElementById('reportButton');
      modal.classList.add('hidden');
      btn.classList.remove('hidden');
      document.body.style.overflow = '';
    }
    window.openReportModal  = openReportModal;
    window.closeReportModal = closeReportModal;

    document.getElementById('reportModal').addEventListener('click', (e) => {
      if (e.target.id === 'reportModal') closeReportModal();
    });

    document.addEventListener('keydown', (e) => {
      if (e.key === 'Escape' && !document.getElementById('reportModal').classList.contains('hidden')) {
        closeReportModal();
      }
    });
  </script>
  
<script>
setInterval(() => {
  fetch("/system-absent/modules/qr_absen/ping.php", {
    method: "POST",
    cache: "no-store",
    credentials: "same-origin"
  });
}, 15000); // tiap 15 detik
</script>

<script>
/**
 * ============================
 * ⏱️ WARNING SEBELUM AUTO LOGOUT
 * ============================
 */
const QR_TIMEOUT      = 180; // HARUS SAMA dengan PHP
const WARNING_SECONDS = 30;

let lastActivity = Date.now();
let warningShown = false;

// reset timer kalau ada aktivitas
["click", "touchstart", "mousemove", "keydown", "scroll"].forEach(evt => {
  document.addEventListener(evt, () => {
    lastActivity = Date.now();
    warningShown = false;
  }, { passive: true });
});

setInterval(() => {
  const elapsed = Math.floor((Date.now() - lastActivity) / 1000);
  const remain  = QR_TIMEOUT - elapsed;

  if (remain <= WARNING_SECONDS && remain > 0 && !warningShown) {
    warningShown = true;
    showToast(
      "warning",
      "Sesi akan berakhir",
      `Tidak ada aktivitas. Anda akan logout dalam ${remain} detik.`
    );
  }

  if (remain <= 0) {
    window.location.href = "/attandance?err=timeout";
  }
}, 1000);
</script>



</body>
</html>
