<?php
require __DIR__ . '/../../inc/db.php';

$class_id = (int)($_GET['class_id'] ?? 0);
$tanggal  = date('Y-m-d');

$q = $conn->query("
  SELECT s.id, s.name,
    (
      SELECT ad.status
      FROM attendance_daily ad
      WHERE ad.student_id = s.id AND ad.tanggal = '$tanggal'
      LIMIT 1
    ) AS status_today
  FROM students s
  WHERE s.class_id = $class_id
  ORDER BY s.name
");

while ($s = $q->fetch_assoc()):
  $already = !empty($s['status_today']);
?>
<button
  type="button"
  class="student-item w-full flex items-center justify-between px-4 py-2
         hover:bg-[#020617] transition-all duration-150 text-left select-none
         <?= $already ? 'already-absen' : '' ?>"
  data-already="<?= $already ? '1' : '0' ?>"
  <?= $already ? 'disabled' : '' ?>
>
  <span class="text-sm student-name">
    <?= htmlspecialchars($s['name']) ?>
  </span>

  <div class="flex items-center gap-2">
    <?php if ($already): ?>
      <span class="text-[11px] px-2 py-0.5 rounded-full 
                   bg-emerald-500/10 text-emerald-300 
                   border border-emerald-400/40 whitespace-nowrap">
        <?= htmlspecialchars($s['status_today']) ?>
      </span>
    <?php else: ?>
      <span class="check-icon text-green-400 text-lg">✔</span>
    <?php endif; ?>
  </div>

  <input type="hidden" class="student-id" value="<?= $s['id'] ?>">
</button>
<?php endwhile; ?>
