<?php
// modules/qr_absen/qr_absen_rutin_gate.php
date_default_timezone_set('Asia/Jakarta');

$token = '';
$error = '';

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $token = trim($_POST['token'] ?? '');

    if ($token === '') {
        $error = "Token wajib diisi.";
    } else {
        // Redirect ke halaman absensi publik yang sudah kamu pakai
        header("Location: qr_absen_public.php?token=" . urlencode($token));
        exit;
    }
}
?>
<!DOCTYPE html>
<html lang="id">
<head>
  <meta charset="UTF-8">
  <title>Absensi Rutin - Masukkan Token Kelas</title>
  <meta name="viewport" content="width=device-width, initial-scale=1.0">
  <script src="https://cdn.tailwindcss.com"></script>
</head>
<body class="bg-slate-950 text-slate-100 min-h-screen flex items-center justify-center">

  <div class="w-full max-w-md mx-auto px-4">
    <div class="bg-slate-900/80 border border-slate-800 rounded-2xl p-6 shadow-2xl">
      <h1 class="text-xl font-bold text-center text-blue-400 mb-1">
        🔁 Absensi Rutin Kelas
      </h1>
      <p class="text-xs text-slate-400 text-center mb-4">
        Masukkan token kelas yang diberikan oleh admin / wali kelas.
      </p>

      <?php if ($error): ?>
        <div class="mb-3 rounded-lg border border-red-500/60 bg-red-500/10 px-3 py-2 text-xs text-red-200">
          ⚠️ <?= htmlspecialchars($error) ?>
        </div>
      <?php endif; ?>

      <form method="POST" class="space-y-4">
        <div>
          <label class="block text-sm font-medium text-slate-200 mb-1">
            Token Kelas
          </label>
          <input
            type="text"
            name="token"
            value="<?= htmlspecialchars($token) ?>"
            class="w-full rounded-lg bg-slate-950 border border-slate-700 px-3 py-2 text-sm text-slate-100
                   focus:outline-none focus:ring-2 focus:ring-blue-500"
            placeholder="Misal: 8A2025XY"
            autocomplete="off"
          >
          <p class="mt-1 text-[11px] text-slate-500">
            Token ini biasanya dibagikan sekali di awal semester.
          </p>
        </div>

        <button
          type="submit"
          class="w-full inline-flex items-center justify-center gap-2 rounded-lg bg-blue-600 px-4 py-2.5
                 text-sm font-semibold text-white hover:bg-blue-500">
          ➡️ Masuk ke Halaman Absensi
        </button>
      </form>
    </div>

    <p class="mt-4 text-[11px] text-slate-500 text-center">
      Jika token tidak valid atau masa berlakunya habis, sistem akan menampilkan informasi di halaman berikutnya.
    </p>
  </div>

</body>
</html>
