<?php
header('Content-Type: application/json');
error_reporting(0);
ini_set('display_errors', 0);

require __DIR__ . '/../../inc/db.php';
date_default_timezone_set('Asia/Jakarta');

$token       = $_POST['token'] ?? '';
$student_id  = (int)($_POST['student_id'] ?? 0);
$new_name    = trim($_POST['new_name'] ?? '');

$tanggal = trim($_POST['attendance_date'] ?? '');
if ($tanggal === '') {
  $tanggal = date('Y-m-d');
}

$activity_id = isset($_POST['activity_id']) && $_POST['activity_id'] !== ''
  ? (int)$_POST['activity_id']
  : null;

$status = $_POST['status'] ?? 'Hadir';
$allowed_status = ['Hadir', 'Izin', 'Sakit'];
if (!in_array($status, $allowed_status, true)) {
  $status = 'Hadir';
}

if (!$token) {
  echo json_encode(['success' => false, 'message' => 'QR tidak valid.']);
  exit;
}

$q = $conn->query("SELECT * FROM attendance_qr WHERE qr_token='$token'");
$qr = $q ? $q->fetch_assoc() : null;
if (!$qr) {
  echo json_encode(['success' => false, 'message' => 'QR tidak ditemukan.']);
  exit;
}

if (time() > strtotime($qr['end_date'])) {
  echo json_encode(['success' => false, 'message' => 'QR sudah kadaluarsa.']);
  exit;
}

$is_event = ($qr['qr_type'] === 'event');
$qr_id    = (int)$qr['id'];

// 🔥 FIX EVENT CLASS
if ($is_event && isset($_POST['class_id'])) {
  $class_id = (int)$_POST['class_id'];
} else {
  $class_id = (int)$qr['class_id'];
}

if ($is_event && $class_id <= 0) {
  echo json_encode(['success' => false, 'message' => 'Pilih kelas terlebih dahulu.']);
  exit;
}

// tambah nama baru
if ($new_name !== '') {
  $conn->query("INSERT INTO students (class_id, name) VALUES ($class_id, '$new_name')");
  $student_id = (int)$conn->insert_id;
}

$cek = $conn->query("
  SELECT id FROM attendance_daily
  WHERE student_id = $student_id AND tanggal = '$tanggal'
");
if ($cek && $cek->num_rows > 0) {
  echo json_encode(['success' => false, 'message' => 'Anda sudah absen hari ini.']);
  exit;
}

$activity_id_sql = $activity_id !== null ? $activity_id : 'NULL';
$source = $is_event ? 'qr_event' : 'qr_rutin';

$conn->query("
  INSERT INTO attendance_daily (
    student_id,
    class_id,
    qr_id,
    tanggal,
    jam_masuk,
    status,
    activity_id,
    keterangan,
    source,
    created_at
  ) VALUES (
    $student_id,
    $class_id,
    $qr_id,
    '$tanggal',
    '" . date('H:i:s') . "',
    '$status',
    $activity_id_sql,
    'QR',
    '$source',
    NOW()
  )
");

$response = [
  'success' => true,
  'message' => '✅ Absen berhasil tercatat!'
];

if ($new_name !== '') {
  $response['new_student_id'] = $student_id;
}

echo json_encode($response);
exit;
