<?php
require __DIR__ . '/../../inc/auth.php';
require __DIR__ . '/../../inc/db.php';

$title = "Daftar Link Rekap Publik";
ob_start();

$data = $conn->query("SELECT * FROM rekap_public_links ORDER BY created_at DESC");
?>

<div class="p-6 bg-[#141D2F] rounded-2xl border border-white/10 shadow-lg backdrop-blur-md">

  <!-- Header -->
  <div class="flex justify-between items-center mb-6">
    <h2 class="text-xl font-bold text-white tracking-wide flex items-center gap-2">
      <i class="fa-solid fa-link text-[#8CE0FF]"></i>
      Daftar Link Rekap Publik
    </h2>

    <a href="/system-absent/modules/rekap/generate.php"
      class="bg-gradient-to-r from-blue-500 to-cyan-400 hover:opacity-90 text-white px-4 py-2 rounded-xl font-semibold shadow-md transition-all duration-200">
      + Generate Link Baru
    </a>
  </div>

  <!-- Tabel -->
  <div class="overflow-x-auto rounded-xl border border-white/10">
    <table class="w-full border-collapse text-sm">
      <thead class="bg-[#1E2942] text-[#8CE0FF] uppercase tracking-wide text-xs">
        <tr>
          <th class="p-3 border-b border-white/10 text-left">Periode</th>
          <th class="p-3 border-b border-white/10 text-left">Link</th>
          <th class="p-3 border-b border-white/10 text-center">Status</th>
          <th class="p-3 border-b border-white/10 text-center">Kedaluwarsa</th>
          <th class="p-3 border-b border-white/10 text-center">Aksi</th>
        </tr>
      </thead>
      <tbody id="linkTable" class="text-white/90 divide-y divide-white/5">
        <?php if ($data->num_rows > 0): ?>
          <?php while($r = $data->fetch_assoc()):
            $isActive = strtotime($r['expired_at']) > time();
            $link = "https://ideaproper.my.id/rekap/" . $r['token'];
          ?>
          <tr data-id="<?= $r['id'] ?>" class="hover:bg-white/5 transition-all duration-150">
            <td class="p-3"><?= htmlspecialchars($r['start']) ?> s/d <?= htmlspecialchars($r['end']) ?></td>

            <td class="p-3 relative group">
              <a href="<?= $link ?>" target="_blank"
                 class="text-[#8CE0FF] hover:text-cyan-300 transition underline underline-offset-2 break-all">
                 <?= $link ?>
              </a>
              <button onclick="copyLink('<?= $link ?>')"
                      class="absolute right-2 top-1/2 -translate-y-1/2 text-[#8CE0FF]/40 hover:text-[#8CE0FF] opacity-0 group-hover:opacity-100 transition-all duration-300">
                <i class="fa-regular fa-copy"></i>
              </button>
            </td>

            <td class="p-3 text-center font-semibold <?= $isActive ? 'text-emerald-400' : 'text-red-400' ?>">
              <?= $isActive ? 'Aktif' : 'Kadaluarsa' ?>
            </td>

            <td class="p-3 text-center text-gray-400 expiredAt">
              <?= date('d M Y H:i', strtotime($r['expired_at'])) ?>
            </td>

            <td class="p-3 text-center flex justify-center gap-2">
              <button onclick="openExtendModal(<?= $r['id'] ?>)" 
                      class="px-3 py-1 bg-[#1E2B44] hover:bg-[#26375A] border border-white/10 rounded-lg text-[#8CE0FF] text-xs transition-all duration-200 shadow-sm">
                <i class="fa-solid fa-clock-rotate-left mr-1"></i> Perpanjang
              </button>
              <button onclick="deleteLink(<?= $r['id'] ?>)" 
                      class="px-3 py-1 bg-red-600/20 hover:bg-red-600/40 border border-red-600/30 rounded-lg text-red-400 text-xs transition-all duration-200 shadow-sm">
                <i class="fa-solid fa-trash-can mr-1"></i> Hapus
              </button>
            </td>
          </tr>
          <?php endwhile; ?>
        <?php else: ?>
          <tr><td colspan="5" class="p-5 text-center text-gray-400 italic">Belum ada link rekap yang dibuat.</td></tr>
        <?php endif; ?>
      </tbody>
    </table>
  </div>
</div>

<!-- Modal Perpanjang -->
<div id="extendModal" class="hidden fixed inset-0 bg-black/50 backdrop-blur-sm flex items-center justify-center z-[9999]">
  <div class="bg-[#141D2F] border border-white/10 rounded-2xl p-6 w-[90%] max-w-sm shadow-2xl text-white animate-fadeIn">
    <h3 class="text-lg font-semibold mb-4 text-[#8CE0FF] flex items-center gap-2">
      <i class="fa-solid fa-clock-rotate-left"></i> Perpanjang Masa Aktif
    </h3>
    <p class="text-gray-300 text-sm mb-3">Pilih durasi tambahan:</p>
    <div class="grid grid-cols-3 gap-2 mb-5">
      <?php foreach ([1, 3, 7, 14, 30] as $d): ?>
      <button onclick="extendLinkConfirm(this, <?= $d ?>)" 
              class="px-3 py-2 bg-[#1E2B44] hover:bg-[#26375A] border border-white/10 rounded-lg text-sm text-[#8CE0FF] transition-all duration-200">
        +<?= $d ?> hari
      </button>
      <?php endforeach; ?>
    </div>
    <button onclick="closeModal()" class="w-full py-2 bg-gray-600/30 hover:bg-gray-700/50 rounded-lg text-sm text-gray-300 transition">Batal</button>
  </div>
</div>

<script>
let selectedId = null;

// === Copy Link ===
function copyLink(link) {
  navigator.clipboard.writeText(link);
  showToast('✅ Link berhasil disalin ke clipboard!', 'success');
}

// === Modal ===
function openExtendModal(id) {
  selectedId = id;
  document.getElementById('extendModal').classList.remove('hidden');
}
function closeModal() {
  document.getElementById('extendModal').classList.add('hidden');
  selectedId = null;
}

// === Perpanjang Link ===
function extendLinkConfirm(btn, days) {
  if (!selectedId) return;

  // Tombol loading sementara
  btn.disabled = true;
  btn.innerHTML = "<i class='fa-solid fa-hourglass-half animate-spin mr-1'></i> Memproses...";

  fetch(`/system-absent/public_api/rekap_extend.php?id=${selectedId}&days=${days}`)
    .then(r => r.json())
    .then(res => {
      if (res.success) {
  closeModal();

  // ambil baris tabel berdasarkan ID
  const row = document.querySelector(`tr[data-id="${selectedId}"]`);
  if (row) {
    const expiredTd = row.querySelector(".expiredAt");
    if (expiredTd) {
      // gunakan tanggal terbaru dari API
      let displayText = res.display;

      // fallback manual kalau ada parsing error
      if (!displayText || displayText.includes("Invalid")) {
        const d = new Date(res.new_expired_at);
        if (!isNaN(d.getTime())) {
          displayText = d.toLocaleString("id-ID", {
            day: "2-digit",
            month: "short",
            year: "numeric",
            hour: "2-digit",
            minute: "2-digit"
          }).replace(".", "");
        }
      }

      // update teks kolom
      expiredTd.textContent = displayText;

      // tambahkan efek perubahan
      expiredTd.classList.add("bg-emerald-900/40", "text-emerald-300");
      setTimeout(() => expiredTd.classList.remove("bg-emerald-900/40", "text-emerald-300"), 1000);
    }
  }

  // tampilkan notifikasi
  showToast(`✅ Link diperpanjang ${res.days_added} hari (hingga ${res.display})`, "success");
} else {
        showToast(`⚠️ ${res.error}`, "error");
      }
    })
    .catch(() => {
      showToast("⚠️ Gagal memperpanjang link.", "error");
    })
    .finally(() => {
      btn.disabled = false;
      btn.textContent = `+${days} hari`;
    });
}


// === Update tampilan baris ===
function updateRowUI(id, newDateUTC) {
  const row = document.querySelector(`tr[data-id="${id}"]`);
  if (!row) return;

  // parse string UTC ke format lokal Indonesia
  const expiredCell = row.querySelector(".expiredAt");
  if (expiredCell) {
    const parsed = new Date(newDateUTC.replace(" ", "T") + "+07:00");
    expiredCell.textContent = parsed.toLocaleString("id-ID", {
      day: "2-digit", month: "short", year: "numeric", hour: "2-digit", minute: "2-digit"
    });
  }

  // ubah status ke Aktif (warna hijau)
  const statusCell = row.querySelector("td:nth-child(3)");
  if (statusCell) {
    statusCell.textContent = "Aktif";
    statusCell.classList.remove("text-red-400");
    statusCell.classList.add("text-emerald-400", "font-semibold");
  }

  // efek highlight
  row.style.transition = "background 0.6s ease";
  row.style.background = "rgba(34,197,94,0.15)";
  setTimeout(() => (row.style.background = "transparent"), 1000);

  // paksa DOM repaint supaya Tailwind reapply
  const clone = row.cloneNode(true);
  row.parentNode.replaceChild(clone, row);
}

// === Hapus Link ===
function deleteLink(id) {
  const confirmBox = document.createElement("div");
  confirmBox.className = "fixed inset-0 flex items-center justify-center bg-black/40 z-[9999]";
  confirmBox.innerHTML = `
    <div class="bg-[#141D2F] p-6 rounded-2xl border border-white/10 text-white text-center shadow-xl animate-fadeIn w-[90%] max-w-xs">
      <p class="mb-4 text-sm">Yakin ingin menghapus link ini?</p>
      <div class="flex justify-center gap-3">
        <button id="confirmDeleteYes" class="px-4 py-2 bg-red-600/80 hover:bg-red-600 rounded-lg text-white text-sm">Hapus</button>
        <button id="confirmDeleteNo" class="px-4 py-2 bg-gray-600/40 hover:bg-gray-700/50 rounded-lg text-gray-300 text-sm">Batal</button>
      </div>
    </div>`;
  document.body.appendChild(confirmBox);

  document.getElementById("confirmDeleteNo").onclick = () => confirmBox.remove();
  document.getElementById("confirmDeleteYes").onclick = () => {
    fetch(`/system-absent/public_api/rekap_delete.php?id=${id}`)
      .then(r => r.json())
      .then(res => {
        if (res.success) {
          const tr = document.querySelector(`tr[data-id="${id}"]`);
          tr.classList.add("opacity-0", "scale-95", "transition-all");
          setTimeout(() => tr.remove(), 400);
          showToast("🗑️ Link dihapus!", "success");
        } else {
          showToast("⚠️ " + res.error, "error");
        }
        confirmBox.remove();
      })
      .catch(() => {
        showToast("❌ Gagal hapus link.", "error");
        confirmBox.remove();
      });
  };
}
</script>


<style>
@keyframes fadeIn { from {opacity:0;transform:scale(.95);} to {opacity:1;transform:scale(1);} }
.animate-fadeIn { animation: fadeIn 0.25s ease-out; }
@keyframes pulseLight {
  0%, 100% { opacity: 1; }
  50% { opacity: 0.5; }
}
.animate-pulse {
  animation: pulseLight 0.6s ease-in-out 2;
}

</style>



<?php
$content = ob_get_clean();
include __DIR__ . '/../../inc/layout.php';
