<?php
require __DIR__ . '/../../inc/auth.php';
require __DIR__ . '/../../inc/db.php';
header('Content-Type: application/json');

$id = (int)($_GET['id'] ?? 0);
if (!$id) {
  echo json_encode(['success' => false, 'message' => 'ID tidak valid']);
  exit;
}

// Hapus laporan
$q = $conn->prepare("DELETE FROM report_laporan WHERE id = ?");
$q->bind_param("i", $id);
$success = $q->execute();

// === Simpan ke logs ===
if ($success) {
  $userId = $_SESSION['user_id'] ?? 0;
  $userName = $_SESSION['nama_lengkap'] ?? $_SESSION['username'] ?? 'User';
  $tanggal = date('dmy');
  $urut = str_pad($id, 2, '0', STR_PAD_LEFT);
  $kodeLapor = $tanggal . '-' . $urut;
  $aksi = "Menghapus laporan kendala $kodeLapor";


  $log = $conn->prepare("INSERT INTO logs (user_id, module, action, created_at, category) VALUES (?, 'laporan_kendala', ?, NOW(), 'system')");
  $log->bind_param("is", $userId, $aksi);
  $log->execute();
}

echo json_encode(['success' => $success]);
