<?php
require __DIR__ . '/../../inc/auth.php';
require __DIR__ . '/../../inc/db.php';
header('Content-Type: application/json; charset=utf-8');

// --- Pastikan koneksi ada ---
if (!$conn) {
  echo json_encode(["error" => "Database connection failed"]);
  exit;
}

try {
  $sql = "
    SELECT 
      l.action,
      l.created_at,
      COALESCE(u.nama, u.username, 'User') AS user
    FROM logs l
    LEFT JOIN users u ON l.user_id = u.id
    WHERE l.module = 'laporan_kendala'
    ORDER BY l.created_at DESC
    LIMIT 100
  ";

  $result = $conn->query($sql);
  $data = [];

  if ($result) {
    while ($r = $result->fetch_assoc()) {
      $data[] = [
        'action' => htmlspecialchars($r['action']),
        'created_at' => date('d/m/Y H:i', strtotime($r['created_at'])),
        'user' => htmlspecialchars($r['user'])
      ];
    }
    echo json_encode($data);
  } else {
    echo json_encode(["error" => $conn->error]);
  }
} catch (Exception $e) {
  echo json_encode(["error" => $e->getMessage()]);
}
