<?php
require __DIR__ . '/../../inc/auth.php';
require __DIR__ . '/../../inc/db.php';

$title = 'Laporan Kendala';
$result = $conn->query("SELECT * FROM report_laporan ORDER BY created_at DESC");

ob_start();
?>
<div class="p-6">
  <h2 class="text-xl font-semibold text-[#8CE0FF] mb-5 flex items-center gap-2">
    <i class="fa-solid fa-triangle-exclamation text-yellow-400"></i>
    Laporan Kendala
  </h2>

  <div class="bg-[#141D2F]/70 border border-[#1E2B44] rounded-xl shadow-xl overflow-hidden relative">
  <table class="min-w-full text-sm text-gray-300 relative">
    <thead>
      <tr class="bg-[#1E2B44]/70 text-blue-300 border-b border-[#24385B]">
        <th class="py-3 px-4 text-center w-12">No</th>
        <th class="py-3 px-4 text-center w-28">Kode Lapor</th>
        <th class="py-3 px-4 text-left">Nama Pelapor</th>
        <th class="py-3 px-4 text-left">Isi Laporan</th>
        <th class="py-3 px-4 text-center w-40">Tanggal</th>
        <th class="py-3 px-4 text-center w-36">Status</th>
        <th class="py-3 px-4 text-center w-20">Aksi</th>
      </tr>
    </thead>
 <tbody>
<?php
if ($result->num_rows > 0):
  $no = 1;
  while ($r = $result->fetch_assoc()): ?>
  <tr class="hover:bg-[#1B2537]/60 border-b border-[#1E2B44] transition">
    <td class="py-3 px-4 text-center text-gray-400"><?= $no++ ?></td>
    <td class="py-3 px-4 text-center font-mono text-sky-400">
      <?php 
        $tanggal = date('dmy', strtotime($r['created_at']));
        $urut = str_pad($r['id'], 2, '0', STR_PAD_LEFT);
        echo $tanggal . '-' . $urut;
      ?>
    </td>
    <td class="py-3 px-4 font-medium text-white"><?= htmlspecialchars($r['nama_pelapor']) ?></td>
    <td class="py-3 px-4 text-gray-300"><?= nl2br(htmlspecialchars($r['isi_laporan'])) ?></td>
    <td class="py-3 px-4 text-center text-gray-400"><?= date('d/m/Y H:i', strtotime($r['created_at'])) ?></td>
    <td class="py-3 px-4 text-center relative align-middle">
      <span id="status-<?= $r['id'] ?>" 
            class="px-3 py-[6px] rounded-full text-xs font-semibold cursor-pointer transition-all duration-200 inline-block
              <?= $r['status']=='belum diproses' ? 'bg-yellow-500/20 text-yellow-300 hover:bg-yellow-500/30' : '' ?>
              <?= $r['status']=='sudah diproses' ? 'bg-green-500/20 text-green-300 hover:bg-green-500/30' : '' ?>"
            onclick="showConfirm(<?= $r['id'] ?>, '<?= $r['status'] ?>')">
            <?= ucwords($r['status']) ?>
      </span>
    </td>
    <td class="py-3 px-4 text-center">
      <button onclick="confirmDelete(<?= $r['id'] ?>)" 
        class="text-red-400 hover:text-red-300 transition">
        <i class="fa-solid fa-trash"></i>
      </button>
    </td>
  </tr>
<?php endwhile; else: ?>
  <tr>
    <td colspan="7" class="py-6 text-center text-gray-500 italic">Belum ada laporan</td>
  </tr>
<?php endif; ?>

</tbody>

  </table>
</div>

  <!-- Tombol Log Mengambang -->
<button onclick="openLogModal()" 
  class="fixed bottom-6 right-6 bg-[#1E3A8A] hover:bg-[#2563EB] text-white shadow-lg rounded-full p-4 transition-all duration-300 border border-[#60A5FA]/30 hover:scale-110 flex items-center justify-center z-[9999]"
  title="Lihat Log Aktivitas">
  <i class="fa-solid fa-clock-rotate-left text-lg"></i>
</button>
<!-- ========== MODAL LOG ========== -->
<div id="logModal" class="fixed inset-0 bg-black/60 hidden items-center justify-center z-[9998]">
  <div class="bg-[#141D2F] w-[90%] max-w-4xl rounded-2xl border border-[#1E2B44] shadow-2xl overflow-hidden animate-fadeIn">
    <div class="flex justify-between items-center bg-[#1E2B44]/80 px-5 py-3 border-b border-[#24385B]">
      <h3 class="text-[#8CE0FF] font-semibold text-lg flex items-center gap-2">
        <i class="fa-solid fa-clipboard-list"></i> Log Aktivitas Laporan Kendala
      </h3>
      <button onclick="closeLogModal()" class="text-gray-400 hover:text-white">
        <i class="fa-solid fa-xmark text-xl"></i>
      </button>
    </div>

    <div id="logContainer" class="max-h-[500px] overflow-y-auto p-4 text-sm text-gray-300">
      <div class="text-center text-gray-500 italic py-10">Memuat data log...</div>
    </div>
  </div>
</div>

</div>

<!-- ✅ Toast Container -->
<div id="toastContainer" class="fixed top-6 left-1/2 -translate-x-1/2 z-[99999] flex flex-col gap-2 items-center"></div>

<!-- ✅ Sound Effects -->
<audio id="sound-success" src="https://cdn.jsdelivr.net/gh/itsron717/assets-audio/success.mp3" preload="auto"></audio>
<audio id="sound-error" src="https://cdn.jsdelivr.net/gh/itsron717/assets-audio/error.mp3" preload="auto"></audio>
<audio id="sound-info" src="https://cdn.jsdelivr.net/gh/itsron717/assets-audio/info.mp3" preload="auto"></audio>

<style>
  ::-webkit-scrollbar { height: 6px; width: 6px; }
  ::-webkit-scrollbar-thumb { background: #1E3A8A; border-radius: 8px; }
  ::-webkit-scrollbar-track { background: #0f172a; }

  .toast {
    display: flex;
    align-items: center;
    gap: 10px;
    min-width: 280px;
    padding: 12px 20px;
    border-radius: 12px;
    color: white;
    font-weight: 500;
    font-size: 14px;
    box-shadow: 0 8px 25px rgba(0,0,0,0.4);
    backdrop-filter: blur(10px);
    opacity: 0;
    transform: translateY(-15px);
    transition: all 0.4s ease;
  }
  .toast.show { opacity: 1; transform: translateY(0); }
  .toast.success { background: linear-gradient(90deg,#22c55e,#16a34a); }
  .toast.error { background: linear-gradient(90deg,#ef4444,#b91c1c); }
  .toast.warning { background: linear-gradient(90deg,#f59e0b,#b45309); }
  .toast.info { background: linear-gradient(90deg,#3b82f6,#1d4ed8); }

  .confirm-box {
    animation: fadeIn 0.25s ease-out forwards;
  }
  @keyframes fadeIn {
    from { opacity: 0; transform: translateY(-6px); }
    to { opacity: 1; transform: translateY(0); }
  }
  
</style>

<script>
function playSound(type) {
  const soundMap = {
    success: document.getElementById("sound-success"),
    error: document.getElementById("sound-error"),
    warning: document.getElementById("sound-error"),
    info: document.getElementById("sound-info")
  };
  const audio = soundMap[type];
  if (audio) {
    audio.currentTime = 0;
    audio.volume = 0.4;
    audio.play().catch(() => {});
  }
}

function showToast(message, type = 'info') {
  playSound(type);
  const container = document.getElementById('toastContainer');
  const toast = document.createElement('div');
  toast.className = `toast ${type}`;
  toast.innerHTML = `
    ${type === 'success' ? '✅' : type === 'error' ? '❌' : type === 'warning' ? '⚠️' : 'ℹ️'}
    <span>${message}</span>
  `;
  container.appendChild(toast);
  setTimeout(() => toast.classList.add('show'), 100);
  setTimeout(() => {
    toast.classList.remove('show');
    setTimeout(() => toast.remove(), 400);
  }, 3000);
}

// ✅ Popup konfirmasi ubah status
function showConfirm(id, currentStatus) {
  document.querySelectorAll(".confirm-box").forEach(e => e.remove());

  const cell = document.getElementById(`status-${id}`).closest("td");
  const rect = cell.getBoundingClientRect();

  // 🔁 Tentukan status baru
  const nextStatus = (currentStatus === "belum diproses") ? "sudah diproses" : "belum diproses";

  // 🔽 Buat box konfirmasi
  const box = document.createElement("div");
  box.className = `
    confirm-box fixed bg-[#1E293B]/95 border border-[#2A3550]
    text-gray-200 text-xs font-medium px-4 py-2 rounded-xl shadow-lg
    flex items-center gap-3 backdrop-blur-md
    animate-fadeIn z-[9999]
  `;
  box.innerHTML = `
    <span>Ubah status menjadi <b>${nextStatus}</b>?</span>
    <button class="bg-green-500/80 hover:bg-green-500 text-white rounded-lg px-3 py-[2px] font-semibold">Ya</button>
    <button class="bg-gray-600/80 hover:bg-gray-600 text-white rounded-lg px-3 py-[2px] font-semibold">Batal</button>
  `;
  document.body.appendChild(box);

  const boxWidth = box.offsetWidth;
  box.style.left = `${rect.left + rect.width / 2 - boxWidth / 2}px`;
  box.style.top = `${rect.bottom + window.scrollY + 6}px`;

  const [btnYes, btnCancel] = box.querySelectorAll("button");
  btnCancel.onclick = () => box.remove();
  btnYes.onclick = () => {
    box.remove();
    ubahStatus(id);
  };
}


// ✅ Ubah status laporan
async function ubahStatus(id) {
  try {
    const res = await fetch(`/system-absent/modules/report/update_status.php?id=${id}`, { method: "POST" });
    const data = await res.json();
    if (data.success) {
      const el = document.getElementById(`status-${id}`);
      el.textContent = data.status.charAt(0).toUpperCase() + data.status.slice(1);
      el.className =
        "px-3 py-[6px] rounded-full text-xs font-semibold cursor-pointer transition-all duration-200 inline-block " +
        (data.status === "belum diproses"
          ? "bg-yellow-500/20 text-yellow-300 hover:bg-yellow-500/30"
          : "bg-green-500/20 text-green-300 hover:bg-green-500/30");
      showToast("Status diubah menjadi: " + data.status, "success");
    } else {
      showToast(data.message, "warning");
    }
  } catch (err) {
    console.error(err);
    showToast("Terjadi kesalahan server", "error");
  }
}

// ✅ Konfirmasi hapus tanpa reload
function confirmDelete(id) {
  document.querySelectorAll('.toast-confirm').forEach(t => t.remove());
  const container = document.getElementById('toastContainer');

  const toast = document.createElement('div');
  toast.className = `toast toast-confirm warning show flex items-center gap-3`;
  toast.innerHTML = `
    ⚠️ <span>Hapus laporan ini?</span>
    <button class="ml-3 bg-red-500/80 hover:bg-red-500 text-white px-3 py-[3px] rounded-lg text-xs font-semibold">Ya</button>
    <button class="bg-gray-600/80 hover:bg-gray-600 text-white px-3 py-[3px] rounded-lg text-xs font-semibold">Batal</button>
  `;
  container.appendChild(toast);

  // ✅ Ambil tombol
  const [btnYes, btnCancel] = toast.querySelectorAll("button");
  btnCancel.onclick = () => toast.remove();

  // ✅ Aksi hapus
  btnYes.onclick = async () => {
    toast.remove();
    try {
      const res = await fetch(`/system-absent/modules/report/delete_report.php?id=${id}`, { method: "POST" });
      const data = await res.json();
      if (data.success) {
        const row = document.querySelector(`button[onclick="confirmDelete(${id})"]`).closest("tr");
        if (row) {
          row.style.transition = "opacity 0.4s ease, transform 0.3s ease";
          row.style.opacity = "0";
          row.style.transform = "translateX(-10px)";
          setTimeout(() => {
            row.remove();
            renumberRows(); // 🔁 update nomor urut otomatis
          }, 400);
        }
        showToast("Laporan berhasil dihapus", "success");
      } else {
        showToast("Gagal menghapus laporan", "error");
      }
    } catch (err) {
      console.error(err);
      showToast("Terjadi kesalahan server", "error");
    }
  };
}

async function openLogModal() {
  const modal = document.getElementById("logModal");
  const container = document.getElementById("logContainer");
  modal.classList.remove("hidden");
  modal.classList.add("flex");

  container.innerHTML = "<div class='text-center text-gray-500 italic py-10'>Memuat data log...</div>";

  try {
    const res = await fetch("/system-absent/modules/report/get_logs.php");
    const data = await res.json();

    if (data.length > 0) {
      container.innerHTML = `
        <table class="min-w-full text-gray-300 text-sm border border-[#1E2B44] rounded-lg overflow-hidden">
          <thead class="bg-[#1E2B44]/70 text-blue-300 sticky top-0">
            <tr>
              <th class="py-2 px-3 text-left w-40">Tanggal</th>
              <th class="py-2 px-3 text-left w-32">User</th>
              <th class="py-2 px-3 text-left">Aksi</th>
            </tr>
          </thead>
          <tbody>
            ${data.map(row => `
              <tr class="border-b border-[#1E2B44] hover:bg-[#1B2537]/60 transition">
                <td class="py-2 px-3 text-gray-400">${row.created_at}</td>
                <td class="py-2 px-3">${row.user}</td>
                <td class="py-2 px-3">${row.action}</td>
              </tr>`).join('')}
          </tbody>
        </table>`;
    } else {
      container.innerHTML = "<div class='text-center text-gray-500 italic py-10'>Belum ada log aktivitas.</div>";
    }
  } catch (e) {
    container.innerHTML = "<div class='text-center text-red-400 italic py-10'>Gagal memuat log.</div>";
    console.error(e);
  }
}

function closeLogModal() {
  const modal = document.getElementById("logModal");
  modal.classList.add("hidden");
  modal.classList.remove("flex");
}

// ✅ Setelah baris terhapus, update nomor urut otomatis
function renumberRows() {
  const rows = document.querySelectorAll("tbody tr");
  rows.forEach((row, index) => {
    const numberCell = row.querySelector("td:first-child");
    if (numberCell) numberCell.textContent = index + 1;
  });
}
</script>


<?php
$content = ob_get_clean();
require __DIR__ . '/../../inc/layout.php';
?>
