<?php
ini_set('display_errors', 1);
error_reporting(E_ALL);

require __DIR__ . '/../../inc/auth.php';
require __DIR__ . '/../../inc/db.php';
header('Content-Type: application/json');

// Ambil ID laporan
$id = isset($_GET['id']) ? (int)$_GET['id'] : 0;
if ($id <= 0) {
  echo json_encode(['success' => false, 'message' => 'ID tidak valid']);
  exit;
}

// Cek koneksi
if (!$conn) {
  echo json_encode(['success' => false, 'message' => 'Koneksi database gagal']);
  exit;
}

// Ambil status lama
$q = $conn->prepare("SELECT status FROM report_laporan WHERE id = ?");
$q->bind_param("i", $id);
$q->execute();
$res = $q->get_result();

if ($res->num_rows === 0) {
  echo json_encode(['success' => false, 'message' => 'Data tidak ditemukan']);
  exit;
}

$data = $res->fetch_assoc();
$currentStatus = $data['status'];

// Tentukan status baru
$newStatus = ($currentStatus === 'belum diproses') ? 'sudah diproses' : 'belum diproses';

// Update status
$u = $conn->prepare("UPDATE report_laporan SET status = ? WHERE id = ?");
$u->bind_param("si", $newStatus, $id);
$ok = $u->execute();

// === Simpan ke logs ===
if ($ok) {
  $userId = $_SESSION['user_id'] ?? 0;
  $userName = $_SESSION['nama_lengkap'] ?? $_SESSION['username'] ?? 'User';
  $tanggal = date('dmy');
  $urut = str_pad($id, 2, '0', STR_PAD_LEFT);
  $kodeLapor = $tanggal . '-' . $urut;
  $aksi = "Mengubah status laporan $kodeLapor menjadi $newStatus";


  $log = $conn->prepare("INSERT INTO logs (user_id, module, action, created_at, category) VALUES (?, 'laporan_kendala', ?, NOW(), 'system')");
  $log->bind_param("is", $userId, $aksi);
  $log->execute();
  
  echo json_encode(['success' => true, 'status' => $newStatus, 'message' => "Status berhasil diubah ke $newStatus"]);
} else {
  echo json_encode(['success' => false, 'message' => 'Gagal memperbarui status']);
}
