<?php
require __DIR__ . '/../../inc/auth.php';
require __DIR__ . '/../../inc/db.php';

$msg = '';
$uploadDir = __DIR__ . '/../../uploads/';
if (!is_dir($uploadDir)) mkdir($uploadDir, 0777, true);

if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_FILES['logo'])) {
    $targetFile = $uploadDir . 'logo_lembaga.png';
    $check = getimagesize($_FILES['logo']['tmp_name']);

    if ($check !== false) {
        if (move_uploaded_file($_FILES['logo']['tmp_name'], $targetFile)) {
            $msg = "<div class='p-3 text-sm text-green-400 bg-green-800/30 rounded-md text-center'>✅ Logo berhasil diunggah dan diperbarui!</div>";
        } else {
            $msg = "<div class='p-3 text-sm text-red-400 bg-red-800/30 rounded-md text-center'>❌ Gagal mengunggah logo. Pastikan folder <b>/uploads</b> memiliki izin tulis.</div>";
        }
    } else {
        $msg = "<div class='p-3 text-sm text-yellow-400 bg-yellow-800/30 rounded-md text-center'>⚠️ File yang diunggah bukan gambar valid.</div>";
    }
}
?>

<div class="p-6 bg-[#141D2F] rounded-2xl border border-white/10 shadow-md">
  <h1 class="text-xl font-semibold text-[#8CE0FF] mb-4 flex items-center gap-2">
    🏫 Upload Logo Lembaga
  </h1>

  <?=$msg?>

  <form method="POST" enctype="multipart/form-data" class="space-y-3 mt-3">
    <input type="file" name="logo" accept="image/*" required
      class="block w-full text-sm text-[#B7C9E5] border border-white/10 rounded-lg cursor-pointer bg-[#0E1525] file:mr-4 file:py-2 file:px-4 file:rounded-md file:border-0 file:text-sm file:font-semibold file:bg-[#5B8CFF] file:text-[#0E1525] hover:file:bg-[#8CE0FF]">
    <button type="submit"
      class="bg-[#37F297] hover:bg-[#5BFFD9] text-[#0E1525] font-semibold px-4 py-2 rounded transition w-full sm:w-auto">
      Simpan Logo
    </button>
  </form>

  <?php
  $logoPath = __DIR__ . '/../../uploads/logo_lembaga.png';
  if (file_exists($logoPath)) {
      echo "
      <div class='mt-6 text-center'>
        <p class='text-[#8CE0FF] text-sm mb-2'>Logo Lembaga Saat Ini:</p>
        <img src='../../uploads/logo_lembaga.png' alt='Logo' class='mx-auto w-32 rounded-lg shadow-lg border border-white/10'>
      </div>";
  } else {
      echo "<p class='mt-6 text-center text-[#92A2C2] text-sm italic'>Belum ada logo diunggah.</p>";
  }
  ?>
</div>
